+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-03-02T08:29:00-07:00"
lastmod = "2017-06-20T22:46:00-06:00"
postamble = "Have a request for our series of Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Next up in our Aria Guides series: Handel. \"O sleep, why dost thou leave me?\", from his music drama/opera *Semele* is an understated stunner, a big departure from the rest of her note-littered, coloraturatastic arias. For young singers, it's a fantastic way of working on breath control, and singing in that \"not quite high enough\" register that many sopranos find difficult. Read on to find a few general guidelines to get you through this aria; along with your teachers and coaches, we can help keep things simple, and indulgent in the right ways.\n\n\\*Interesting little factoid: this aria is in E major, and in Handel's time, different keys had specific meanings. E major evokes joy, boisterousness, and a bright colour. It's worth noting that in Handel's *Giulio Cesare*, a few of Cleopatra's arias are in E major, including both \"Piangerò la sorte mia\" and \"Da tempeste il legno infranto\". There's more similarity between these two women than one may think. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553352754/media/2019/03/sqSleep.jpg"
publishDate = "2016-03-03T05:12:00-07:00"
related_articles = ["articles/aria-guides-deh-vieni-non-tardar.md", "articles/aria-guides-una-voce-poco-fa.md", "articles/aria-guides-quando-men-vo.md", "articles/aria-guides-ach-ich-fuhls.md"]
short_description = "For young singers, it's a fantastic way of working on breath control, and singing in that \"not quite high enough\" register that many sopranos find difficult. Read on to find a few general guidelines to get you through this aria; along with your teachers and coaches, we can help keep things simple, and indulgent in the right ways."
slug = "aria-guides-o-sleep-why-dost-thou-leave-me"
title = "Aria guides: O sleep, why dost thou leave me?"

+++
 1. There's so much to enjoy in this first phrase, and with the silence underneath Semele, Handel is hinting (loudly) that she should make the most of it. She just woke up, after all. It's important to stay connected to the written rhythms, even if you're going to take some liberty with them. There's tension in the way Semele begins singing on beat 2, and we should feel that syncopation, as gentle as it is. I'm a champion of coming in right _a tempo_, and then taking a bit of freedom while you're singing.

    It will help to organize these bars, too; this phrase has a bit of a division right before the trill on the A-natural. It's almost like the first few notes, starting and beginning on that B, are like a morning stretch, a very lovely yawn. Although you're singing "O" for the whole thing, it's as if the word "O" (if that counts as a word) actually begins at that A-natural trill. It doesn't mean you should take a breath in the middle of the phrase (this should all be done in one breath), but you should hear yourself begin to "speak" after the yawn is up.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456932036776/Aria-Guide---Semele---p1.jpg.jpg) {{% /md %}}</figure>
 2. They're not Handel's, but the way this editor has added phrase markings in the melody shared with Semele is wise advice to follow. The point is to bring out the inflection of English, and not fall into the trap of landing on "dost" because it's on a full beat. This goes for plenty of English Handel; the trick is to shake off the text setting for a moment, and remind yourself how you'd say the line.
 3. There's a similar moment here, under the word "visionary". It's easy to let the higher pitch on "vision-**a**-ry" affect the inflection of the word. You can counteract this tendency by giving a generous \[v\] at the start of the word, and letting it really lead towards "joys".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456932095703/Aria-Guide---Semele---p1-half.jpg.jpg)
    {{% /md %}}</figure>
 4. This "O sleep" is higher, and on the tonic note. It's a more insistent response to the first phrase, and finding a similar tension in the sustained E will make it easier to sing. You can treat the whole "O" as an extended pick-up to the next downbeat, on "sleep". Finally, decide on a reason to repeat the text in the last bar of this line. A good reason is that Handel wrote it that way, of course, but decide for yourself if the shorter echo is a more adamant plea; to us, it sounds like a brief memory of a _really good_ dream.
 5. There's some neat word painting in this little sequence - it's "deceptive". Be precise with the intonation on the G-natural versus the G-sharp, the A-sharp versus the A-natural. The sharped notes will need to feel quite a lot higher than their natural equivalents.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456932146913/Aria-Guide---Semele---p2.jpg.jpg)
    {{% /md %}}</figure>
 6. If you were to take just the melody of this line, there's a natural continuation through the end of this line, ending at "arms", which you can see in the excerpt below. Keep in mind that a new sentence starts here: "To my arms restore my wand'ring love". If you have the text clearly organized in your own head, we'll be able to hear the neat dovetail effect that Handel writes with the music overlapping the text. Also, I'm sure some English diction folks may disagree, but we prefer \[I\] for the first vowel in "restore", not \[i\].
 7. In the context of everything Semele sings, this melisma is a walk in the park. It's indulgent, almost sleepy - "wandering", really; yet things like melodic checkpoints and tight rhythm are just as important as they are in her wicked fast coloratura. Pay attention to the skeleton of the melisma (circled for clarity) to keep yourself and your listeners organized. In the first two bars, with those drops down a sixth, can be a bit lazy, more Strauss-like than strict. These lazy bits are contrasted with the little runs of thirty-second notes; these should be clean and strict, keeping the rhythm clear. Finally, decide where you want or need to breathe, and don't apologize for it.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456932218593/Aria-Guide---Semele---p3.jpg.jpg)
    {{% /md %}}</figure>
 8. Our favourite note of this bar is that tiny, almost hidden, D-sharp on the second beat. Be sure that this note is in tune, and that it could vibrate easily if you were to pause on the pitch.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456932291692/Aria-Guide---Semele-p4.jpg.jpg)
    </figure>
 9. Here's some more immediate text repetition, and it's not without meaning. She only starts the sentence the first time, and with the repetition, the full idea blooms. You've said this text before this point, but imagine a reason for Semele to restart her thought; try it out as spoken text for yourself, and see what feels natural. Many sopranos grab a breath before the extended "restore" in the second line; if you can make it, it's better to breathe between the two iterations of "To my arms", and go through until the end of "restore".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456932468871/Aria-Guide---Semele---p5.jpg.jpg)
    {{% /md %}}</figure>
10. There's an opportunity for a cadenza here, if you'd like. If you're able to call the shots on what you do, have fun and bring out what you do best. Simple is best here, considering the mood of the aria. It's also an opportunity for Semele to show off some subtelty, in the midst of a piece that has her singing so many notes it's blinding. The rule often applies to Mozart, but it's a tasteful touch to keep your cadenza no higher than the highest note written in the aria - in this case, it's a G-sharp.

To finish on an utterly gorgeous note, here's a recording of [Jane Archibald](/scene/people/jane-archibald/) singing the aria during the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s 2012 production of _Semele_. *Personal note: I was lucky to have the chance to work as music staff for this production, and Jane was totally spectacular.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/1ILm0yAyh-U" frameborder="0" allowfullscreen></iframe>
</figure>