+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-05-25T21:41:00+01:00"
lastmod = "2016-05-26T12:56:00+01:00"
postamble = "Have a request for our Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com). Plus, head over to our [Schmopera Store](http://store.schmopera.com/collections/womens-t-shirts/products/they-call-me-mimi-womens-t-shirt) to get your Mimì apparel!"
preamble = "Next up in our series of Aria Guides: [Mimì's first aria](http://store.schmopera.com/collections/womens-t-shirts/products/they-call-me-mimi-womens-t-shirt) from Puccini's infamous *La bohème*. The aria is Mimì's response to Rodolfo's \"Che gelida manina\", and together, they form one of opera's most amazing moments of \"getting to know you\". Puccini's scores are rich in detail, and he doesn't leave much to the imagination. But along with your teachers and coaches, we can offer a few starting points as you get to work on this [delicious bit of music](http://store.schmopera.com/collections/womens-t-shirts/products/they-call-me-mimi-womens-t-shirt)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553307199/media/2019/03/sqMimi.jpg"
publishDate = "2016-05-25T23:03:00+01:00"
related_articles = ["articles/aria-guides-quando-men-vo.md", "articles/aria-guides-deh-vieni-non-tardar.md", "articles/aria-guides-insert-christmas-carol-here.md", "articles/aria-guides-embroidery-aria.md"]
short_description = "Next up in our series of Aria Guides: Mimì's first aria from Puccini's infamous La bohème. The aria is Mimì's response to Rodolfo;s \"Che gelida manina\", and together, they form one of opera's most amazing moments of \"getting to know you\". Puccini's scores are rich in detail, and he doesn't leave much to the imagination. But along with your teachers and coaches, we can offer a few starting points as you get to work on this delicious bit of music."
slug = "aria-guides-mi-chiamano-mimi"
title = "Aria guides: Mi chiamano Mimì"

+++
 1. This is the beauty of Puccini. He writes down everything you need to know, like this portamentos. The trick with this style of portamento is to make sure it's fully sung, on the initial vowel. In the first measure, take care to get spinning on the first B-flat, with a nice \[ɔ\] vowel; as you get to the top, you'll actually be singing that E-natural while still on the "-no" of "chiamano". It's almost like you get to the E early, and you're already sustaining that same pitch when you change to the word "Mimì". This is a subtle stylistic difference between Italian portamentos, and the kind you'd find in Massenet, for example. It shouldn't be the whole point of the gesture, just know that you have the time to really get to where you're going on the first vowel, before shifting to the next.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208810682/Aria-Guides---Mimi---annotated---p1.jpg.jpg) {{% /md %}}</figure>
 2. There are a few moments of speech-like intoning in Mimì's aria; it's about being _parlando_, as close to recitative that Puccini really gets. It means you can take the rhythm with a grain of salt. The eighth notes shouldn't be _too_ equal; try speaking the text first to find the Italian pulse in it, and then find the important syllables. For example, "storia" is more important than "la".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208820393/Aria-Guide---Mimi---annotated---p2.jpg.jpg)
    {{% /md %}}</figure>
 3. Often the _ritardando_ starts at "di", not "primavera"; it's less rushed that way, but be sure you recognize the difference in case you meet a conductor who wants to be more strict to the score. There's an implied _a tempo_ at the start of the last bar of this line. It's more for the orchestra than for the soprano, but you should feel a sort of snap back into time, like an elastic band; without this sense of _a tempo_, the stretchy effect of the _ritardando_ loses its power. One final detail: be sure you're really vibrating on the "-ma-" syllable in "primavera"; it'll let you do more with the stretchy tempo, and it will sound more beautiful.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208831588/Aria-Guide---Mimi---annotated---p3.jpg.jpg)
    {{% /md %}}</figure>
 4. More tempo details. Technically, everything right before "ma prego assai" is still _a tempo_. There's room for you to breath after "messa", but maintain the feeling of continuing, in time, as you take that breath. The _rallentando_ is only _poco_, and it should feel like a bit of a surprise on the word "ma". Mimì is talking herself up to Rodolfo here, and that bit about praying is an important detail to include. Puccini loves his pious women, after all.
 5. There's magic in this part, right? When the strings start to double the voice line, it can be easy to want to make more sound; avoid aiming for volume, and instead spend your energy on the amazing text. "Ma quando vien lo sgelo" gives you so many opportunities to keep on singing; there should be pitch on every consonant, and if you're able to sing through all those M's and N's and L's, your voice will be in a great spot for [maximum resonance](/quick-tips-the-rolled-r-test/). <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208848285/Aria-Guide---Mimi---annotated---p4.jpg.jpg)
    {{% /md %}}</figure>
 6. As you get to the climax of this section, you have oodles of time to stretch the eighth notes, like at the end of the word "primo". You can imagine that there's a tenuto marking on top of them, like the accent written for the orchestra doubling the voice.
 7. The same idea applies here, in the denouement. The portamento on "primo" should get you up to the "-mo" a bit early, and you have time to vibrate on that C-sharp. By the time you get to "è mio!", you're in the middle of a _rallentando_, and Puccini writes an accent. Notice that there's a harp roll underneath "mio"; that means that there will be even more time over that bar line for you to break our hearts with sound.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208859866/Aria-Guide---Mimi---annotated---p5.jpg.jpg)
    {{% /md %}}</figure>
 8. You can give yourself a head start on the _allargando_ with that tiny sixteenth note on the "gen-" of "gentil". Make sure it's a real moment of singing, full of spin. Some sopranos like to add a small portamento on "gentil"; if no one explicitly bars you from doing it, it can be a nice touch. At the end of this line on "fior", there's another of those implied _a tempos_ that you should feel in the word.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208870199/Aria-Guide---Mimi---annotated---p6.jpg.jpg)
    {{% /md %}}</figure>
 9. Pretend that the eighth notes in this line have tenuto markings over them. Each of them is shared by two separate syllables, and you should try and find as much spaciousness as you can to sing both vowels. Lots of sopranos like to add a portamento over "ahime!", and we think that's a lovely touch.
10. You have tons of room for this moment on "faccio", and you should enjoy it. Be sure to leave enough air in your tank to continue through the "ahimè". Puccini is specific about where to take a breath in this line, and there's something wonderful about a soprano who pushes the limits of her breath control in a place like this.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464208877953/Aria-Guide---Mimi---annotated---p7.jpg.jpg)
    {{% /md %}}</figure>
11. This always seemed like a weird way to end this aria, yet it's common performance practice to include it even when the aria is taken out of context, like in auditions. It's a real moment of acting, not singing; find the ease and flow in the Italian here, and like the other _parlando_ moments in the aria, don't get too hung up on the rhythmic specifics. Proportions are important, like how the end of "narrare" is written in longer values than the rest of the phrase; similarly, the little dotted rhythm at the end of "importunare" is a natural imitation of how the word is spoken. While there's no pulse _per se_, Puccini did take the time to notate subtle changes in rhythmic value.