+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2020-08-18T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "Hope you've had your coffee! This is Mercutio's aria from Act I of Gounod's _Roméo et Juliette_, based on Shakespeare's famous tragedy. This aria is a ballad to [Queen Mab](https://en.wikipedia.org/wiki/Queen_Mab), a mysterious fairy creature that gets into one's dreams; it's a breathless bit of excitement that sets up Mercutio as Roméo's outgoing, affable friend, so when he meets his end later in the opera, the loss sinks in deeply. With your teacher and coach, this Aria Guide is designed to help you dodge traps and stay breathing:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1592336238/media/2020/06/sqAriaGuide-Mab_daruom.jpg"
primary_image_credit = ""
related_articles = []
related_companies = []
related_people = []
short_description = "This aria is a ballad to Queen Mab, a mysterious fairy creature that gets into one's dreams; it's a breathless bit of excitement that sets up Mercutio as Roméo's outgoing, affable friend, so when he meets his end later in the opera, the loss sinks in deeply."
slug = "aria-guides-mab-la-reine-des-mensonges"
title = "Aria guides: Mab, la reine des mensonges"
youtube_url = ""

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605313/media/2020/05/AriaGuide-Mab-p1-annotated_dt52qh.jpg){{% /md %}}

</figure>

* Off we go! There's a big lesson in this first high E **(1)**: sing it as though you've got all the time in the world. You don't, in reality, but give yourself as much space as you can; some baritones like to use that M to hum a bit (on pitch!) and get the voice moving before finding that downbeat. And since these first two phrases go like the wind, ask yourself whether you need a real breath every time there's a rest. For example, the space between "Mab" and "la reine"; there's plenty of room, but the singing of it might be easier if it feels connected, rather than in fits and starts.
* There is always time to practice this part slowly **(2)**. Try and avoid the habit of landing heavily on the higher notes, like the first syllable of "légère"; you certainly want to try for a lightness in all this chatty writing, but that doesn't mean you get heavy with the beats. Try and imagine that this whole thing - from "Plus légère" to "Décevant" - is beat-free, like a swan gliding over still water. Hint: you can do this easily with _lots and lots_ of [slow practice](/the-practice-tip-you-dont-want-to-hear/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605327/media/2020/05/AriaGuide-Mab-p2-annotated_evyirm.jpg){{% /md %}}

</figure>

* This spot **(3)** can get you panting, if you're not careful. Here's a prime place to consider where you need to breathe; you can show the rests without sipping air, which will definitely help with stacking or hyperventilating. It'll also keep you more connected to this chromatic line, and it's worth spending a good amount of time singing it with no rests, just long lines and vowels.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605348/media/2020/05/AriaGuide-Mab-p3-annotated_vas4nw.jpg){{% /md %}}

</figure>

* The way this bit is written **(4)**, it's almost inevitable that a non-French speaker will thump heavily on the big beats here - the B-naturals on "-traî-" and "dans" and "-ther". Compensate for it with a bit of _accent d'insistance_, where you lean into the weaker syllables (and effectively, the weaker beats). It'll feel a bit like weird limping, but try and get comfy with the idea of leaning into "En-" and "-ne" and "l'é-" and "lim-". Then, when you get to the babbling at "Fut fait..." it's all about slow practice; these notes are easily made vague without the right amount of attention, so slow it way down and find the intonation traps hidden around these bars.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605370/media/2020/05/AriaGuide-Mab-p4-annotated_uwpegd.jpg){{% /md %}}

</figure>

* If you're going to get non-legato, you could theoretically do it here **(5)**. The orchestration changes to evoke riding on horseback, and for these four bars, you can be a bit deliberate about the big beats. Be diligent about the small notes, too; really sing a vowel on the first syllable of "grillon", and on the words "de" and "son". Later on this page, when you're moving in an out of keys at "dont la mèche blanche...", it's again all about slow practice. These pitches are twisty and tricky, and they require some planning ahead; treat them like a slow, _bel canto_ line in the practice room, and don't fall for any of Gounod's shenanigans.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605425/media/2020/05/AriaGuide-Mab-p5-annotated_gtg1df.jpg){{% /md %}}

</figure>

* This **(6)** is a place to coast, not to use energy. With your teacher, find a speech-like colour that allows you to basically recite in your speaking range, concentrating on smooth language and not fighting for tons of sound.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605444/media/2020/05/AriaGuide-Mab-p6-annotated_v5w9xv.jpg){{% /md %}}

</figure>

* At the top of this page **(7)**, be very specific with where you need to transition out of that speech-like sound and into more proper singing. These bars are a slow chromatic rise, so don't let it take you by surprise in your _passaggio_. By the time you're at "Et la liberté", you need to be thinking of the C-sharps in the line below.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605461/media/2020/05/AriaGuide-Mab-p7-annotated_ijujbd.jpg){{% /md %}}

</figure>

* Maintain your legato here **(8)** by bringing out the weak syllables again - the first syllable of "batailles", the middle syllable of "d'estocades", for example. Then, when you get to the _poco ritardando_ at "Elle lui verse..." let your voice release a bit in places like "lui" and the beginning of "rasades". It'll help you show your slower tempo, and shake off any tension you might have collected so far.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605475/media/2020/05/AriaGuide-Mab-p8-annotated_lrf49y.jpg){{% /md %}}

</figure>

* Keep up your _accent d'insistence_ here **(9)**, singing the eighth notes with the same conviction as the longer notes. You're still in chill-out land here, where spin is your friend, so take care to love each interval - particularly the surprising ones, like the C-sharp to D on "reposes" and the E-sharp to G-sharp on "ta couche". When you start the ascent on "Ô vierge!", consider where you're going; that low F-sharp is easy, but the E-natural on "bouche" takes a different kind of attention, so leave room for the whole range when you breathe for this phrase.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590605487/media/2020/05/AriaGuide-Mab-p9-annotated_vvljrv.jpg){{% /md %}}

</figure>

* For some reason, it's easy to go flat on "rêver" **(10)**, so take care with those vowels and give them each some vibrato. The fermata on "de" is a fun little moment of suspense; make sure you leave enough air so that the long "baisers" is comfortable to sing and spin. And finally, take a nice, early, slow breath before "Mab" begins again. It may be fast, but this aria is a marathon, not a sprint!

Phew! And now, for a bit of context (and gorgeousness): here's Russell Braun singing "Mab, la reine des mensonges" in Salzburg, 2008:

<figure data-type="video">{{% md %}}<<iframe width="1013" height="584" src="https://www.youtube.com/embed/llPvYE7D9Gc" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>