+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-08-17T20:57:00-04:00"
lastmod = "2017-08-18T11:12:00-04:00"
preamble = "Harlekin's aria is one of the more thoughtful, organic uses of the \"song within the song\" device in opera. In Richard Stauss' *Ariadne auf Naxos*, Harlekin is part of Zerbinetta's comedy troupe; when he and his fellow players are thrown into a serious case of stage improv, he sings a song for the lamenting Ariadne, \"Lieben, Hassen, Hoffen, Zagen\". It doesn't really cheer her up, but it certainly earns a chorus of satisfied sighs from his real-life audience.\n\nThis aria is dense and charming, and though it seems harmless, features more than a few surprising challenges. With the work you do in the practice room and with your teachers and coaches, our latest Aria Guide can help you navigate your way through this adorable little ditty."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503019393272/2017-08-18---Harlekin.jpg.jpg"
publishDate = "2017-08-18T11:12:00-04:00"
related_articles = ["articles/aria-guides-the-counts-aria.md", "articles/aria-guides-come-paride-vezzoso.md", "articles/aria-guide-o-du-mein-holder-abendstern.md"]
short_description = "This aria is dense and charming, and though it seems harmless, features more than a few surprising challenges. With the work you do in the practice room and with your teachers and coaches, our latest Aria Guide can help you navigate your way through this adorable little ditty."
slug = "aria-guides-lieben-hassen"
title = "Aria guides: &quot;Lieben, Hassen&quot;"

+++
1. Strauss packs these first two bars with what's basically a masterclass in [word painting](https://en.wikipedia.org/wiki/Word_painting). Each of these four words should sound like their meaning: "Loving, hating, hoping, fearing". If you're having trouble coming up with ideas, Strauss offers a few colour options with the dynamic markings, and those accents over "Hassen". <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503017778481/Aria-Guide---Harlekin---annotated-1.jpg.jpg)
   {{% /md %}}</figure>
2. Many baritones find it stressful to dive right into this high F; it's certainly not easy, but remind yourself that it doesn't have to be a Verdi-baritone moment. Try the "alle Lust" figure in reverse a few times in the practice room, so that you know how you'll want to approach the first A-natural. Help yourself up to the F by keeping on singing through both pitches of "alle"; even though it's not an important syllable, keep your voice spinning through the C-natural on "-le". Finally, after you're done with the "Lust", careful not to let your voice drop on "und alle Qual", since before long you'll have to return to that higher tessitura.
3. These rhythms are so-very-Strauss. Practice comparing the rhythm of "abgestorben auch der Pein" in spoken German to the way Strauss sets them musically. You should find a natural lilt in the text that gets jazzed up a bit by this music. If you don't need a breath before "auch der Pein", opt instead for a simple lift to keep the big-picture rhythm flowing smoothly.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503017791595/Aria-Guide---Harlekin---annotated-2.jpg.jpg)
   {{% /md %}}</figure>
4. Here's another example of fun syncopations; they should feel like they tumble forward, rather than leaning too heavily into the "off" part of the off-beats. Turn your ear towards the left hand of the piano, which should help you find your way to "sein!"<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503017799395/Aria-Guide---Harlekin---annotated-3.jpg.jpg)
   {{% /md %}}</figure>
5. Don't work too hard for volume down here at "Mußt dich aus dem Dunkel heben" If you think of it as a spoken line, the phrase should feel accessible and clear, with enough lightness to make for an easy trip up to "neue Qual!"<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503017808658/Aria-Guide---Harlekin---annotated-4.jpg.jpg)
   {{% /md %}}</figure>
6. This is another stressful spot for baritones, but it's another one of those times where it's not about The High Note. There's certainly a beautiful moment on "Leben" when you move from the D to the high F, but the phrase is by no means done; it's actually leading farther forward to the final "leben noch dies eine Mal". Knowing that it's not about the high note may not relieve any of the technical difficulty of this bar, but just like the similar place at the beginning of this aria, this line is about seeing the forest for the trees.
7. It looks so harmless, but many baritones find it easy to run out of air in these last few bars. Likely, you'll take a breath in the line above, just before "leben noch dies...", and carry through to the end. Be aware of how you land on the beginning of "eine"; if you let yourself drop into that comfortable low F (or over-darken the \[a\] vowel), you'll be less efficient with your air and the trip up to the C will cost you. In other words, for this last breath you take, stay up!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503017818974/Aria-Guide---Harlekin---annotated---5.jpg.jpg)
{{% /md %}}</figure>

> Readers, do you have an aria you'd like to see featured in one of our Aria Guides? Let us know in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).