+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2021-08-29T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Have a request for our Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "When the Duke sings [\"La donna è mobile\"](http://www.aria-database.com/search.php?sid=24a50bbfcebd847a80bdf4ae327a0c09&X=4&individualAria=265) in act III of Verdi's _Rigoletto_, it marks one of the most famous moments in all of opera. Probably in large part due to [Pavarotti himself](https://youtu.be/xCFEk6Y8TmM), this aria is in that upper echelon of the canon that's recognizable in the mainstream. This aria a dance, somewhat of a ditty; it would almost be fluff, if not for the Duke spewing some old-school chauvinist views on women. And, it's tricky to sing. With the guidance of your trusted teachers and coaches, this Aria Guide offers a great start for tenors to tackle \"La donna è mobile\" (\"Women are fickle\"):"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1629576839/media/2021/08/AriaGuide_LaDonna_blltrz.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-un-aura-amorosa.md", "articles/aria-guides-una-furtiva-lagrima.md", "articles/aria-guides-o-wie-angstlich.md"]
related_companies = []
related_people = []
short_description = "Probably in large part due to Pavarotti himself, this aria is in that upper echelon of the canon that's recognizable in the mainstream. This aria a dance, somewhat of a ditty; it would almost be fluff, if not for the Duke spewing some old-school chauvinist views on women."
slug = "aria-guides-la-donna-e-mobile"
title = "Aria guides: La donna è mobile"
youtube_url = ""

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492442/media/2021/08/AriaGuide_LaDonna_p1_annotated_full_sjqdfk.jpg){{% /md %}}

</figure>

When music is written in 3/8 time **(1)**, it nearly always has a big feeling of one beat to the bar. Keep that in mind throughout this aria, because it will keep you looking at the big picture. (Hint: the first sentence actually continues all the way to #2 below.) Let the first bar feel like a pickup to the next bar, and so on - and when you sing that fun little portamento on "è mobile", let it shoot you forward to the next downbeat. With all the square, simple phrasing in this aria, contrast will be key to keeping this interesting: Verdi starts you with _con brio_ (and hopefully, legato), then asks for crisper text at "qual piùma", then explicit legato at "muta d'accento", then with some virility at "Sempre un amabile". The many faces of an insufferable Duke.

This bit **(2)** is tricky because you have to balance the short note value on "mo-bil", with actually singing it. In the practice room, take out the rest and get used to how this phrase feels; then add in the rest gently, taking care to keep "mo-" spinning, even if it's short. And just over the page, below at "muta d'accento", it's common practice to take time on "-cento", and then snap back into tempo at "e di pensier".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492457/media/2021/08/AriaGuide_LaDonna_p2_annotated_cropped_top_n2a2l1.jpg){{% /md %}}

</figure>

Plan your breathing here **(3)**, so you don't tank up too soon. You'll need your best breath for the long F-sharp in the second line here, so plan for just a sip of air before "e di pensier". For the long F-sharp itself, work with your teacher to pace that crescendo, and keep your \[e\] vowel working for you. Verdi gives you a valuable tool in that extra crescendo on the F-double-sharp - it should help you over the A-sharp below.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492467/media/2021/08/AriaGuide_LaDonna_p2_annotated_cropped_skbwp9.jpg){{% /md %}}

</figure>

Practice this bit **(4)** without the dotted rhythm, to make sure you know where the short notes live in your voice. It's oddly common for tenors to end up flat on the B, and then the orchestra's chord comes in sounding slightly funky. Try to think of this phrase moving forward, not downward.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492487/media/2021/08/AriaGuide_LaDonna_p3_annotated_cropped_w69k18.jpg){{% /md %}}

</figure>

I'm skipping a bit of the second verse here **(5)**, but the aim is still about contrast. There are subtle differences in articulation here, like the staccatos on "È sempre..." and "chi a lei...", so really show those differences here.

Same section, same trickiness **(6)**: just make sure that you've got something a bit different up your sleeve for how you approach "d'accento". You can stretch this out in both verses, but find something new about the second time. Maybe the staccatos on this "e di pensier" are a laugh.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1630251910/media/2021/08/AriaGuide_LaDonna_p4_annotated_cropped_top_xfc8dp.jpg){{% /md %}}

</figure>

Same as before **(7)**: save your big breath for the long note. There's a common cadenza that gets plugged into the penultimate bar, with a long melisma that leads to a high B at the end. Like with any [cadenza](https://www.scoreexchange.com/scores/108777.html), you should feel free to experiment and show off your voice's best qualities. I'd say that a high B at the end has become an industry must-have. The last detail is in coordinating the last "pensier" with your pianist or conductor. One good answer is for the F#7 chord to go in between "di" and "pensier". Others like to be in unison for "pensier", which is cool, but slightly more risky. Listen to a few options, decide what works best for you, and then be prepared to adapt. (Conductors, right?)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629492545/media/2021/08/AriaGuide_LaDonna_p4_annotated_cropped_jnbecy.jpg){{% /md %}}

</figure>

Ready to hear the finished product out loud? I really do love [Pavarotti's rendition](https://www.youtube.com/watch?v=xCFEk6Y8TmM) from the 1987 [film production](https://www.imdb.com/title/tt0253590/) of _Rigoletto_, where his eyes are staring into your soul. But for something a bit more dramatically interesting, have a look at [Vittorio Grigòlo](https://www.schmopera.com/grigolo-rogue-teacher/)'s earnest, unsettling rendition in David McVicar's production at the [Royal Opera House](/scene/companies/royal-opera-house/) in 2017:

<figure data-type="video">{{% md %}}<iframe width="1010" height="568" src="https://www.youtube.com/embed/wKoa3BHHbB8" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>