+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-01-11T11:26:00-05:00"
lastmod = "2016-01-12T12:25:00-05:00"
preamble = "Continuing our series of Aria Guides, it's time for something French: \"Je veux vivre\" from Gounod's *Roméo et Juliette*. \n\nThis is Juliette's first aria, and she sings it after her nurse *yet again* brings up the fact that she has to get married to Paris. Juliette is young, and that can either mean she's giddy and exciteable, or that she's nervous and insecure about things like arranged marriages and being only 13 or so. \"Je veux vivre\" is a hugely popular pick for audition packages; it's not too long, it shows off some coloratura, and it's a great opportunity to show polished acting chops. Along with tried-and-true methods like voice teachers, coaches, and good old practice time, we offer up some handy tips for making the learning process a little easier. \n\nYou can follow along starting on page 49 of [this score](http://imslp.nl/imglnks/usimg/e/e3/IMSLP21548-PMLP49624-Gounod-RometJulietteVSch.pdf), or use the notated excerpts below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553353915/media/2019/03/sqVivre.jpg"
primary_image_credit = ""
publishDate = "2016-01-12T12:00:00-05:00"
related_articles = ["articles/aria-guides-aprite-un-po-quegli-occhi.md", "articles/aria-guides-una-voce-poco-fa.md", "articles/aria-guides-una-furtiva-lagrima.md"]
related_people = ["scene/people/nadine-sierra.md"]
short_description = "This is Juliette's first aria from Gounod's Roméo et Juliette, and she sings it after her nurse yet again brings up the fact that she has to get married to Paris. Juliette is young, and that can either mean she's giddy and excitable, or that she's nervous and insecure about things like arranged marriages and being only 13 or so. \"Je veux vivre\" is a hugely popular pick for audition packages; it's not too long, it shows off some coloratura, and it's a great opportunity to show polished acting chops. "
slug = "aria-guides-je-veux-vivre"
title = "Aria Guides: Je veux vivre"

+++
 1. What a way to start an aria, am I right? This line takes a lot of patient practice, and drilling the intonation is easier if you check your pitch on the piano, in four octaves - hearing the pitch is much easier than with a single note to match. Take advantage of the articulations that Gounod writes, too; you can be almost instrumental in the way you attack each note, and this squareness will help you stay in tune. The last detail to make your life easier: make sure that the last C-natural of Juliette's first bar is easy and vibrating.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452532571714/Aria-Guide---Je-veux-vivre-1---annotated.jpg.jpg) {{% /md %}}</figure>
 2. It's common performance practice to stretch the tempo a little bit over these two bars, specifically from the F to the A-natural on "-vre". It's wise not to practice this stretch too much while you're learning the aria (not every conductor will want to slow down). Keep the bars in time, and start to feel the ongoing pulse; if/when you do decide to stretch it, the rubato will still have rhythm in it. Performance practice to take time over this bar, but do it a bunch in time too, so it's still got rhythm in the stretch.
 3. These grace notes are a cornerstone of the whole aria. There's a frantic feeling in the way Gounod sets the text, all huffing and puffing and wavering. For as long as you can, practice these sections as though the quarter notes are long, extended dotted half notes; it'll help reinforce good breathing habits, and keep you from stacking breaths that are unnecessary. Leave out the grace notes for a few tries, and when you fit them in, start them as early as you can get away with. Some Juliettes sing this as a young woman's worldly excitement; I find that the grace notes give a feeling of a young girl's hyperventilation over her impending arranged marriage.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452532585325/Aria-Guide---Je-veux-vivre-2---annotated.jpg.jpg)
    {{% /md %}}</figure>
 4. Gounod switches up his pattern in this measure, giving you a luscious half note to sing through, leading right back to the main theme. Make sure you have a great \[ɔ\] vowel for "encor", and think of eliding the B-flat you're singing with the grace note coming up on the same pitch. The only thing you need to do is bring in the "Dou-" of "Douce" nice and early.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452532960960/Aria-Guide---Je-veux-vivre-3---annotated.jpg.jpg)
    {{% /md %}}</figure>
 5. Stay in a feeling of one beat to the bar here, to avoid getting heavy as you creep upwards. The G-sharp on "comme" should be free and vibrating; if you want to stretch the tempo of this phrase, this downbeat will be the place to indicate it.
 6. The common practice is for Juliette to sing the upper line, indicated in this edition (Choudens). The effect of this little lick comes across best when it's kept in time, like some improvisatory flair. In the cute little arpeggio that finishes the line, make sure each note has a bit of vibrato, so it doesn't sound too chirped. On the last note, take care and sing through the rolled R in "trésor".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533116362/Aria-Guide---Je-veux-vivre-4---annotated.jpg.jpg)
    {{% /md %}}</figure>
 7. These jumps down to the low E can be super light; I think it's more about the double-dotted rhythm rather than the actual pitches. There are funny little breath marks in this B-section, like before "ne dure hélas!"; these are really just breath marks, and they don't indicate a lift in the tempo.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533561280/Aria-Guide---Je-veux-vivre-5-0-annotated.jpg.jpg)
    {{% /md %}}</figure>
 8. Under these three bars is a quick hemiola effect. It's not a big deal, not worth overthinking; but you can bring it out by giving a great double S on "cède".
 9. These beautiful bars should be a place to take advantage of the sustained singing and relax a bit. Be careful not to whack the half notes, since an accent on the second beat takes away from the melodic figure; think of singing two bars at a time, and give yourself enough voice on the downbeat eighth notes to come away from the half notes.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533821242/Aria-Guide---Je-veux-vivre-6---annotated.jpg.jpg)
    {{% /md %}}</figure>
10. Many sopranos like to ground this chromatic scale, by leaning into the first note, as well as the high A at the top. The descending half of the run should flow right into the (implied) Tempo I at the end of the line. As you practice this, check in with your intonation on the D-sharp/E-flat.
11. Take your good breath before "âme", so that you can continue right through to the end of "trésor" (continues below). You can add a bit of a fermata on the high B-flat; there should be rhythm in the way you come out of it in the last bar of this line. There's a _crescendo molto_ marked over this whole phrase, so it needs to move right to the end; be sure that any stretching you do over the high B-flat doesn't interrupt that motion.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533856453/Aria-Guide---Je-veux-vivre-7---annotated.jpg.jpg)
    {{% /md %}}</figure>
12. One of the biggest traps in this aria is this phrase starting at "Loin de l'hiver". As you finish the previous phrase, know this next tempo well; when I play this aria for singers, I almost always have to stretch this bar of "Loin", much for than the "très peu" that Gounod marks. It's about reminding yourself that you don't yet have a chance to rest, and the breath you take after "trésor" should be one that moves you forward.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533892557/Aria-Guide---Je-veux-vivre-8---annotated.jpg.jpg)
    {{% /md %}}</figure>
13. Here's another short moment of hemiola, under "rose avant de l'effeuiller." You can bring it out by following the natural stress of the French: "**rose** a**vant** de **l'ef**feuil**ler**." The hemiola can help you sing a measured ritardando as well, and keep you ready for the Tempo I (and coloratura) to come.
    <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533921784/Aria-Guide---Je-veux-vivre-9---annotated.jpg.jpg)
    {{% /md %}}</figure>
14. These first bars of scales are divided into two-bar mini phrases. Think of the first bar of "Ah!" as a pick up to the second. When it's time for Juliette to sing those silly scales coming down from the high A (shown below), it should feel similar to singing four sustained A's; the scales downward should be light, like a ricochet off of each downbeat.
15. It's performance practice to be late on this trill, and snag a good breath instead. Most sopranos come in around the third beat this bar. When you do come in, remember that the trill on the A is just a long pick-up to the B-flat ("Poison Aria", anyone?). Make sure you have "room" to sing the B-flat comfortably, so it doesn't sound like you're hitting the ceiling.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452533991971/Aria-Guide---Je-veux-vivre-1--annotated.jpg.jpg)
    {{% /md %}}</figure>
16. The orchestration here can be jarring, since Gounod gets rid of all the downbeats. So, Juliette gets to be the one to be really rhythmic; think of a big, round 1 beat to the bar, and you can use consonant clusters like "fl" in "flamme" and the rolled R in "reste" to add some oomph to these empty downbeats.
17. Coloratura time! It's up to you to organize these notes; there are a few ways you can do it, but tuning each downbeat and staying light should be priorities no matter what. [Click here](/4-tips-for-when-there-are-too-many-notes/) to read our tips on singing coloratura, and this is definitely one to bring to your voice teacher. It can really help to remember that the sentence is, "Ah! comme un trésor..." Forward motion is always nice when the notes come in droves.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452534329600/Aria-Guide---Je-veux-vivre-11---annotated.jpg.jpg)
    {{% /md %}}</figure>
18. These trills start on the primary note, not the one above; it can help your clarity to begin each trill with a lean on the first note. Don't get too hung up on the tiny escape notes between the trills, or at least don't let them bog you down when you're trying to stay light. Leave some voice to really sing that high A, so it's got some ring to it. It's common performance practice to add a high C after the G on "encore"; I prefer a big, fat portamento coming down from the C to the final note, but it's all up to taste. However you end the aria, imagine that you're "bringing in the band" for that great orchestral playout.

Now, let's all have a listen to Nadine Sierra singing "Je veux vivre", just before she won the 2013 Neue Stimmen Competition in Gütersloh, Germany.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/zSvfktReyJo" frameborder="0" allowfullscreen></iframe>
</figure>