+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-09-20T16:28:00+01:00"
lastmod = "2016-09-22T09:43:00+01:00"
preamble = "Massenet's *Manon*, based on the novel by Abbé Prévost, is the story of a young woman with a large appetite for life, yet born within the confines of 18th-century France. Manon is a fascinating reflection of her audience; some may find her naïve, some may find her opportunistic. Be she benevolent or otherwise, Manon is a challenging, beautiful, and layered role for sopranos, starting with this aria in Act I, \"Je suis encor tout étourdie.\"\n\nIt's the first time we meet Manon, and she has just stepped out of the carriage that took her on her very first journey. Despite her being *en route* to a convent, Manon still finds excitement in all the new things surrounding her.\n\nAlong with your trusted teachers and coaches, we can offer up some tips and tricks to get you started with Manon, one of Massenet's many complicated ladies."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474482987221/2016-09-22---Manon.jpg.jpg"
publishDate = "2016-09-22T09:29:00+01:00"
related_articles = ["articles/aria-guides-embroidery-aria.md"]
short_description = "It&#039;s the first time we meet Manon, and she has just stepped out of the carriage that took her on her very first journey. Despite her being *en route* to a convent, Manon still finds excitement in all the new things surrounding her. Along with your trusted teachers and coaches, we can offer up some tips and tricks to get you started with Manon, one of Massenet&#039;s many complicated ladies."
slug = "aria-guides-je-suis-encor"
title = "Aria guides: &quot;Je suis encor tout étourdie&quot;"
+++

1. There's a natural quality about French when it's sung, and Massenet seems to go to a lot of trouble to notate the effect. You can see it in these tenuto markings above "suis" and "-cor," where Massenet insists on keeping the stress of the sentence in a few specific places. This aria is all about Manon's wonder at new places and sights, and by following the tenuto markings, it's easier to get that sense of wide-eyed awe. It's kind of like the subtext of each tenuto note should be "woooowwwwww."<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474385308106/Aria-Guide---Manon---p1---cut---resized.jpg.jpg)
</figure>

2. There's a little *rallentando* marked in the first bar of this line, and by the second bar, there's an implied snap back into tempo. There are more of these tenuto notes, but be careful not to schlep with the ties starting at "Ah! mon cousin!" They should propel the line forward to the next downbeat, without lingering in the middle of the bar.

3. As you rise up to this grand "étourdie," remember that there's a crescendo written as you move from the high A down to the G. That means that you'll need to arrive on the high A without yet giving everything away. Find an [i] vowel that allows the note to grow and get warmer, so you don't feel as though you need to muscle anything. As you get to the babbling bit at "Pardonnez...", ground yourself with the tenuto marking on "par-". Get comfy with the line by speaking it plenty (we personally find it a tongue-twister), and then find really long vowels to use as you put the text to music.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474385317531/Aria-Guide---Manon---p2---cut---resized.jpg.jpg)
</figure>

4. This is one of those bits that looks annoying on the page, but actually comes out quite naturally. Be diligent about learning this section in the correct rhythm; from there, you can find the larger beats, under those accented figures in the piano's right hand. When you get to "Les hameaux," make a real difference in your sound; you've gone from recit-like low singing to real legato, so find something in the text to make it an audible change.
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474386277889/Aria-Guide---Manon---p3---cut---resized.jpg.jpg)
</figure>

5. Let the rest between "voyageurs" and "jeunes" be one that moves you forward, like breathless excitement. You have time to enjoy a long vowel on "jeunes," under Massenet's tenuto marking. The portamento upwards to "Ah! mon cousin" isn't really a singing thing, the way Mimì does it in her aria; it's a Manon thing, so make sure that the portamento goes with a dramatic choice you make.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474483624020/Aria-Guide---Manon---p2b---cut---resized.jpg.jpg)
</figure>

6. Spend a lot of time with the intonation of this section. There are fun changes of harmony, like at "toute joyeuse," and at the last "pour le couvent." Check the D-natural on "joy-" before the F-natural, and be sure you're in tune at "Que je partais..." Those first couple of notes are tricky to hear, so train your ear early.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474386287419/Aria-Guide---Manon---p4---cut---resized.jpg.jpg)
</figure>

7. You can help lead the *poco rallentando* at "pour le couvent" by paying attention to how much vowel time you give to "le cou-". You have more time than you may think to vibrate through that great key change, and if you enjoy the vowels before the *a tempo*, you'll always be together with an orchestra.

8. More intonation stuff here. Massenet *really* wants you to notice that A-natural on "tant," so make sure you enjoy it. The combination of tenuto and piano marked above "nouvelles" will give an effect similar to a *fortepiano*, so give a healthy volume that that first E-flat, to give yourself room to get softer.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474386297448/Aria-Guide---Manon---p5---cut---resized.jpg.jpg)
</figure>

9. Here, Massenet is giving you the opportunity to release the voice and empty your lungs, so that you get a great breath before "avoir des ailes." Really sing the end of "croyais," rather than throwing the note away; you can afford to take your time with the next breath, and come in a bit late. Remember, the breath you take needs to have room for a high B-flat (below), not just the first half of "ailes."<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474484930178/Aria-Guide---Manon---p6a---cut---resized.jpg.jpg)
</figure>

10. Like before, you can control this *rallentando* with the length of your vowels. The "cou-" of "cousin" should be the longest, and it means you'll have time to check in with a conductor about the new *plus lent* tempo (or set it yourself).

11. There's just something so fabulously *dishonest* about these couple of bars; the way Manon sings the happy major interval under "tristesse," followed so quickly by a *piano* and a B-flat. Enjoy the last low D of "tristesse," and let the B-naturals be bright and sunny, to set up the change of heart on "Je pleurais..."<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474484957843/Aria-Guide---Manon---p6b---cut---resized.jpg.jpg)
</figure>

12. Spend time with this text, and try to find the most economical, relaxed way of articulating the French. Use the repeated notes to your advantage, and think of sending the air through them, rather than the consonants. Be picky about intonation on the D and F in "confesse," and know that the cadenza version is the most commonly done. You can control the pacing of the melismas and the laughs; remember to stay operatic about it, and be careful about singing the staccato laughing-notes too short.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474386322874/Aria-Guide---Manon---p7---cut---resized.jpg.jpg)
</figure>

13. For those of you doing the cadenza up to the C-sharp, take advantage of Massenet's *crescendo* and *forte* markings to help you up there. You can take the *pianissimo* on the way down with a grain of salt; what's really important is that you're in tune, so a conductor or pianist can catch you at the low F-sharp.<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474486613794/Aria-Guide---Manon---p8b---cut---resized.jpg.jpg)
</figure>

14. It's notated the same, but try out a few ways of singing this "Pardonnez" line, so you have another option this second time around. For the final "voyage" bit, it's most common to hear the higher *ossia* version. It's an odd ending to the aria out of context, but keep in mind the scene continues in the full opera. Make the most out of the high G on "voy-", and then be ultra-legato into the rest of the word, so you don't thump down on the last "-ge" syllable.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474487169162/Aria-Guide---Manon---p1---annotated---cut---resized.jpg.jpg)
</figure>

Massenet lovers, what are your French opera tricks and tips? let us know in the comments below! For now, enjoy a bit of *Manon* with Beverly Sills:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/YWQMTLvLqn0?start=40" frameborder="0" allowfullscreen></iframe>
</figure>

