+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-06-07T11:01:00-06:00"
lastmod = "2016-06-27T15:18:00-06:00"
preamble = "\"Il mio tesoro\", from Mozart's *Don Giovanni*, marks the first time we see Don Ottavio go from fawning, sensitive support system, to a real man with a plan. It's no easy task for a tenor; Mozart writes long phrases, big leaps, coloratura, and those trademark delicate phrase endings that can make any singer sweat. Tenors, while you consult your best teachers and coaches, we can offer you a few quick tips to help make some music out of this tough aria."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553302566/media/2019/03/Tesoro.jpg"
publishDate = "2016-06-26T23:17:00-06:00"
related_articles = ["articles/aria-guide-dies-bildnis-ist-bezaubernd-schon.md", "articles/aria-guides-dalla-sua-pace.md", "articles/aria-guides-quando-men-vo.md", "articles/aria-guides-insert-christmas-carol-here.md", "articles/aria-guides-the-composers-aria.md", "articles/aria-guides-un-aura-amorosa.md"]
short_description = "&quot;Il mio tesoro&quot;, from Mozart&#039;s Don Giovanni, marks the first time we see Don Ottavio go from fawning, sensitive support system, to a real man with a plan. It's no easy task for a tenor; Mozart writes long phrases, big leaps, coloratura, and those trademark delicate phrase endings that can make any singer sweat. Tenors, while you consult your best teachers and coaches, we can offer you a few quick tips to help make some music out of this tough aria."
slug = "aria-guides-il-mio-tesoro"
title = "Aria guides: Il mio tesoro"

+++
 1. Right off the bat, Mozart gives you a tricky phrase ending. Give yourself enough sound that you can come away from the end of "intanto"; the phrase rises up, and it can be easy to whack the last syllable of the word.
 2. Similarly, take care of the word "andate". Along with healthy sound on the "-da-" syllable, you can shorten the quarter note D; it will help with the word, and help indicate that little comma before you repeat yourself.<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311825102/Tesoro---annotated---1.jpg.jpg)
    </figure>
 3. Let this crescendo help you; this phrase can feel a little cramped for the tenor, but convince yourself that you have time to really sing those last two sixteenth notes. Try to squeeze out a vibration or two at the top; it'll sound nicer, and it will help you make that octave dive with more resonance.
 4. Get picky with your intonation here; these E-naturals need to be higher than you think. Plus, staying "up" will help you through this tricky spot in the voice without falling down; you've just got to go back up again, plus another step up to the G-natural.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311752139/Tesoro---annotated---2.jpg.jpg)
    {{% /md %}}</figure>
 5. You can afford to come in a bit late here; it's not about shaving some time off a long note, but it's about getting a great breath. Once you've taken your great breath, get a good start by making sure the first F (the short eighth note that comes before the long one) is in a healthy, spinning spot. There's a fine line between being air-efficient and air-stingy, and the latter won't help you with the former. If you hold back on that first short F, it may actually cut down on your stamina for The Big One; so, be brave and let it spin.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311835916/Tesoro---annotated---3.jpg.jpg)
    {{% /md %}}</figure>
 6. Some tenors like to change up the text here; from the previous line, they continue "cercate" until the half note B-flat, then breathe, then say "diasciugar" on the final three notes. It's a good plan if you don't have the air to make it all the way through "cercate diasciugar".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311849050/Tesoro---annotated---4.jpg.jpg)
    {{% /md %}}</figure>
 7. Mozart does the work for you in this section, so instead of trying to give extra oomph, you can continue singing long lines. It sounds very rectangular and powerful, but the effect best comes across when you sing legato. Keep the feeling of 2/2, one bar leading into the next.
 8. Be clean and precise with this short moment of coloratura. Often a tenor will overshoot the high G, but the grace notes are part of an even string of sixteenth notes that warrant clarity and control. <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311862019/Tesoro---annotated---5.jpg.jpg)
    {{% /md %}}</figure>
 9. Imagine that each of the eighth notes in this passage get a little tenuto. Pay attention to the vowel and vibrato on these shorter notes, and they'll strengthen the rising pattern; they need a bit of extra attention, so that they don't get audibly lost or skipped over. <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465318832712/Tesoro---annotated---6.jpg.jpg)
    {{% /md %}}</figure>
10. This melisma isn't easy, but keeping your sound light is a big key. As you come down from the high F on "nunzio", maintain that sense of height, so that you don't land heavily on the beginning of the coloratura.
11. Keep renewing the "ah" vowel on "tornar" as you make your way through this passage. It's not so fast that you can't find mini-checkpoints, like in the first bar, on the A and B-flat of beat 2, and the C and D of beat 4. When you pop up to the high G at the end of the line, resist the urge to over-sing; if you take the suggested breath before it, cut off the long E-flat soon enough to make it a comfy, relaxed breath, instead of a survival breath.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465318815246/Tesoro---annotated---extra.jpg.jpg)
    {{% /md %}}</figure>
12. Lots of tenors like to relax the tempo in these two bars of eighth notes; be careful of slowing down too much, too soon. You'll need a breath somewhere, and good spots to do that are either at the very end of the line, before "Il mio tesoro" returns, or in the middle of the final bar, before you repeat the high F. Your _ritardando_ will change, depending on where you breathe; once you've figured out what you'd like to do with this line, try conducting it to see it if makes rhythmic sense.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311888473/Tesoro---annotated---7.jpg.jpg)
    {{% /md %}}</figure>
13. Check in with your intonation on the E-flat on "Ditele" (and the same figure later in the line, on "vendicar"); it has a tendency to be too high. This is also another section where the music feels aggressive, but you're better off maintaining legato.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311899087/Tesoro---annotated---8.jpg.jpg)
    {{% /md %}}</figure>
14. The longer you hold this "vado", the more you should check in with your "ah" vowel. Imagine you're repeating it over and over, so it doesn't get stale, or start to tip back into your throat. A crescendo is an exciting effect that can lead organically into the fermata and octave drop; try and delay your crescendo until well into the second bar of holding that F. As you drop down the octave to the low F, imagine that you stay up high; the tendency is to land heavily on the "-do", but you've still got some high singing coming up.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311909372/Tesoro---annotated---9.jpg.jpg)
    {{% /md %}}</figure>
15. Add a little lean, or tenuto, on the starts of all these falling scales; it'll keep the melismas beautiful, and in your control.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311919080/Tesoro---annotated---10.jpg.jpg)
    {{% /md %}}</figure>
16. This is an exciting rhythmic moment on "nunzio", that should rocket you up to a big moment of triumph. While you're singing the off-beats, feel the tension as the quarter notes extend over each beat; rather than being percussive or overly articulate about the arpeggio up, you should have a sense of Strauss-like soaring. Anticipate each off-beat a little bit; if you're reacting to the strong beats, the syncopations will start to edge on the late side.

> Readers, what else do you have to add about this tricky tenor aria? Let us know in the comments below! Plus, if you want to request an aria for our Aria Guides series, send us an email at [hello@schmopera.com](mailto:hello@schmopera.com).