+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2019-09-22T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "What are your Puccini tips? Leave a comment, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Mimì's Act III aria is one of the gut-punch moments in Puccini's famed [_La bohème_](/aria-guides-mi-chiamano-mimi/). She sings it to Rodolfo right after they decide to break up. She talks about getting her things back from his place, and makes sure to say - maybe one too many times? - that they're separating without hard feelings.\n\nLyric sopranos fall easily in love with the music that Puccini writes for Mimì. As you work with your teacher on this aria, we can help you stay on track."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1568488249/media/2019/09/sqAriaGuide-Donde_sijzoy.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-mi-chiamano-mimi.md", "articles/aria-guides-je-suis-encor.md"]
related_companies = []
related_people = []
short_description = "Lyric sopranos fall easily in love with the music that Puccini writes for Mimì. As you work with your teacher on this aria, we can help you stay on track."
slug = "aria-guides-donde-lieta-usci"
title = "Aria guides: Donde lieta uscì"
youtube_url = ""

+++
* Simplicity is key at the start of this aria **(1)**. The range is easy, the rhythms are organic; Puccini doesn't want Mimì to give too much away just yet. Do be sure to sing the A-flat on the first part of of "**d'a**-mo-re"; it'll help your legato when you leap up to the E-flat.

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1568486554/media/2019/09/Screen_Shot_2019-09-14_at_2.42.10_PM_ls217l.png){{% /md %}}

</figure>

* This C-flat is tragic **(2)**, so give it some spin right away. Imagine the vowel already happening as you start "torna", and maintain your vibrato all the way through "Mimì".
* Get a head start here **(3)** with the rolled R in "Ritorna", so you can be really singing that pick-up E-flat. This is a big, sweeping phrase, and those really only work when every single note is sung. Puccini helps you with the _portamento_ in the word "Ritorna", where you can ride the spin of one vowel to connect two pitches. Pay attention to your vowels (are they morphing into something weird?) and your vibrato (does it tend to stop and start?) - and most importantly, be diligent about intonation on those G-flats.

  <figure data-type="image">{{% md %}}

![](https://res.cloudinary.com/schmopera/image/upload/v1567885068/media/2019/09/AriaGuide-Donde-p2_ynssza.png){{% /md %}}

</figure>

* More intonation stuff here **(4)**: the space between this E-flat and the D-natural is way smaller than you think. It's easy to fall flat on the D, so make sure you're still spinning sound on that pitch.

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567885080/media/2019/09/AriaGuide-Donde-p3_wfc6nk.jpg){{% /md %}}

</figure>

* Don't work too hard for this low stuff **(5)**. Puccini clears away the orchestra and marks it _col canto_; you can sing these short phrases at a comfortable volume, and let them be a speech-like, matter-of-fact moment to clear our palate before the lyric stuff coming next.

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567885091/media/2019/09/AriaGuide-Donde-p4_pwoznv.png){{% /md %}}

</figure>

* This **(6)** is some of that Puccini irony: he gets almost finicky with his tempo markings - a _ritardando_, then _col canto_, also a _ritenuto_ - but if everyone follows them, the musical effect is spontaneous and organic. It's handy to think of really observing the comma between the two "ascolta" statements; let the _ritenuto_ be a chance for you to sing two distinct \[a\] vowels, one to finish the first "ascolta", the next to start the second one. Last detail: be ready for the _a tempo_ to hit, and don't be late on "le poche...".
* If you make sure you're singing legato in this measure **(7)**, it'll be easier to do the staccato at "quel cerchietto d'or".

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567885101/media/2019/09/AriaGuide-Donde-p5_e4fvv4.jpg){{% /md %}}

</figure>

* Here **(8)**, Puccini gives you a _poco ritenuto_ to give you the space for a _portamento_. It's only _poco_, though, so keep practicing this corner as though there's no change in tempo, so your body doesn't get too used to slowing down. The _portamento_ will sound gentle and easy, but it requires active breath and a steady vowel to connect "quanto in un grembiale".

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567885114/media/2019/09/AriaGuide-Donde-p6_quxrff.png){{% /md %}}

</figure>

* This **(9)** is a pretty magical moment, a surprise key change and the singer coming in out of nowhere. Practice the transition into this new key more times than you think is necessary; because it's such a sudden change, you sort of need to hand-deliver the notes to our ears. Make sure you're vibrating right away on "Bada..."
* Consider doing these two instances of "Se vuoi" **(10)** in one breath. It's not actually that large a moment, particularly when the orchestra moves ahead underneath you. And because you'll have spent your air, you'll take a better breath at the "se vuoi serbarla" that comes after. You can also snag a breath before "a ricordo", where another smart soprano has made a breath mark. Regarding the big high notes: this is stuff to work on with your teacher, but I can at least advise that, in the big _portamento_ down from the B-flat, you think of moving forward, not down. You've just got that big A-flat coming up anyway.

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567885128/media/2019/09/AriaGuide-Donde-p7_b5zmld.png){{% /md %}}

</figure>

* The aria ends simply **(11)**, like it begins. This doesn't have to be a huge moment, and you might not even need the breath after "addio". Just leave enough steam to hang out on "ran-" and you'll have the audience in the palm of your hand.

  <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1567885138/media/2019/09/AriaGuide-Donde-p8_g8qmsl.png){{% /md %}}

</figure>

***

Here's one of my favourites: Ileana Cotrubas singing "Donde lieta uscì".

<figure data-type="video"><iframe width="637" height="478" src="https://www.youtube.com/embed/t_yVi2NWKYI" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

</figure>