+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2015-10-04T20:09:00-04:00"
lastmod = "2015-10-18T00:49:00-04:00"
postamble = "Questions? Want to request an aria for our Aria Guides? Let us know in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Readers, we've got a new treat for you! Welcome to our new series of posts that take you through popular arias of all voice types, step by step. We'll point out tips and tricks for making the learning process efficient, and try to answer as many FAQs about the repertoire as we can. To request an aria guide, send us your suggestions! Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).\n\nWe're starting with \"Deh vieni, non tardar,\" Susanna's famous aria from Mozart's *Le nozze di Figaro*. Use the excerpts for reference, or get the bigger picture on page 199 of [the vocal score](http://petrucci.mus.auth.gr/imglnks/usimg/8/89/IMSLP220533-SIBLEY1802.16871.abe9-39087011127240score.pdf) via IMSLP."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553351864/media/2019/03/sqDehVieni.jpg"
publishDate = "2015-10-07T08:00:00-04:00"
related_articles = ["articles/aria-guides-una-furtiva-lagrima.md", "articles/song-guides-die-nacht.md", "articles/aria-guides-o-sleep-why-dost-thou-leave-me.md", "articles/aria-guides-mi-chiamano-mimi.md", "articles/aria-guides-ach-ich-fuhls.md", "articles/aria-guides-didos-lament.md"]
short_description = "Readers, we've got a new treat for you! Welcome to our new series of posts that take you through popular arias of all voice types, step by step. We'll point out tips and tricks for making the learning process efficient, and try to answer as many FAQs about the repertoire as we can."
slug = "aria-guides-deh-vieni-non-tardar"
title = "Aria guides: Deh vieni, non tardar"

+++
### The Recit

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444183562645/AriaGuide---Deh-vieniRecitFirstHalf.jpg.jpg) {{% /md %}}</figure>

1. Everyone will have a different opinion about whether or not you should start "Giunse alfin" where it's written, or if you should wait until after the orchestra finishes their intro bit. I prefer it a little later, only because I think it makes more sense for the Italian. Starting on the last chord of the orchestra brings stress and weight to the word "giunse," which isn't really the rhythm of the sentence. If you wait until after the orchestra, the "giunse" can feel more like a pick-up to "alfin il momento," which speaks more naturally.
2. Keep in mind that the first sentence doesn't end until "in braccio all'idol mio." It changes the function of the small rests Mozart places throughout the phrase; rather than stopping the sentence, try and find a way to make the rests continue your thought. I compare it to speech; there's a difference between someone pausing mid-thought, and someone finishing an idea. The former is what you want in this recit. Otherwise it'll drag.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444183590254/AriaGuide---DehVieniRecitLastHalf.jpg.jpg) {{% /md %}}</figure>
3. It's common practice these days to come in as written on "Timide cure!" It doesn't mean it's the official rule, but it's a safe starting point.
4. Take your time in the arpeggio under "che all'amoroso foco." It's low, so perhaps it's scary to sing; rushing through is one solution, but it usually robs you of some potential sound.
5. Be sure to keep the last sentence, "come la notte..." intact. It's a common urge to include a pause between "i furti miei" and "seconda"; in my opinion the language doesn't really warrant a break. Still, it comes down to taste in the end; by speaking the lines, you may find there's an organic way to include the rest.

### The Aria

This aria is a reflection of how Susanna sees the Countess. She's dressed up as the Countess, and she pretends to sing a love song to the Count; there's huge sincerity in this "fake aria", because she's really singing it to Figaro (even though he doesn't know that and the whole show makes him mighty jealous). This is a departure from the way Susanna usually "speaks" (sings), and it's inspired by the way the Countess behaves in her arias. False nobility, but true sentiments; a drama-phile's dream.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444182312335/AriaGuide---DehVieniAria---AnnotatedFirstHalf.jpg.jpg)
{{% /md %}}</figure>

1. Connected to Susanna's embodying the Countess is attention to detail in every note. Be sure to really _sing_ every note, specifically the eighth notes throughout the lilting 6/8 meter. A supported, vibrating "Deh" is the way to sound ladylike; keep this up throughout the aria by paying attention to the connection from quarter note to eighth note.
2. The line, "finché l'aria e ancor bruna" is a bit of a mouthful. Mozart puts three vowels (a-e-a, connecting "l'aria e ancor") on one note; trust that you have enough time to sing all of them. <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444182348217/AriaGuide---DehVieniAria---AnnotatedLastHalf.jpg.jpg)
   {{% /md %}}</figure>
3. One the last page, you have two phrases that start "Ti vo' la fronte"; remember that these phrases start in the middle of the bar, and they're really an extended pick-up to the word "fronte." This usually means a gentler attack on "ti," and a bit of forward motion.
4. Each time you say "incoronar,"show off your Countess-like legato in that short sixteenth-note scale. Like the "l'aria e ancore" triphthong from earlier, trust that you have time to vibrate and give voice to each note. In both cases, true legato will be your friend for the bars that follow.
5. On the long F-natural over the second "incoronar," be a (tasteful) diva and enjoy the moment when the orchestra cuts off, and Susanna is left with a gorgeous, hanging note. Bonus tip to break hearts: leave yourself enough air to sing on the final [rolled R](/quick-tips-the-rolled-r-test/).
6. Finally, on the last "rose", _love_ that little grace note. Sing it like it's just for Figaro.