+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2015-11-27T14:21:00-05:00"
lastmod = "2017-05-12T15:56:00-04:00"
preamble = "For good reason, Don Giovanni is one of the most coveted baritone roles in opera. His aria, \"Deh vieni alla finestra,\" is an incredible scene, a picture of Don Juan in action, unencumbered by angry exes or jealous fiancés. He's serenading a nameless woman (Elvira's maid, technically), in that truly Spanish style, with a guitar outside her window. Mozart's music is perfect and Da Ponte's words are sexy, and the simplicity of it all gives us a chance to hear Giovanni do the thing he does better than anyone in the world. \n\nBaritones, this pick-up artistry is for you to master (at least in this aria), and this harder-than-it-looks aria is one to take to a voice teacher. In the meantime, here are a few ways to get a head start on the the tricky details. Follow along in the excerpts below, or starting on page 186 of [this score](http://javanese.imslp.info/files/imglnks/usimg/1/1a/IMSLP68957-PMLP36804-Mozart_-_Don_Giovanni_it-eng_Vocal_Score.pdf)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494618996268/2017-05-12---Window.jpg.jpg"
publishDate = "2015-11-27T16:38:00-05:00"
related_articles = ["articles/aria-guides-the-counts-aria.md", "articles/aria-guides-quando-men-vo.md", "articles/aria-guides-schweig-damit-dich-niemand-warnt.md"]
short_description = "For good reason, Don Giovanni is one of the most coveted baritone roles in opera. His aria, &quot;Deh vieni alla finestra,&quot; is an incredible scene, a picture of Don Juan in action, unencumbered by angry exes or jealous fiancés. He&#039;s serenading a nameless woman (Elvira&#039;s maid, technically), in that truly Spanish style, with a guitar outside her window."
slug = "aria-guides-deh-vieni-alla-finestra"
title = "Aria guides: \"Deh vieni alla finestra\""

+++
1. I'm a big advocate of singing pick-up notes, and this one is extra-important. Instead of just saying "Come to the window," Giovanni says "_Deh_ vieni," which is like saying "_Oh_ come," or _Please_ come..." It's the first note that the serenaded lady hears, and a good suitor sounds interested, but not desperate. Any Giovanni worth his salt knows that his easy, confident sound is more than enough.
   <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448651698217/Aria-Guides---Finestra---p1---annotated---cropped.jpg.jpg)
   {{% /md %}}</figure>
2. Take care with this C-sharp on "finestra", that it doesn't fall out of tune or into straight tone. The vowel is often the culprit here; be sure to pick an \[i\] vowel that has room to vibrate, as though it's longer than an eighth note.
3. The whole bar under "o mio" should feel like a pick-up to "tesoro". It's easy to add extra weight on the downbeat of "mio", but if you were to speak this line, "mio" wouldn't be where you would find the stress. Mozart is asking you to sustain an idea over the whole bar, sort of like building sexy anticipation.
4. This is a similar spot, under "il pianto mio." Musically, it feels like a new phrase begins in the middle of the bar, under "il..." but it's really a continuation of the phrase before. It still means you can take a breath if you need it, but be careful not to sit on "il"; instead, treat it like a slow pick-up to "pianto". The final piece of the puzzle is about creating a release (a diminuendo, actually) for "mio". Basically, you have to imagine no beats happening after you land on the downbeat under "pianto". All denouement, and not easy to do.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448651855825/Aria-Guides---Finestra---p2---annotated---cropped.jpg.jpg)
   {{% /md %}}</figure>
5. These lines should be delivered as though the words are happening to you in the present. There's a darker tone for "Se neghi a me di dar...", which happens naturally in the lower tessitura. The first four measures are all one phrase, and it's another spot where you'll have to resist adding musical stress to unstressed text. On both "qualche" and "ristoro" the stress is on the first syllable, so be sure to avoid landing on "-che" and "-ro", despite their being on downbeats.

   <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448651884711/Aria-Guides---Finestra---p4---annotated---cropped.jpg.jpg) {{% /md %}}</figure>
6. This A-sharp is totally melodramatic, and it's up to you to decide why. Imagine that you're trying to get away with singing the note longer than you should, and allow it to vibrate. For the octave drop that happens on "vogl'io", use the sound you've made on the high D to inform the low D. In other words, let it be light down there; it's much more attractive for your lady in the window.

   <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448651907216/Aria-Guides---Finestra---p5---annotated---cropped.jpg.jpg)
   {{% /md %}}</figure>
7. Second verse! Watch the slight rhythmic difference that's in this bar; it just means you can make more of of that great C-sharp on "dolce". I nerd out on strophic arias, because you get to make the notes mean new things with each new verse. This whole bit about the "bocca dolce più che il miele" is one sentence, and it should sound that way, too. If you don't _need_ to take a breath, try for one phrase here. On the "tu che il zucchero porti" bit, take advantage of the sultry consonants (especially that double K in "zucchero"). It'll help keep the music interesting, while making all the ladies (_and_ gents) lean in close to listen to you.
8. This is the first time Giovanni gives his lady an order (and really, what woman doesn't love that a little bit?), so save some virile colours for this moment. Bring out the "non", and definitely the "cru-" of "crudele". Gah, this aria is hot.

   <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448651918767/Aria-Guides---Finestra---p6---annotated---cropped.jpg.jpg) {{% /md %}}</figure>
9. The last juicy A-sharp. This time, it's more about how it leads to the word "bella" than anything else. Without scaring her away, use this opportunity to colour how Giovanni feels about this woman; he finds her _so beautiful_ that she made him sing that "wrong" note. Finally, even though the word "amore" is important, the music releases after that last octave drop down. Imagine that you sing this last word with a smile on your face, a raise of the eyebrow; really, anything that's not a question mark. Confidence is sexy, I hear.

For good measure, here's one of my favourite "Deh vieni" renditions, by the timeless Mr. Terfel. That second verse...

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/A6MLEumcr_k" frameborder="0" allowfullscreen></iframe>
</figure>

> Have questions? Want to request an aria for our Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).