+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2015-12-13T20:49:00-05:00"
lastmod = "2015-12-15T10:03:00-05:00"
preamble = "Ah, Don Ottavio. Is he the lame duck of *Don Giovanni*, or is he the quiet hero that doesn't get a lot of high notes? Whatever your opinions on the useless/heartfelt role of Ottavio, you can't deny that his arias are difficult, and often thankless. \"Dalla sua pace\" is an introductory piece to Ottavio's character; we get that he's sympathetic to Donna Anna's emotional highs and lows, and we know we'll never meet a more dedicated man when it comes to love.\n\nTenors, as you get to work on \"Dalla sua pace\" (a stunner when done well), be sure to involve your voice teachers. In the meantime, we can help get you off to a great start with a few tips from experience."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553303174/media/2019/03/DallaSuaPace.jpg"
primary_image_credit = ""
publishDate = "2015-12-15T10:03:00-05:00"
related_articles = ["articles/aria-guides-quando-men-vo.md", "articles/aria-guides-una-furtiva-lagrima.md", "articles/aria-guides-the-counts-aria.md", "articles/aria-guide-dies-bildnis-ist-bezaubernd-schon.md", "articles/aria-guides-il-mio-tesoro.md", "articles/aria-guides-o-wie-angstlich.md", "articles/aria-guides-un-aura-amorosa.md"]
short_description = "Ah, Don Ottavio. Is he the lame duck of Don Giovanni, or is he the quiet hero that doesn't get a lot of high notes? Whatever your opinions on the useless/heartfelt role of Ottavio, you can't deny that his arias are difficult, and often thankless. \"Dalla sua pace\" is an introductory piece to Ottavio's character; we get that he's sympathetic to Donna Anna's emotional highs and lows, and we know we'll never meet a more dedicated man when it comes to love."
slug = "aria-guides-dalla-sua-pace"
title = "Aria guides: Dalla sua pace"

+++
1. The overarching challenge in this aria is to keep it moving. The first bars offer the tenor no pulse onto which to latch, so he needs to create it himself. Mentally subdividing into sixteenth notes can help find direction; it also helps to take these first phrases in two-bar sections, with the first measure always leading into the second. On the little embellishments under "dipende" and "piace", there needs to be rhythm in them despite the stillness in the accompaniment. One little note: there are varying options for text underlay for "piace"; often the "-ce" is placed two sixteenth notes later, on the E-natural. In my opinion, the high G on the second syllable gives the impression of incorrect word stress, and moving the "-ce" later helps keep the word intact.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450060104806/Aria-Guide---Dalla---p1---annotated.jpg.jpg)
   {{% /md %}}</figure>
2. This line ascends into a tricky spot in many tenors' voices, but at least the vowels are mostly similar. Keep this in mind as you aim for legato on the way up; test yourself on "quel che le incresce" with the first F-natural, on the sixteenth note. If you're not able to let it spin and vibrate, you'll start to work too hard, and this is an aria about efficiency.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450060117243/Aria-Guide---Dalla---p2---annotated.jpg.jpg)
   {{% /md %}}</figure>
3. This figure on "morte" happens twice during the aria, and they're both notoriously scary moments for tenors. There are plenty of ways you can approach the high G, and your way should be something that's comfy and repeatable. Give yourself a head start by finding a nice, high, open \[ɔ\] vowel; continue to spin your sound through the rolled R, which gets released by the T. Using the consonants will help you avoid a hitch in legato or air speed, and this figure will be a little less terrifying.
4. This is a Mozart List, where a character rattles off a few examples of the emotion they're unpacking in their aria. Ottavio is saying that if Anna sighs, he sighs; if she's mad, he's mad, and so on. So, Mozart writes a chromatic figure for "sospiro", big angular intervals for "quell'ira", and a long wail for "pianto è mio". Take a cue from his [word-painting](https://en.wikipedia.org/wiki/Word_painting), and make onomatopoeia out of these words.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450060138890/Aria-Guide---Dalla---p3---annotated.jpg.jpg)
   {{% /md %}}</figure>
5. Starting here, this section can be exhausting for a tenor. It's a relentless tessitura, so get ahead of the difficulty by taking care in every descending passage. The short scales under "e non ho" can be nice and easy, as though an extension of the initial F-sharp; driving the sound downwards will make the next leap up to an F-sharp or G that much harder. Nota bene: this is a spot to take to your teacher, no doubt.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450060150437/Aria-Guide---Dalla-p4%20-%20annotated.jpg.jpg)
   {{% /md %}}</figure>
6. As this figure repeats, maintaining that sensation of height as you drop down to the low D in the cadenza; it'll help with your breath control, and you can do what you want with the last "non l'ha".
7. This is a moment where you really can move in this aria. Anticipate the three sixteenth notes leading into downbeats, reminding yourself that it's in 2, not in 4. Even the passing high Gs, in this case, aren't a real call for stretching the tempo. This is a section to keep simple, and tenors can often get a moment's rest out of these little phrases.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450060407836/Aria-Guide---Dalla---p5---annotated.jpg.jpg)
   {{% /md %}}</figure>
8. This junction between "mi rende" and "quel che..." seems to warrant one of those, "be a hero, don't take a breath" moments. You can totally take a breath, or not, whichever. If you breathe, make sure you're a) rhythmically follow-able, and b) breathing like you mean it. If you don't breathe, decide whether that C-natural belongs to the bar of "rende", or if it's part of "quel che le incresce"; again, you can do either phrasing, but commit to your choice.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1450060428053/Aria-Guide---Dalla---p6---annotated.jpg.jpg)
   {{% /md %}}</figure>
9. This is the kookiest way to end an aria, isn't it? So bizarre, but since it's by Mozart, it's also great. I see these bars as a challenge; the singer's task is _don't give in to the octave!_ This means not reaching up or down for the notes, but maintaining a high placement, and letting the lower notes ring easily, almost parlando. The low stuff will cut more that way, than trying to push for lots of volume.

> Have questions? Want to request an aria for our Aria Guides series? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).