+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-06-07T09:01:00-06:00"
lastmod = "2016-07-10T10:27:00-06:00"
preamble = "Belcore's aria from *L'elisir d'amore* is all about laying it on thick. He's after Adina, just like the opera's underdog/hero, Nemorino; he pulls out all the stops, like referencing literature, giving her flowers, and generally bragging about how awesome he is at life. It's a relatively rare moment of comedy for a baritone, although the aria doesn't come without its challenges. Along with your teachers and coaches, we offer up a few tips for wading through coloratura, and getting the best comedic bang for your buck."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468004512058/2016-07-08---Belcore.jpg.jpg"
publishDate = "2016-07-08T21:18:00-06:00"
related_articles = ["articles/aria-guides-aprite-un-po-quegli-occhi.md", "articles/aria-guides-the-counts-aria.md", "articles/aria-guides-schweig-damit-dich-niemand-warnt.md", "articles/aria-guides-sempre-libera.md", "articles/aria-guides-lieben-hassen.md"]
short_description = "Belcore's aria from L'elisir d'amore is all about laying it on thick. He's after Adina, just like the opera's underdog/hero, Nemorino; he pulls out all the stops, like referencing literature, giving her flowers, and generally bragging about how awesome he is at life. It's a relatively rare moment of comedy for a baritone, although the aria doesn't come without its challenges. "
slug = "aria-guides-come-paride-vezzoso"
title = "Aria guides: \"Come Paride vezzoso\""

+++
1. Right off the bat, Donizetti writes a pillar of _bel canto_ style, and that's the dotted rhythm, versus the triplet. It may sound like a subtle different, but singing this first phrase with a triplet feel completely changes the character of the music. There's something pompous and overdone about sticking to the tight dotted rhythms, which is exactly what Belcore is all about. Think of the dots as double or triple dots, and pull as much vowel time out of the long note as you can.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311641645/Belcore---annotated---1.jpg.jpg)
   {{% /md %}}</figure>
2. These triplets on "porse il pomo alla più bella" are in a tricky spot of the voice, but that's not what you want to advertise. On "porse", leave room to vibrate comfortably on both pitches; on "alla più bella", make honey out of the word "più".
3. This phrase should be funny, but not unbeautiful. It's should sound like Belcore thinks that Adina has never even seen a flower before, let alone be given one. While you're up there on "porgo", let the great rolled R add to the flourish; on the fermata over "questi", give it a dramatic impetus. Either he's drawing out the suspense (read: laying it on thick), or he's temporarily forgotten where he stashed the flower.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311650181/Belcore---annotated---2.jpg.jpg)
   {{% /md %}}</figure>
4. Belcore is getting a bit more serious here, and you can hear it in this temporary minor key. Get really picky with your intonation on the B-flats and E-flats. You can also try and stretch a bit of time out of the word "più" to play up the overcompensation that's going on.
5. As you get out of this cadenza, there should be a sense of tempo. There's nothing wrong with milking the top E, but by "premio del mio", a conductor or pianist should feel you sliding back into tempo.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311657760/Belcore---annotated---3.jpg.jpg)
   {{% /md %}}</figure>
6. There are some fun word painting opportunities here, and the more you overdo it, the better it will be. There should be oodles of confidence in "Veggo chiaro", and you have the time to stretch the high D to make it sound a bit more "chiaro". On "ch'io fo breccia nel tuo petto", you can play up the "breccia" bit, and you can afford to be a bit heavy-handed. Belcore is showing off what he thinks are mad skills, but the joke is he's telling everyone that he's a brutal date with cheesy moves.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311668952/Belcore---annotated---4.jpg.jpg)
   {{% /md %}}</figure>
7. More corny word painting here; the melisma on "sorprendente" should be a bit of a bluster, like some overly slick move on the dance floor that ends up knocking over a few people instead. When you get to "galante", stretch the "ga-" syllable so it's nice and overcooked.
8. For this bit of coloratura, stay light, especially over the tied notes. It's easy to lag behind if you sit on the longer notes, so think of coming away from them, almost releasing on the tied note. The effect is almost as if the three sixteenth notes lead forward to the next beat, rather than a ricochet away from the preceding long note.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311678153/Belcore---annotated---5.jpg.jpg)
   {{% /md %}}</figure>
9. It's common to alter this bar a little bit, so that you hold the long C until the orchestra plays that last chord of the line. Some may disagree, but it at least lets the audience hear your melisma more clearly, and it allows for you to shift the text around so it's a little less strange. Some baritones sing the word "madre" all on the long C, take a breath, and then since the melisma on a separate "ah"; they do the last scale upwards on "dell'" and wait until the last C-F to place "amor". Our personal taste: move the "madre" melisma to after the orchestra cuts out, but do it on the "ma-", and land on the "-dre" at the bottom; then, the scale up is on "dell'", and "amor" take the last two notes of the aria, with a nice portamento between them for a finishing touch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465311687054/Belcore---annotated---6.jpg.jpg)
{{% /md %}}</figure>

> Have an aria you'd like to see in our Aria Guides? Let us know at [hello@schmopera.com](mailto:hello@schmopera.com).