+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2020-08-11T04:00:00Z
disclaimer = ""
draft = true
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1596983092/media/2020/08/sqDoretta_u5rqrx.jpg"
primary_image_credit = ""
related_articles = []
related_companies = []
related_people = []
short_description = "short"
slug = "aria-guides-chi-il-bel-sogno-di-doretta"
title = "Aria guides: Chi il bel sogno di Doretta"
youtube_url = ""

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590608941/media/2020/05/AriaGuide-Doretta-p1-annotated_wxfggt.jpg){{% /md %}}

</figure>

* This aria starts **(1)** with one of those finnicky tempo markings that Puccini loves, the _rallentando_ into _a tempo_. It does seem a bit awkward for the singer, but remember that the _rallentando_ is referring to the staccato line happening in the bass. When you do come in, mid-_rall_, it's as though Magda is starting her version of this song with a bit of flair. Hanging out on these first two notes can be a bit of anticipation, a sort of drumroll for what will certainly be the finished, polished product that Prunier started just a few minutes prior.
* If you're really feeling the Italian text here **(2)**, you'll sense an urge to move ahead in these meandering couple of bars. A good pianist or conductor should be able to follow you as you push forward, just enough to suit the natural rhythm of the language. That said, don't go crazy with an _accelerando_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590608951/media/2020/05/AriaGuide-Doretta-p2-annotated_hz0zn4.jpg){{% /md %}}

</figure>

* When you start this tune for the second time here **(3)**, it should have some extra excitement. There's some heat in these words, about kisses and revelations and passion. In the line just below, at "Fu la passione!", Puccini gives the soprano and the whole orchestra a grace note; because it's a gesture for the whole ensemble, that little grace note will get more time and emphasis than most. Most sopranos like to tuck the letter "i" in "passione" into that grace note, and then sing a clear "o" for the D-natural. It's something to check with any Italian experts you know, but in my experience, this is the best way of organizing the grace note with this text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590608960/media/2020/05/AriaGuide-Doretta-p3-annotated_lssnvq.jpg){{% /md %}}

</figure>

* Ah, this tune **(4)**. This tune is everything. Sopranos know it, too, and it can be easy to overthink this line or try too hard to make it beautiful. So, with the help you'll get from your teacher and coach, I can offer these few tips: get comfy with your vowels first, then add in the consonants. Let the "F" in "Folle" help you get your air moving, but be careful not to waste too much breath on it. Enjoy the _portamentos_ between the A-F on "amore" and the G-E on "ebbrezza", because they're _delicious_. Renew your vowels on the third beat of each bar, to keep these high sustained notes alive _and gorgeous_. And finally, don't worry about your volume; I know a lot of sopranos like to show off a good float here, but don't fall into the comparison trap. Practice this bit at your comfortable volume, and then as a bonus, work with your teacher on refining the volume.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590608977/media/2020/05/AriaGuide-Doretta-p4-annotated_amt3su.jpg){{% /md %}}

</figure>

* Puccini gives you a breather here **(5)**, so enjoy how this tune tumbles gently down, and take care with that first semitone from F-E, so it doesn't fall flat. When you really dive down, like the low D on "ridir", remind yourself that you've got to pop back up high, so don't check out of the height you've created.
* The tune is back! And now there's a high C! Puccini gives you some help with this crescendo, which should serve as a pass to be brave, be loud, be your best soprano. It can help to imagine moving up to the C a bit early, so that it's more on your terms; however you pace this, remember to save enough energy for a show-off fermata on that C, plus the rest of the phrase that comes after. The real money note in this phrase, I think, is the tiny sixteenth note A on "mio", just after the C; if you keep that note vibrating and in tune, you'll be in control of the whole phrase, not just surviving it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590608991/media/2020/05/AriaGuide-Doretta-p5-annotated_i2ztvy.jpg){{% /md %}}

</figure>

* At the start of this line, just before **(6)**, this is the moment wher eyou want to have a special colour up your sleeve. It doesn't have to be super-duper quiet, just more quiet than you've been up to this point. The same rule applies for the "mia" here; sing that little note like a real _verismo_ lady. Finally, at **(6)**, spend time on every single vowel in this tune, and use those vowels to create the _tenuti_ on "importa". 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609004/media/2020/05/AriaGuide-Doretta-p6-annotated_sayjml.jpg){{% /md %}}

</figure>

* If you grab a breath here **(7)**, think ahead. I'd opt for just a sip of air before "se alfin", so that you're in a good spot to take a great breath for "la felicità" in the next bar. If you don't actually need a breath in that rest, try and make it a habit not to. When you get to "la felicità", keep it horizontal and legato; for some reason, it's easy to get heavy and thumpy here, because the orchestra starts to fill in and it gets all old-film-score. It's just so great.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609018/media/2020/05/AriaGuide-Doretta-p7-annotated_sinbap.jpg){{% /md %}}

</figure>

* Sing the little notes here **(8)**! Make sure you really know what pitch they are, and treat the sixteenth notes like they're opera-sized. In the practice room, try just moving from the F-sharp on "sogno", right to the B-flat on "d'or" with no extra note in the middle; once that feels solid, add in the low D on "-gno", and make it a real, vibrating part of this melody. If the little notes are left out, it pokes holes in your hard-earned legato. Finally, don't overthink this final "poter amar così". The _diminuendo_ on "amar" should feel like a stepwise motion, moving in blocks on that E-natural from _forte_ to _mezzoforte_ to _mezzopiano_ to _piano_, etc. It's a lot easier to pace this sort of terraced dynamic than to aim for a gradual thing - and in the end, it'll sound just as impressive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1590609027/media/2020/05/AriaGuide-Doretta-p8-annotated_txz1hx.jpg){{% /md %}}

</figure>

What a great little ditty, right? Let's all indulge in the sounds of a pro: here's Leontyne Price's rendition of "Chi il bel sogno di Doretta", from Puccini's _La rondine_:

<figure data-type="video">{{% md %}}<iframe width="1280" height="720" src="https://www.youtube.com/embed/53sFK1ZDYxY" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>