+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-11-28T22:01:00+00:00"
lastmod = "2016-11-29T21:37:00+00:00"
postamble = "Have an aria you'd like to request for our Aria Guides series? Let us know in the comments below, or get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)"
preamble = "Pamina's aria from Mozart's *Die Zauberflöte* feels like the epitome of sadness, an emotional archetype amplified by some of the saddest music in opera. By the time she sings \"Ach, ich fühl's,\" she's had a rough day. Her mother told her to stab Sarastro, and Tamino won't talk to her (because he's on a vow of silence, but Pamina doesn't know that) and he maybe doesn't love her anymore. \n\nIt's a deceptively simple aria, and the empty accompaniment can make a singer feel as though they're walking on eggshells. Along with help from your teachers and coaches, we can offer a few tips for keeping things simple, and creating the illusion of superhuman breath control."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480371015059/2016-11-28---Pamina.jpg.jpg"
publishDate = "2016-11-29T15:29:00+00:00"
related_articles = ["articles/aria-guides-deh-vieni-non-tardar.md", "articles/aria-guides-quando-men-vo.md", "articles/aria-guides-o-sleep-why-dost-thou-leave-me.md"]
short_description = "It's a deceptively simple aria, and the empty accompaniment, a singer can easily feel as though they're walking on eggshells. Along with help from your teachers and coaches, we can offer a few tips for keeping things simple, and creating the illusion of superhuman breath control."
slug = "aria-guides-ach-ich-fuhls"
title = "Aria guides: Ach, ich fühl's"

+++
 1. The key to this aria is in paying attention to downbeats, versus upbeats. There's a tendency to come in on this first phrase and sing "Ach" as though it's on a downbeat; instead, that "Ach" is part of a slow upbeat to "fühl's". To really begin to feel the slow dance of this aria, it helps to try singing it way too fast. Imagine a conductor were beating a 2-beat pattern in an easy, walking-paced tempo; by speeding it up, you'll be able to hear the swing of it, and see where the text leads over larger phrases.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432576805/Aria-Guide---Ach-ich-fuhls---annotated---1.5.jpg.jpg){{% /md %}}</figure>
 2. As you move up to the E-flat on "ewig", get a head start and arrive slightly early. If you afford yourself this time to really sing and vibrate on the E-flat, you'll be able to better control the tuning on the way down to "hin". Pay attention to that first D in the middle of "ewig"; it tends to go flat.
 3. This bar is so tricky. It's one to work on with your teacher, of course, but keep in mind a couple of things: allow yourself lots of vowel modification while you're finding the sweet spot for that B-flat. Also, be sure that you're singing the D on "der" with spin and height, sending it right up to "Liebe".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432592452/Aria-Guide---Ach-ich-fuhls---annotated---1.75.jpg.jpg){{% /md %}}</figure>
 4. This short moment of a major key can be one of the saddest parts of the aria. Exaggerate the sweetness in that descending triad on "Nimmer kommt", and choose warmth over volume in "Wonnestunden".
 5. This twisty, winding phrase is a mouthful, so stay patient and practice slowly. Pay particular attention to the C-sharp on "meinem" and the E-natural on "Herzen". Now, never fear the sea of black on the second "meinem Herzen"; take a good breath in the middle of the third bar of this line, and that should last you until the staccato notes two measures later...<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432611683/Aria-Guide---Ach-ich-fuhls---annotated---2.5.jpg.jpg){{% /md %}}</figure>
 6. You have more rhythmic freedom in these staccato notes (which you can afford to make a little longer, at this tempo). It means that between these staccati, you can take a much-needed breath without disturbing the phrase. If you can, it's effective to carry the phrase through "mehr zurück". Done stealthily, these two phrases can combine and sound like one superhuman line of singing, with no audible breath.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432625598/Aria-Guide---Ach-ich-fuhls---annotated---2.75.jpg.jpg){{% /md %}}</figure>
 7. It looks simple, but this short little "Sieh, Tamino" can be a moment to sing your heart out. There's a lot to sustain, and the work is easier if you remember that "Sieh" is an upbeat. Imagine that this short little phrase comes right out of the woodwind scale up right before it, so it feels almost like an answer to a question.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432641686/Aria-Guide---Achi-ich-fuhls---annotated---3.jpg.jpg)
    {{% /md %}}</figure>
 8. At this tempo, these eighth notes are fairly substantial. Enjoy the feeling of a resonating vowel on every single note, and sing through the trip between pitches (especially the tritone on "Ruhe"). Settle into the slow chromatic descent starting on the C-sharp of "so", and sustain all the way through the little decorations on "im Tode".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432748220/Aria-Guide---Achi-ich-fuhls---annotated--4.75.jpg.jpg){{% /md %}}</figure>
 9. Sometimes people sing a dotted rhythm instead of the two sixteenths on "fühlst du"; whichever you choose, be sure to really sing those high Gs, so you have momentum and height for the A-flat. As you come down to "der Liebe Sehnen", maintain height in your sound so the next two bars aren't harder than they need to be.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432672229/Aria-Guide---Achi-ich-fuhls---annotated--4.5.jpg.jpg){{% /md %}}</figure>
10. Understandably, you're probably putting your energies into a beautiful sound on "Ruh". Help yourself by really singing a long vowel in the "wird" right before; try not to anticipate the consonant cluster connecting "wi**rd R**uh", and send voice through every letter. For the next phrase, use the haunting quality of the \[o\] in "Tod" to lull us into Pamina's world; enjoy that trip up from the low D to the B-flat, and pretend for a moment it's a bit of Wagner.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480432762430/Aria-Guide---Achi-ich-fuhls---annotated--5.jpg.jpg){{% /md %}}</figure>
11. This odd little lick is best treated as though it were part of the _bel canto_ school. There's rhythm in the cadenza, and the points of tension are clear. You can find a shape to Mozart's cadenza by taking out the _fermata_ and singing the whole thing in time. Try conducting a version that includes the _fermata_, and see how that leads to the final "sein". Like anything with ornamentation or embellishment, it's really helpful to keep returning to the "fermata-free" version, totally in time, reminding yourself of where the beats fall.

***

Have a listen to Nadine Sierra's performance this year with Bryan Waghorn the WQXR studio:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/cu0BmPXZ6dI" frameborder="0" allowfullscreen></iframe>
</figure>