+++
author = ["authors/jenna.md"]
categories = "How-To"
date = 2021-08-22T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Have a request for our Aria Guides? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Talk about a Verdi staple: Leonora's act IV aria from _La forza del destino_ is a soprano coup, not for the faint of heart. Leonora sings this from the cave she's been living in lately, hermiting away from things like botched elopements and family curses. This marathon aria is certainly one to work on closely with your trusted teachers and coaches. In the meantime, this Aria Guide is here to offer some handy tips for \"Pace, pace, mio Dio\" (\"Peace, peace, my God\"):"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1629485179/media/2021/08/AriaGuide-Pace_pog9oe.jpg"
primary_image_credit = ""
related_articles = ["articles/aria-guides-embroidery-aria.md", "articles/aria-guides-donde-lieta-uscì.md", "articles/aria-guides-je-suis-encor.md"]
related_companies = []
related_people = []
short_description = "Leonora sings this from the cave she's been living in lately, hermiting away from things like botched elopements and family curses. This marathon aria is certainly one to work on closely with your trusted teachers and coaches."
slug = "aria-guides-pace-pace-mio-dio"
title = "Aria guides: Pace, pace, mio Dio"
youtube_url = ""

+++
Sopranos, see thy teachers for this one **(1)**. I mean, Verdi really kicks off this killer aria with an abyss of overthinking, a real looks-simple-but-it's-obviously-not-simple kind of bar. I can encourage you all to keep refreshing your \[a\] vowel, to use Verdi's crescendo-diminuendo to your advantage, and have fun with a portamento on the way down (at least a little one!). But remember: we've only just begun...

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426448/media/2021/08/AriaGuide_Pace_p1_annotated_cropped_zrshkl.jpg){{% /md %}}

</figure>

Take care here **(2)** with intonation. It's easy to go flat on the B-flat, and on the G on "mio Dio". And though it's relatively simple, take care not to let your placement drop as you come down. That leap from F to D should be an easy tune, nothing more. And a general note: the dotted figures in this aria should be distinguishable from triplet figures. Classic Verdi.

You have time here **(3)** to sing a real vowel on the first syllable of "sventura", so let it help you get into this new minor mode in this section. And Verdi does a cool thing here with the text phrasing; there's a tiny comma after "m'astringe", so give some fresh attention to the "ahimè" that comes after it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426460/media/2021/08/AriaGuide_Pace_p2_annotated_cropped_top_kkaips.jpg){{% /md %}}

</figure>

Be diligent that you don't fall flat on either of the E-flats in this phrase **(4)**. And though the text oozes drama here, don't over-darken as you descend into speech-like territory.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426483/media/2021/08/AriaGuide_Pace_p2_annotated_cropped_is4djp.jpg){{% /md %}}

</figure>

Chat with your teacher about how to negotiate these diminuendos **(5)** without losing spin. And rather than aiming for a specific volume level, go for contrast; it'll help you from coming off the voice in pursuit of a proper _piano_.

Long, _long_ sound on "L'ami, gli è ver!" **(6)** Note that "gli è" is under a straight eighth note, so don't be late on it. The melody is getting more interesting here, so show us around a bit and don't leave a single note out of your voice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426503/media/2021/08/AriaGuide_Pace_p3_annotated_cropped_top_x5qq3w.jpg){{% /md %}}

</figure>

When you breathe for this phrase **(7)**, plan it around this bar. Most sopranos like to snag a breath either before "cotanto" or before "l'ornò", to make the most out of this hairpin moment on "che l'amo ancor". And though it's not marked, it's a nice touch to add a bit of portamento from the D up to the F.

This rhythm is pretty cool **(8)**, so keep it crisp and taut. When you breathe for the first "Fatalità!", make sure you're singing on that tiny sixteenth-note pickup. You won't really have time to vibrate on it, but you spin should be already happening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426512/media/2021/08/AriaGuide_Pace_p3_annotated_cropped_xsjxtf.jpg){{% /md %}}

</figure>

Keep the pitch consistent on these three repeated C's **(9)**. And be super picky about the A-flat on your way down. When you get into "Alvaro...", it should feel a bit sunny. Sing it with a smile, at least on the inside.

This phrase **(10)** can easily be split into two mini-phrases, but resist the urge. That colon after "è scritto" is very cool, because it's not a comma. It's punctuation, but the kind that lurches forward, rather than halts. Keep that in mind as you pace your breaths, and don't let things sag too soon after "scritto".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426544/media/2021/08/AriaGuide_Pace_p4_annotated_cropped_d09len.jpg){{% /md %}}

</figure>

Things are picking up here **(11)**, both tempo- and drama-wise. Musically, your role becomes a bit of accompaniment here, like a descant around the operas's motif that pokes out in the orchestra (you can see the first one happening while you're holding "pace", for example). This doesn't mean you shouldn't sing this properly, but it's almost like Leonora is getting swept away by something larger than her, as though she's singing to something else's tune. Basically, don't drag; let the orchestra lead the show for a few bars.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426556/media/2021/08/AriaGuide_Pace_p4_annotated_cropped_2_jysonz.jpg){{% /md %}}

</figure>

The orchestra pushes you into this bar **(12)**, but at this octave leap from G-flat to G-flat, you can definitely take some time. Verdi marks a portamento here, which you should take literally. It's fun to do, and a proper portamento will help you from getting too chesty in "a tanto duol".

Clearly, another puzzle to work out with your teacher **(13)**. My humble advice: breathe for the high B-flat, and don't work too hard for the "Invan la". Let the downward portamento help you maintain height, so you're ready to pop back up to the A-flat in the next line.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426571/media/2021/08/AriaGuide_Pace_p5_annotated_cropped_top_s27bpk.jpg){{% /md %}}

</figure>

Breathe for the top note here **(14)**, so you don't start too much in the throat. Spoon-feed us the chromaticism here, and spend time vibrating on the E-natural before moving to the E-flat. The little triplet turn on "alma" should happen entirely separately from the letter L. It seems a small thing, but the semitone between E-flat and D on "invan spe(rò)" is super teeny tiny.

Come in a bit early and get a good hum going on the \[m\] in "Misero" **(15)**. It's a nice touch, and reduces stress in your pianist/conductor's brain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426584/media/2021/08/AriaGuide_Pace_p5_annotated_cropped_am0rkl.jpg){{% /md %}}

</figure>

This **(16)** should be a tiny moment of respite for you, before the big finish. This section is recit-like, but it needs to stay relatively in time, and you should have a clear new tempo in your ear.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1629426593/media/2021/08/AriaGuide_Pace_p6_annotated_cropped_os6cab.jpg){{% /md %}}

</figure>

In the race to the finish **(17)**, choose your battles wisely. The orchestra is picking up here, so don't spend too much of your well-conserved energy on the little notes. Imagine this section happening in 2/2, and let the three B-flats really swoosh you forward to that funky E-natural on "Maledizione". For the final bars, there are a few options. Some sopranos sing this as written, and others break up the two-bar F-natural, to grab one last breath before the high B-flat. Listen to a few recordings, decide what your body and brain like best, and then be prepared to change all your plans because of a conductor.

***

Ok, enough talk! Time to listen...specifically to Sondra Radvanovsky singing Leonora's "Pace, pace, mio Dio" from Verdi's _La forza del destino_:

<figure data-type="video">{{% md %}}<iframe width="1010" height="568" src="https://www.youtube.com/embed/zZeEKoGV53c" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>