+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-21T04:46:00-07:00"
lastmod = "2017-06-22T21:17:00-06:00"
preamble = "Wolfram's aria is a pretty magical moment in Wagner's *Tannhäuser*. It's almost a stand-alone song within the opera, the minstrel having a musical soliloquy, and it feels much gentler, much more intimate than everything that has come before. Wolfram is singing to the evening star, thinking of Elizabeth and her sad love for Tannhäuser.\n\n\"O! du mein holder Abendstern\" is a popular choice for baritones, and it's no simple \"song\". Along with your teachers and coaches, we can help you on your way to channelling your inner Minnesinger."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498187729888/2017-06-22---Star.jpg.jpg"
publishDate = "2017-02-21T07:38:00-07:00"
related_articles = ["articles/aria-guides-lieben-hassen.md"]
short_description = "Wolfram's aria is a pretty magical moment in Wagner's Tannhäuser. It's almost a stand-alone song within the opera, the minstrel having a musical soliloquy, and it feels much gentler, much more intimate than everything that has come before. Wolfram is singing to the evening star, thinking of Elizabeth and her sad love for Tannhäuser."
slug = "aria-guide-o-du-mein-holder-abendstern"
title = "Aria guides: \"O! du mein holder Abendstern\""

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677409519/Aria-Guide---Wolfram---annotated---p1.jpg.jpg) {{% /md %}}</figure>

 1. Like most recitative in Wagner's operas, this works best if it stays in tempo. Wagner is pretty great at setting German, and the pacing of the text has already been clearly laid out. It's not a quick tempo, which is what makes it easy to get heavy and sluggish; there are so many juicy moments that it can be easy to want to milk them all, stopping to smell every single rose. Throughout this recit, take note of the direction of the underlying harmony. The first g minor chord leads right to the c minor chord under "-ahnung"; the D major chord underneath "Dämmrung..." leads right to the g minor under "Lande". It's really illuminating to play (or get your pianist to play) only the orchestra harmonies, and to play the progression way too fast; this way you can figure out where the music goes, and see what that means for the text. 
 2. During that delicious tie on "Seele" the harmony changes from d minor to D major; it's an amazing moment, and Wolfram should be aware of the shift in colour. Be aware, though, that the phrase isn't done; the harmony leads right to "verlangt" (shown below), so be careful not to let the magic of "Seele" break up the larger line.
 3. It's easy to go flat on "verlangt", coming down from "Höhn". Take care that the vowels in "verlangt" are true and spinning, and double check that A natural - it's higher than you think.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677749177/Aria-Guide---Wolfram---annotated---p2a.jpg.jpg){{% /md %}}</figure>
 4. Here's another great moment for baritones; "Grausen" is stretched out, in an easy spot for the voice, so indulge a little bit and let everyone enjoy it. Be wary not to bring in the diphthong too soon; whether you sing \['ao\] or \['au\], try to spent 90% of the long note on the \[a\] vowel.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677764724/Aria-Guide---Wolfram---annotated---p2b.jpg.jpg) {{% /md %}}</figure>
 5. We've seen excellent baritones balk at this section. With a piano, it's not so bad; but when it's truly a group of strings playing _pianissimo_, it can feel like you're singing into silence. The trick is not to overthink the soft singing, particularly as you wind around this high D. If you start on the B-flat too softly, the D won't work; try reversing this line, starting on the D, to see what dynamic level works for you. Finally, take care with the intonation as you descend on "lieblichster"; it's easy to let the C and B-flat to fall flat.
 6. The dynamic level peaks here; while it's not loud, _per se_, you can afford to sing a healthy, comfortable volume. Long vowels and connective consonants will help you through these tricky sustained high Ds. Enjoy the combination of \[tfr\] in "und freundlich" and \[çts\] in "freundlich zeigst", and use those consonants to keep your air moving.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677425118/Aria-Guide---Wolfram---annotated---p3.jpg.jpg) {{% /md %}}</figure>
 7. This part is really the "song" of Wolfram's aria. In the orchestra (the harp, really), there's a natural lilt towards the middle of each bar. Let that guide you as you sing the tune; it's a great way to avoid landing heavily on downbeats, which can make this aria really hard to sing. Pay attention to detail in these first four bars; there's the specific punctuation of "O! du mein holder..." to consider, plus the diminuendo to _pianissimo_ on "Abendstern". For the diminuendo, try not to get too quiet too soon; you can bring out the _pianissimo_ by enjoying the gentle glottal attack on "Abendstern" (but beware of vocal fry!).<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677431988/Aria-Guide---Wolfram---annotated---p4.jpg.jpg) {{% /md %}}</figure>
 8. The cellos come in and take over the tune here; they fill out the sound quite a lot, so you can afford to sing out a bit more. With the diminuendo leading to "nie", think about doing terraced dynamics instead. Underneath "...Herzen, das sie...", take each note and move stepwise from the accent note, to _forte_, to _mezzoforte_, to _mezzopiano_, etc.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677438833/Aria-Guide---Wolfram---annotated---p5.jpg.jpg)
    </figure>
 9. This is the highest moment in the aria, and it can seem to come from out of nowhere. Try to think of it as a horizontal gesture, rather than a vertical one. Like earlier in the recit, this is another spot for long vowels, and sending air through consonant clusters like in "entschwebt". Be careful not to start to heavily on "wenn", just because it's in an easy register. It's helpful to try reversing this arpeggio, starting high and carrying that height down to the low E. That height in the sound is how you want to start when you sing this phrase as written.
10. Grab yourself a good breath, since these phrases can feel longer than they look. Start lightly, pacing yourself for the tricky turn on "Engel". Maintain that spinning movement through "dort", finding a great vowel to maximize your air. Some baritones grab a breath before "zu werden", and it's definitely a better option than choking out the last word.
    <figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487677450364/Aria-Guide---Wolfram---annotated---p6.jpg.jpg)
    {{% /md %}}</figure>
11. The texture changes here, and you have a bit more rhythmic freedom. You can lead the ritardando with the short notes, like "ent-" of "entschwebt". Save some room to get softer on "Tal". The breath you take after "Erden" is one you'll really need, and Wagner gives you the rhythmic space to take to get ready for the next phrase.<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487686501955/Aria-Guide---Wolfram---annotated---p7a.jpg.jpg)
    {{% /md %}}</figure>
12. This is another deceptively long phrase. Imagine that you're starting much higher in your range, so that you don't wear yourself out on the gradual ascent. Pick a good vowel for the second syllable in "Engel"; it might be wise to err on the side of \[ɛ\] instead of a schwa, to maintain that spinning line.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487686511084/Aria-Guide---Wolfram---annotated---p7b.jpg.jpg)
    {{% /md %}}</figure>
13. Be sure to sing the "zu" with vibrato and real voice. When you get to "werden", note that the fermata is on the A, not the long B. This is the end of Wolfram's song, and it feels almost improvised; it's very _bel canto_, really, so stay on that fermata A just a hair longer than you think you should.

> Have an aria you'd like to request for our Aria Guides series? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).