+++
author = ["authors/jenna.md"]
categories = "How-To"
date = "2016-05-13T10:56:00+01:00"
lastmod = "2016-05-25T23:10:00+01:00"
preamble = "Next up for our Aria Guides: the tenor's favourite scary aria, \"Dies Bildnis ist bezaubernd schön\" from Mozart's _Die Zauberflöte_. It's an aria about love at first sight, about idealism, and about proving that music can be difficult to sing even if there are no B-flats or crazy coloratura. Along with your teachers and coaches, we can help with some tricky corners of this aria, and even get you confident about adding it to your audition package. A bold move, and why not?"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553306691/media/2019/03/sqBildnis.jpg"
publishDate = "2016-05-13T12:31:00+01:00"
related_articles = ["articles/aria-guides-una-furtiva-lagrima.md", "articles/aria-guides-dalla-sua-pace.md", "articles/aria-guides-una-voce-poco-fa.md", "articles/aria-guides-il-mio-tesoro.md"]
short_description = "Next up for our Aria Guides: the tenor's favourite scary aria, \"Dies Bildnis ist bezaubernd schön\" from Mozart's Die Zauberflöte. It's an aria about love at first sight, about idealism, and about proving that music can be difficult to sing even if there are no B-flats or crazy coloratura. Along with your teachers and coaches, we can help with some tricky corners of this aria, and even get you confident about adding it to your audition package."
slug = "aria-guide-dies-bildnis-ist-bezaubernd-schon"
title = "Aria Guides: Dies Bildnis ist bezaubernd schön"

+++
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133406870/Aria-Guide---Tamino---annotated---p1.jpg.jpg)
{{% /md %}}</figure>

 1. This can be an intimidating first phrase, but be brave, tenors! Give yourself a good, spun sound on the "Dies" pick-up, and stick with that sound to help you rise up to the G of "Bildnis". These pitches are definitely not in the same "spot" of your voice, but sound tends to feed sound, meaning breath feeds breath. Resist the urge to separate these first two notes, and try to use them as one unit. Once the first interval is out of the way, enjoy a bit of freedom in the rhythm of these first few bars. There's flexibility written in, and the sixteenth notes are really just approximations of the natural flow of German (or English).
 2. There are a few points in this aria where fragments of text are immediately repeated, like these two "Ich fühl es" lines. Make them different, and give yourself a reason for the difference besides a change in dynamic. The subsequent leap from B-flat to A-flat on "wie dies Götterbild" is similar to the top of the aria; don't be afraid to really sing the B-flats, with a long \[i\] vowel on "dies" to help you up high. The last piece of the puzzle: double check your intonation on the F-natural, coming down from the A-flat. Make sure it gets a proper vowel, and proper sound.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133415637/Aria-Guide---Tamino---annotated---p2.jpg.jpg)
    {{% /md %}}</figure>
 3. These are some of the most gorgeous bars in this aria, yet for a tenor, they can seem uncomfortably long. Try to imagine that the two bars leading into "füllt" are one long pick-up. It also helps to think of renewing the vowel and sound on "Herz" as it's sustained over the middle of the bar. It's even more important to do this the second time on the high G; if you keep these long notes moving forward rather than growing stale, you'll have the flexibility to sing real legato around that tricky G - F - A-flat zone.
 4. To help with this super-exposed entrance, come in just a hair early, almost dovetailing the end of the orchestra's interlude. Find yourself a comfortable version of the \[i\] vowel in "Dies", and leave room to vibrate on the tiny little thirty-second note F-natural, the one right before the word "Etwas". When the phrase repeats on "doch fühl ich's", make sure that appoggiatura has something to do with "fühl" or even "brennen".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133425087/Aria-Guide---Tamino---annotated---p3.jpg.jpg)
    {{% /md %}}</figure>
 5. At this tempo, tenors have the time to really sing every sixteenth note in this rising arpeggio. The real money notes are the odd beats: the first D-natural and F-natural. Make sure that your vowels are sustained and renewed as you rise up. At the repetition starting on the high G, try and stretch that top note for as long as you can get away with. It's not quite a dotted rhythm, but sort of a sixteenth-note-plus.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133441818/Aria-Guide---Tamino---annotated---p4.jpg.jpg)
    {{% /md %}}</figure>
 6. More repetition! There are tons of options for making these "die Liebe" phrases different, so pick a dramatically-inspired reason, and go with it 200%. On the third "die Liebe" going up to the G, make sure you're on a happy version of that \[i\] vowel, and start it with enough sound to keep you comfortable, but light enough to allow for the ascent. This way, you'll leave dynamic room to create (read: fake) a diminueno as you rise up, which will keep the word "Liebe" sounding more German, and less like "Lie-BEH".<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133454199/Aria-Guide---Tamino---annotated---p5.jpg.jpg)
    {{% /md %}}</figure>
 7. Tenors, this section should be an opportunity for you to really exhale and let go. Mozart writes these two-bar phrases with a peak in the middle, meaning you can treat one bar as a pick-up to the next. Be sure that you're not sitting too heavily on the initial "O", and that you've got tons of room for a thrilling A-flat. Like earlier in this aria, get picky with tone and intonation of the F-natural that falls down from the A-flat each time.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133467571/Aria-Guide---Tamino---annotated---p6.jpg.jpg)
    {{% /md %}}</figure>
 8. Here, "warm und" should really lead to "rein". It's another moment of one bar acting as a pick-up to the next; it can be tempting to put all the energy into the high start of the phrase, but Mozart leads our ear to the release of tension in the final bar. You can even get a head start on "warm" by starting the \[v\] somewhere in that eighth rest at the beginning of the bar. That little "was würde ich?" is almost like a musical echo, an introspective moment after all these passionate phrases.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133476618/Aria-Guide---Tamino---annotated---p7.jpg.jpg)
    {{% /md %}}</figure>
 9. Every note in this bar counts, but take care that singing each note doesn't include adding weight. You want forward motion in this measure, so as you sing the odd sixteenth notes (the low B-flat, the second E-flat, etc.), make sure it's happening through maintained vowels, and that you're not subconsciously following the zig-zagging shape of the melody.<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463133489435/Aria-Guide---Tamino---annotated---p8.jpg.jpg)
    {{% /md %}}</figure>
10. This ending is really exciting, but super mean of Mozart. This first bar is deliciously beautiful, and you want a warmth in the sound that keeps you from driving your voice down low. It looks daunting, but allow yourself the time to sing that final note on "dann", and use the \[a\] vowel to feed the leap up to "mein". The breath you'll take before "ewig" can be tricky, as the tenor can often feel rushed. Take the time that you need, and don't feel the need to shorten the E-flat at the end of "mein".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463137802094/Aria-Guide---Tamino---annotated---p9--2.jpg.jpg) {{% /md %}}</figure>