+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-05-24T20:40:00-04:00"
lastmod = "2015-05-25T13:35:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1432574158603/Goethe_Square.jpg.jpg"
primary_image_credit = "Autograph manuscript of Goethe's \"Gliech und Gleich\""
publishDate = "2015-05-25T13:35:00-04:00"
related_articles = ["articles/problems-we-didnt-know-we-had-surtitles.md"]
related_people = ["scene/people/stephanie-blythe.md","scene/people/warren-jones.md"]
short_description = "After academia, it becomes less common to give spoken translations in voice recitals. It&#039;s one thing to hear an undergrad voice student tell you what &quot;Das Veilchen&quot; is about, but it&#039;s another thing entirely to hear the likes of Stephanie Blythe and Warren Jones reciting song texts."
slug = "are-printed-translations-screwing-up-recitals"
title = "Are printed translations screwing up recitals?"
+++

I came across an [Operavore article](http://www.wqxr.org/#!/story/should-opera-singers-stop-providing-printed-translations-song/) by [Fred Plotkin](https://twitter.com/FredPlotkin), which was, on the surface, a review of [Stephanie Blythe](/scene/people/stephanie-blythe/) and Warren Jones at Carnegie Hall earlier this month. The seasoned pair gave a top-notch recital, despite having no printed song translations in the programs. Instead, Blythe and Jones took turns reciting English translations of the poetry before performing the songs.

I love this. After academia, it becomes less common to give spoken translations in voice recitals. It's one thing to hear an undergrad voice student tell you what "Das Veilchen" is about, but it's another thing entirely to hear the likes of Stephanie Blythe and Warren Jones reciting song texts.

Plotkin writes in his review, 

> "As a result, in hearing the texts we focused on the words, their meanings and—importantly—their ideas on their own. We listened attentively during these spoken passages and then, with the texts fresh in our minds, we listened more actively to the music that both singer and pianist produced. And, as Blythe wanted, we were looking at her and she at us."

I often notice a change in energy during a recital, when a singer sings something that doesn't come with a translation; common reasons for this are a) the song is in English, and b) the song is an encore or some other surprise. 

I saw it happen at [Owen McCausland's recital](/in-review-owen-mccauslands-recital-stunner/) last week at the Four Seasons Centre. He sang some of Vaughan Williams' *The House of Life*, the only English set, and the only one without printed texts. I noted that the sounds of people shifting and fiddling with their programs died down, and the focus zeroed in quite noticeably on Owen.

Another recent example was [Ekaterina Gubanova's recital](/in-review-ekaterina-gubanova-rachel-andrist-in-recital/) the same week. She sang an encore, an aria from Rimsky-Korsakov's *The Tsar's Bride*. The aria was in Russian, and I assumed that most of the Torontonian audience wasn't fluent; yet with the absence of printed translations (or text of any kind), you could hear a pin drop as listeners leaned in to hear the meaning behind Ekaterina's singing.

I'll attest to printed translations being somewhat of a crutch. When a song text is tricky to get out, it can be reassuring for a singer to know that the audience won't have to depend on them 100% to "get" it. When the listeners are scanning a poem in their program, however, they're missing the singer. 

Audiences are smart; if they appear otherwise, perhaps it's because we don't give them the right tools for enjoyment. I've been in masterclasses and coachings where a singer does what Blythe did, reciting a literal translation of the song's text (hopefully with a little bit of drama), before singing the song. It really is a thrilling experience to hear, and I don't think it's limited to listeners with a musical background. By first reciting the poem "neutrally," and singing immediately afterwards, the audience can hear where the composer started with his ideas, and where he or she went with them. 

I love this part so much; it's like getting a look inside the minds of the poet and composer. I think it's easier than we believe to extend that insider info to the listener. It's an extra challenge for the singer, no doubt; but there's nothing wrong with upping the ante if it's done in the name of communicating with audiences.
