+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-27T11:57:00+00:00"
lastmod = "2017-01-29T11:58:00+00:00"
preamble = "Last autumn, we went to the Thames Tunnel Sinking Shaft at London's Brunel Museum to see [*The Swarm*](/actual-opera-buzz-the-swarm-in-review/), an all-women ensemble opera by Heloise Tunstall-Behrens and Roswitha Gerlitz. The opera tells the story of a swarm of bees, who are on the hunt for a safe, warm place to make their nest; the layered sound scape of *The Swarm* is meant to draw the audience into the collective swarm, to not only observe, but experience the story.\n\nOn **February 8-12**, *The Swarm* returns to London as part of the [VAULT Festival](http://www.vaultfestival.com/event/the-swarm/2017-02-08/). We spoke with composer Tunstall-Behrens about writing music for bees, and the opera's larger message of \"togetherness and love\"."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485518474452/2017-01-27---The-Swarm---Vaults.jpg.jpg"
publishDate = "2017-01-29T10:56:00+00:00"
related_articles = ["articles/actual-opera-buzz-the-swarm-in-review.md","articles/6-animals-who-love-opera-more-than-penguins.md"]
related_companies = ["scene/companies/popup-opera.md"]
short_description = "&quot;Our aim is for the audience to feel part of the colony and one of the bees.  The message is togetherness and love and we want the audience to be included within that.  Just as every bee has a role within the colony, so too does the audience.&quot;"
slug = "apian-opera-dont-miss-the-swarm"
title = "Apian opera: don&#039;t miss The Swarm"
+++

## Can you tell us the process of notating a score like *The Swarm*? Were there any unique challenges for the singers in learning and memorising it?

I did create Sibelius scores for the piece, with the help of our music assistant, Loretta. However, because of the nature of the music, often made of repeated looped melodies and phrases, it wasn't incredibly useful for the singers to have it notated via a stave.  To help them follow, I experimented with more of a visual score, notating the phrases through coloured blocks or shapes, which would appear at points on a line representing each singer.  

Most of the singers were more comfortable learning by ear, so learning the music often consisted of knowing how many times to repeat the phrase and it was only when the singers were more comfortable with the music that the shape of the whole piece became apparent.  

Because of the interconnected nature of some of the movements, it was essential that every singer was there when we sang the pieces through - each singer has their own part and often takes cues from another singer, or is the one who gives the cues to the others.  It was funny reflecting on this and finding parallels with bees within a colony – everyone has their role and is just as important as all the others.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485690796942/2017-01-27---Heloise-Tunstall-Behrens.jpg.jpg)<figcaption>Heloise Tunstall-Behrens, composer of *The Swarm*.</figcaption></figure>

## What do you look for in a performance venue for *The Swarm*? How much does the piece change when it moves to a new venue?

We are interested in finding very specific venues to perform *The Swarm*.  The story follows a swarm of honeybees in the city who are searching out potential nest sites.  They are looking for somewhere dry, enclosed, with a small entrance and large enough to house a colony of bees, so unique urban locations are perfect – tunnels, old stations, underground hideouts – anywhere which makes the audience feel as though they are part of the colony.

For our next run of shows at [VAULT Festival](http://www.vaultfestival.com/event/the-swarm/2017-02-08/), we've evolved the piece slightly, incorporating the queen more within the piece.  She is now no longer played by an opera singer, but will be represented by a light, designed by Venya Krutilov who is part of the Invisible Wind Factory up in Liverpool.  

There will also be some new choreography for the bees, now that we're more comfortable with the music.  It'll be exciting to perform in the Cavern as it has a lot of atmosphere and, owing to the size, an incredible acoustic.  I'm sure we'll have to adapt slightly to the feel of the place, but the same elements will be there from our performances in the Sinking Shaft of the Brunel Museum.

## What do you hope audiences will take away from these performances?

Our aim is for the audience to feel part of the colony and one of the bees.  The message is togetherness and love and we want the audience to be included within that.  Just as every bee has a role within the colony, so too does the audience.  Without wanting to give too much away, they are asked to initiate the performance through a hum.  Through humming, hearing and feeling the vibrations from the other people in the room, we hope to nurture a feeling of the community and thereby a stake in the collective.

>The Swarm plays at the Vault Festival on February 8-12, 7:30pm. For details and tickets, [click here.](http://www.vaultfestival.com/event/the-swarm/2017-02-08/)
