+++
author = ["authors/justin-ralph.md"]
categories = "Op-ed"
date = "2018-09-27T20:44:00-04:00"
lastmod = "2018-09-28T22:35:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538096523038/stress.jpg.jpg"
publishDate = "2018-09-28T22:35:00-04:00"
related_articles = ["articles/the-anxious-singer-10-tips-to-help-with-anxiety.md"]
short_description = "I know a lot of my friends and colleagues struggle with performance anxiety, and I wanted to share my thoughts here in the hopes that it might help someone else who is struggling, and open up a dialogue about anxiety and art, which I think for many of us go hand in hand."
slug = "anxiety-art-and-purpose"
title = "Anxiety, Art, and Purpose"
+++

These days, it's hard to call anxiety and depression in the music industry the elephant in the room - it is an issue that has become abundantly clear. 

Whether we're doing enough to address it as an industry is an entirely other question (I think sadly, I think the answer here is "improvement needed"). I wanted to take a few moments to talk about my own experiences with anxiety, both on stage and off, and some realizations I've come to in my own journey. If discussing these points helps even one performer who reads this post, I think it will have been a worthwhile endeavour. 

When it comes to my motivation to perform music, I have often lived off the praise and reception of others. The feeling of happiness and pride is powerful when someone comes up to you after a performance and says, "That was fantastic!", "Your voice blew me away", "You gave me goosebumps!"

I don't think there is anything wrong with enjoying this, or even taking pride in the fact that your performance gave someone a special experience. I think where I personally started to go wrong with this was when my focus and happiness slowly moved from the creation of art to the reception it would receive. When we become solely focused on the impact our art has on an audience, it can lead us down some unhealthy paths. 

For me, this path was anxiety. For years, I have struggled with extreme anxiety about performing. From the day I'm booked for a gig or a role, I constantly worry about getting sick, about my hands shaking, about people thinking I'm terrible when I perform and judging me. These thoughts plague me constantly until the performance. I know the thoughts are wrong, or at least, deluded. I can't read people's minds, or predict the future. And really, in the end I'm not in literal physical danger if someone doesn't like my performance, but that doesn't stop my mind or body from telling me that I am. And that anxiety far outweighs the small pleasure I get from performing, which is a big issue. The kind of issue that can make you decide to stop performing entirely. 

(In the interest of full disclosure, I don't just suffer from anxiety about performance - I have anxiety about a lot of things. But it certainly comes up frequently when preparing for a gig.)

I was listening to an interview yesterday with Chef Éric Ripert, of Le Bernadin in New York City. Le Bernadin has held three Michelin stars and a four star review from the New York Times for decades, and appears in the Top 50 Restaurants in the World list every year. The interviewer asked Chef Ripert how he deals with the anxiety surrounding this: does he wake up every morning, worried about losing one of those stars, and ruminating on the fact that the restaurant could happen to have a bad day while a critic was there, and that could lead to gradual loss of the reputation he has built? 

Chef Ripert responded by saying he wakes up every morning thinking about what he can do that day to make the best possible food, to motivate his team in the best possible way, to make the best black bass dish that anyone has ever tasted. That is what brings him happiness and joy. 

This really struck a chord with me (apologies in advance for the pun). If I could shift my personal perspective to focus more on the creation of art, of bringing the most powerful interpretation of it I can possibly do, of losing myself in the creation and the joy of that creation, it could potentially relieve me of a lot of the anxiety that comes along for the ride when preparing for a gig - the fears of illness, of not being good enough, and the constant attempts to gauge how "well" of a job I've done. 

I'm just coming around to this perspective, and I have a lot to learn and explore here. For example, I think a certain amount of anxiety before a performance is natural. And, anxiety itself is not "bad" - it's an emotion we all have to experience, and allowing it to be present and not fighting with it is also an important skill to dedicate time and attention to. 

I know a lot of my friends and colleagues struggle with performance anxiety, and I wanted to share my thoughts here in the hopes that it might help someone else who is struggling, and open up a dialogue about anxiety and art, which I think for many of us go hand in hand.
