+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-07-04T16:29:00-04:00"
lastmod = "2018-07-04T17:42:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530736137589/Antoine-wagner-portrait1.jpg.jpg"
primary_image_credit = "Photo: Thomas Birkett."
publishDate = "2018-07-04T17:42:00-04:00"
related_articles = ["articles/in-review-siegfried.md","articles/kinder-schafft-neues-die-meistersinger-von-nrnberg.md"]
related_people = ["scene/people/alan-held.md"]
short_description = "He remembers an early-1990s summer at the Bayreuth Festival, during the creation of the now-famed Harry Kupfer production of the Ring Cycle, conducted by Daniel Barenboim. Antoine and Barenboim&#039;s son, David, had renamed all of their He-Man figurines after Wagnerian characters."
slug = "antoine-wagner-gesamtkunstwerk-in-2018"
title = "Antoine Wagner: Gesamtkunstwerk in 2018"
+++

This July at Miami's New World Symphony Center, the Miami Music Festival's [Wagner Institute](https://www.miamiwagnerinstitute.com/) presents an evening that pairs the tension between opera and technology with the formidable term, [*Gesamtkunstwerk*](https://en.wikipedia.org/wiki/Gesamtkunstwerk).

In the plainest of terms, the [event on **July 14**](http://www.nws.edu/events-tickets/concerts/miami-music-festival-wagner-institute/) is a semi-staged presentation of the second acts of two of Wagner's most revered operas, *Lohengrin* and *Die Walküre*. Yet it's in the creative team and the performance space that the evening's interest lies. 

South Beach's New World Center, with the futuristic architectural lines that mark a design by Frank Gehry, will become the impressive housing for the directorial debut of visual artist [Antoine Wagner](http://antoinewagner.com/) - great-great-grandson to Richard Wagner himself.

His ancestry automatically piques the interest of most opera fans, yet Antoine plans to bring his own artistic aesthetic to the table in his direction of Act II of *Die Walküre*. It's his first time working in opera, yet it's a medium that fits well into his multimedia approach to art. Antoine works in film, photography, video, sound, and sculpture, and he is set to use not just his great-great-grandfather's score as inspiration, but also the impressive performance space. 

"When I set foot in that Frank Gehry building and saw the projection sails, the ability that this kind of morphing space had, it threw me over the edge."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530739605948/Miami_New_World_Center.jpg.jpg)<figcaption>The New World Symphony Center, Miami, FL.</figcaption>
</figure>

Listeners will hear the second act of *Die Walküre* - featuring Alan Held as Wotan and Linda Watson as Brünnhilde - but Antoine is creating an evening that tells the opera's full story. As well as the interior, he has too the exterior of the New World Center to his disposal, and he will project video mappings on the building's façade - on the way in, alluding to *Die Walküre* Act I, and on the way out, Act III. "The idea is to offer an evening of experience."

Richard Wagner is a figure often romanticised among opera fans, and it's fun to ponder the special kind of exposure to his aesthetic that someone like Antoine would have. Be they hereditary or learned, Antoine uses in his own work "Wagnerian" concepts like the *leitmotif* - a recurring theme that refers to a specific character or plot point - and a certain reverence for nature. His series of photographs, *Wagner in der Schweiz*, landscapes that influenced Richard Wagner during his exile in Switzerland, seems to evoke an additional layer of personal meaning. "When I was shooting these landscapes, 150 years later, there was definitely a transcendental feeling and experience," says Antoine of the project. "I can imagine that more or less, the rocks, the temperature, the humidity, the vistas were the same."

Of course, Antoine also has lighter associations with his artistic ancestry. He remembers an early-1990s summer at the Bayreuth Festival, during the creation of the now-famed Harry Kupfer production of the *Ring Cycle*, conducted by Daniel Barenboim. Antoine and Barenboim's son, David, had renamed all of their [He-Man](https://en.wikipedia.org/wiki/He-Man) figurines after Wagnerian characters. "There's apparently a video of me somewhere," laughs Antoine, "holding up He-Man in a bathing suit, with a balloon, going, 'This is Wotan!'"

The semi-staged evening of *Die Walküre* and *Lohengrin* (directed by Marc Callahan) seems a cool combination of novelty - Antoine's multimedia approach to the opera also comes with a futuristic concept bordering on science-fiction - and respect for one composer's 19th-century artistic aesthetic. His use of music, visual art, and architecture is a significant nod to Richard Wagner's original vision for his operas; where some see his [*Gesamkunstwerk*](https://en.wikipedia.org/wiki/Gesamtkunstwerk) as rooted in ego, Antoine sees it as paying homage to opera and its possibilities. 

"He gave the art and the creativity its importance," he says. "He participated in demonstrating how important culture and art is, I think."

>The Miami Music Festival's Wagner Institute presents *Die Walküre* and *Lohengrin* on July 14, 7:30pm at the New World Center. For details and ticket information, [click here.](http://www.nws.edu/events-tickets/concerts/miami-music-festival-wagner-institute/)
