+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-06T13:37:00+01:00"
lastmod = "2016-04-06T15:39:00+01:00"
preamble = "April 29th to May 1st, [MYOpera](/scene/companies/myopera/) presents Benjamin Britten's [*The Rape of Lucretia*](https://www.myopera.ca/lucretia2016/) at Toronto's Aki Studio, Daniels Spectrum. We were lucky to chat with the production's director, [Anna Theodosakis](/scene/people/anna-theodosakis/) about approaching this difficult opera, which holds an unfortunate amount of contemporary relevance. She speaks eloquently about this piece about women, and how Britten and librettist Ronald Duncan \"intended to illuminate the fact that women are held to a very different standard than men and suffer a great deal of inequity.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459947478011/2016-04-06---Anna-Theodosakis.jpg.jpg"
publishDate = "2016-04-06T15:12:00+01:00"
related_articles = ["articles/dont-miss-in-conversation-with-myopera.md","articles/metro-youth-operas-kate-applin-on-MYOBeaBen.md","articles/in-review-the-telephone-the-medium.md","articles/in-review-the-rape-of-lucretia.md","articles/in-review-the-rape-of-lucretia-at-tsmf.md","articles/italian-girl-rossini-feminist.md"]
related_companies = ["scene/companies/myopera.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/kate-applin.md","scene/people/christina-campsall.md","scene/people/anna-theodosakis.md"]
short_description = "&quot;While The Rape of Lucretia deals specifically with the story a woman, I believe it expresses the struggle of the individual against the confines of a corrupt society. I hope it can lend a voice to survivors who find themselves silenced, gender notwithstanding.&quot;"
slug = "anna-theodosakis-directing-the-rape-of-lucretia"
title = "Anna Theodosakis: directing The Rape of Lucretia"
+++

## For you, what do you think this opera has to say about women? Is there anything significant about its being written by men?
 
*The Rape of Lucretia* deals with the exploitation of sexual assault victims, regardless of gender, by society and more specifically by those in politics. It shines light on the fact that often the survivors of assault are not respected in the media and their stories are skewed by those who wish to use the incident for their own personal gain. We’ve seen examples of this throughout history, and most recently here in Toronto with the [Jian Ghomeshi trial](http://www.theglobeandmail.com/news/national/jian-ghomeshi/article28476713/) where the women’s voices were so easily manipulated by all parties.
 
When it comes specifically to women, composer Britten and librettist Duncan focus on the ideal of chastity. Society, in this case Ancient Rome, holds women’s chastity to such a high standard. Women are immediately defined as sexual objects and their purity easily becomes a target. I believe they intended to illuminate the fact that women are held to a very different standard than men and suffer a great deal of inequity. This injustice was happening in Ancient Rome, in 1946 when the opera was written, and unfortunately is still relevant today.
 
While *The Rape of Lucretia* deals specifically with the story a woman, I believe it expresses the struggle of the individual against the confines of a corrupt society. I hope it can lend a voice to survivors who find themselves silenced, gender notwithstanding.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459951188747/2016-04-06---Lucretia-Image-.jpg.jpg)
</figure>
 
## Does the opera pose any unique challenges to you as a director?
 
One of the challenges for any opera director is often retaining relevance to pieces written long ago or performed frequently. My goal when I first approached *The Rape of Lucretia* was to find a setting that would still speak to today’s audience. This involved updating the setting from Ancient Rome to 1946 Italy. The political landscape of Lucretia’s time and post-war Italy was shockingly similar and lends itself to the political slant I hope to highlight. So I got rid of the togas and opted for elegant mid-20th century dress. While our production is not contemporary, it focuses on a time that is still a part of our collective memory. It was also the year Britten wrote the opera and may provide context as to why he chose this subject matter.

## When it comes to the violence in the show, how do you balance portraying accuracy versus "shock value"?
 
It was MYOpera’s number one goal not to present something gratuitous or to capitalize on survivors. We immediately began an on going partnership with sex-positive advocate Sophie Delancey to ensure our marketing was appropriate and my approach to directing the depictions of sexual assault were thoughtful. I am blessed that Britten and Duncan did not lean towards shock value in the score itself. Their choice of timing proves very sensitive and by following their guidelines I was easily able to shape the scenes of violence so the point came across free from unwarranted exploitation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459951230932/2016-04-06---Cast---Lucretia.jpg.jpg)
<figcaption>Mezzo-soprano Christina Campsall, singing the title role in MYOpera's production of *The Rape of Lucretia*. Photo by Daniel Denino, Self Limited Photography.</figcaption>
</figure>
 
## What have you enjoyed so far about the creative process with this cast and creative team?
 
While my previous answers have been very heavy, I can assure you this has been both a rewarding and most enjoyable experience. The cast we have assembled are all both talented singers and incredibly thoughtful actors. It’s been an absolute delight working with these emerging artists who represent a vital new generation of opera singers. 

We are all building collaborative relationships with our peers as we gain traction in the Toronto opera scene. Music Director [Natasha Fransblow](https://www.myopera.ca/our-team/#natasha) is among this group of special rising talents. We have the same artistic vision for this opera and work so well together – I couldn’t ask for a better partner on this project. Artistic Director [Kate Applin](https://www.myopera.ca/our-team/#kate) and General Director [Stephanie Applin](https://www.myopera.ca/our-team/#stephanie) have created a strong and innovative company that allows for artists to grow in a nurturing environment. I am so happy to be a part of MYOpera’s sixth season. 

>*The Rape of Lucretia* opens on April 29th for three performances. For full details and ticket information, follow our box office links below.
