+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-05-31T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "David McVicar's production of [_Andrea Chenier_](https://www.roh.org.uk/productions/andrea-chenier-by-david-mcvicar) runs at the Royal Opera House through 9 June."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1559322145/media/2019/05/sq2862ashm_0669RobertoAlagnaasAndreaChenierSondraRadvanovskyasMaddalenadiCoignyROH2019.jpg"
primary_image_credit = "Roberto Alagna as Andrea Chenier and Sondra Radvanovsky as Maddalena di Coigny in Andrea Chenier, ROH, 2019. Photo: Catherine Ashmore."
related_articles = ["articles/talking-with-singers-sondra-radvanovsky.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/roberto-alagna.md", "scene/people/sondra-radvanovsky.md"]
short_description = "It is an increasingly rare occasion to feel moved in the way I was watching this performance when I go to the opera now. Perhaps I'm spoiled; too much of a good thing, and all that."
slug = "great-stars-great-direction-andrea-chenier-at-roh"
title = "Great stars & great direction: Andrea Chenier at ROH"
youtube_url = ""

+++
As someone who claims to be an adherent of the verismo movement in opera, I have to admit I know very little about Giordano's work, but can now say I've been thoroughly enlightened by this revival of [David McVicar's stunning production](https://www.roh.org.uk/productions/andrea-chenier-by-david-mcvicar) of the composer's popular 1896 opera. Though written in the late 19th century, it is set nearly a hundred years earlier in Paris at the time of the French Revolution and is based loosely on the life and death of revolutionary poet, Andrea Chénier. Culturally, the Enlightenment age of the 18th century is a world apart from the ideals that began to develop particularly around the turn of the 20th century, but verismo's realist approach to these historical events lends itself very well to the storytelling in that it enables these moments to be  presented in a way that is unbiased, truthful, and deeply human.

>It is everything one would expect from opera and more.

Giordano's third opera and arguably his most popular, tells a fated love story set against the backdrop of festering political unrest. Here, the political events are not coincidental but pivotal to the plot. And just as in life, there are no true villains. Even in their most depraved moments, each character motivated by a series of complicated emotions, responsibilities, and ideals, elicits our sympathy. Hats off to librettist Luigi Illica whose carefully crafted libretto demonstrates a perceptive storytelling that is pure poetry.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559322282/media/2019/05/2862ashm_0508RosalindPlowrightasCountessdiCoignyDimitriPlataniasasCarloGerardROH2019.jpg){{% /md %}}

<figcaption>Rosalind Plowright as Countess di Coigny and Dimitri Platanias as Carlo Gerard in Andrea Chenier, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

The music, though less thrilling than that of his contemporaries Puccini and Mascagni, is a discerning setting of Illica's text in that it strives foremost to serve the story. The orchestral writing is rich and descriptive with thematic music for each character and almost film-like, every action on stage is reflected by the orchestra. But it was the interludes between moments of action on stage in particular that were the most magical. Giordano's lush and inventive writing filled out these moments representing the passing of time and giving the story space to breathe.

>Vocally, he lacks subtlety, though he certainly possesses one of the greatest instruments of his generation.

What McVicar does very successfully with his productions is present opera with a level of grandeur and spectacle that is a visual representation of the breadth of the story and of the score itself. It is everything one would expect from opera and more. This production featured opulent and lofty set designs by Robert Jones that painted an increasingly deteriorating picture with each act as class divides became more of an issue, and tensions rise as peace begins to crumble in Paris over the course of the revolution. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559322298/media/2019/05/2862ashm_1468SondraRadvanovskyasMaddalenadiCoignyDimitriPlataniasasCarloGerardROH2019.jpg){{% /md %}}

<figcaption>Sondra Radvanovsky as Maddalena di Coigny and Dimitri Platanias as Carlo Gerard in Andrea Chenier, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

We end in a darkened prison cell where the lovers await the guillotine; a stark contrast to the glistening ballroom of the Contessa di Coigny where they first meet at the beginning of the opera. Costuming by Jenny Tiramani adds to the atmosphere, as the stage symbolically becomes a wash of red, white, and blue with costumes that are both era appropriate, and subtle as well as pleasingly thematic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559322313/media/2019/05/2862ashm_1376SondraRadvanovskyasMaddalenadiCoignyDimitriPlataniasasCarloGerardROH2019.jpg){{% /md %}}

<figcaption>Sondra Radvanovsky as Maddalena di Coigny and Dimitri Platanias as Carlo Gerard in Andrea Chenier, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

But none of this would have been as convincing without the singers who committed so whole-heartedly to their characters. The star-studded cast saw Roberto Alagna in the title role, Sondra Radvanovsky as Magdalena di Coigny, and Dimitri Platanias as Carlo Gérard and it was immediately apparent how these singers earned their superstar status. Not only was the singing extremely accomplished, but the chemistry was tangible, and the physicality of performance was fully embraced. They took on their characters with an honestly and a subtly that fully enveloped their many complexities, bringing the story to life.

>Platanias was an almost effortless Gérard immediately captivating and relatable.

Radvanovsky in particular was in top form from her first moment on stage. Though vocally she seemed to waver slightly in the second act, she returned stronger for her next entrance, demonstrating her professionalism, and ability. Her voice has a very moving almost hypnotic metallic quality that cuts through the wash of the orchestra beautifully and she only continued to impress me with the level of control she has over her instrument and the clarity with which she delivers her text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559322331/media/2019/05/2862ashm_0937SondraRadvanovskyasMaddalenadiCoignyROH2019.jpg){{% /md %}}

<figcaption>Sondra Radvanovsky as Maddalena di Coigny in Andrea Chenier, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

There can be no doubt that Alagna possesses a certain star quality. Now decidedly middle-aged, he has entered the grey area of playing romantic leads, but he nonetheless still cuts a dashing figure on stage so much so that I can almost forgive his somewhat endearing tendency towards over-acting on stage. Vocally, he lacks subtlety, though he certainly possesses one of the greatest instruments of his generation. There is the sense though that he is Roberto Alagna onstage as Andrea Chénier opposed to a full embodiment of the character but that being said, he is always emotionally engaging in a way that feels genuine and his voice, aside from the odd questionable high notes, always daringly walks the line between thrilling and nearly missing the mark.

>I think this one will stick with me for a while.

Platanias was an almost effortless Gérard immediately captivating and relatable. The character with the greatest arc, he did a wonderful job of taking the audience a long with him on his journey and remained a sympathetic character despite some of Gérard's darkest tendencies. Vocally, he was the most consistent on stage with a warm and enveloping sound that was uplifting and awe-inspiring in his many idealistic and poetic monologues that make him an embodiment of the revolution.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559322375/media/2019/05/2862ashm_0035RobertoAlagnaasAndreaChenierROH2019.jpg){{% /md %}}

<figcaption>Roberto Alagna as Andrea Chenier in Andrea Chenier, ROH, 2019. Photo: Catherine Ashmore.</figcaption>

</figure>

It is an increasingly rare occasion to feel moved in the way I was watching this performance when I go to the opera now. Perhaps I'm spoiled; too much of a good thing, and all that. But I think this production was special in the way that every aspect of it culminated in a whole that was greater than the sum of its parts. It represented an unparalleled level of commitment from all those involved across a variety of artistic pursuits which, for an audience member, has formidable and lasting effect. I think this one will stick with me for a while.