+++
author = ["authors/patrick-hansen.md"]
categories = "Editorial"
date = "2015-05-31T20:33:00-04:00"
lastmod = "2015-06-01T08:20:00-04:00"
preamble = "\"And I Know Things Now\" is by [Patrick Hansen](http://patricksoperablog.blogspot.ca/), Director of [Opera McGill](/scene/companies/opera-mcgill/) and author of a really great [blog](http://patricksoperablog.blogspot.ca/). Patrick was kind enough to share his work with our readers; the original post can be found [here](http://patricksoperablog.blogspot.ca/2015/05/and-i-know-things-now.html).\n\nGet to know Opera McGill on [YouTube](https://www.youtube.com/channel/UC4wjQ-ovggRS3lfxU1XmyVA):\n\n- [*Le nozze di Figaro*](https://www.youtube.com/watch?v=789T3UqK5Ig&feature=youtu.be) (preview)\n- [*Opera McGill's Year of Shakespeare*](https://www.youtube.com/watch?v=yVmF70SCDm8&feature=youtu.be)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433118411534/LittleRed.jpg.jpg"
primary_image_credit = "Photo: imgkid.com"
publishDate = "2015-06-01T08:00:00-04:00"
related_articles = ["articles/on-the-ego.md","articles/the-business-of-passion.md","articles/elitism-irony-and-the-phantom-of-the-opera.md","articles/how-i-acted-my-way-into-an-opera-career.md","articles/spotlight-on-geoffrey-penar.md"]
related_companies = ["scene/companies/opera-mcgill.md"]
short_description = "Nice is indeed diff&#039;rent than Good! These words came to mind recently again when a person who I&#039;m sure thinks of themselves as a good person was causing another person to suffer greatly. They did it nicely and that&#039;s why I think they thought they were still doing good. Nope, not good at all."
slug = "and-i-know-things-now"
title = "And I Know Things Now"
+++

The great Stephen Sondheim wrote:

> "And I know things now, many valu'ble things that I hadn't known before.
Do not put your faith in a cape and a hood, they will not protect you the way that they should. And take extra care with strangers, even flowers have their dangers, and though scary is exciting, nice is diff'rent than good." - Little Red from *Into the Woods*.

I've repeated those last 5 words to many groups of people - young artists gathering for the first time, students in a rehearsal for the first time, also privately to many young singers or pianists, and at many dinner parties. Some, not all, understand the sentiment.

Nice is indeed diff'rent than Good! These words came to mind recently again when a person who I'm sure thinks of themselves as a good person was causing another person to suffer greatly. They did it nicely and that's why I think they thought they were still doing good. Nope, not good at all. So I sang the song to myself, yet again. This time though, I started to think about the words at the start of the verse...

Those other lines are as interesting to ponder as well.

So I'd like to write about faith and singing. Yes, truly!

Putting one's "faith in a cape and a hood" is a lot like putting faith in a person or a process. It's important to know if you are putting faith in the process itself, or in the person responsible for said process.

Too general and vague?  I should get more specific...

Shamar Rinpoche once described the "4 Ways of the Wise":

1. Depend on the teaching, not on the teacher.
2. Depend on the meaning and not on the words.
3. Depend on the depth and not on the surface.
4. Depend on wisdom and not concepts.

These are four ideas perfect for talking about singing and the process involved in learning to sing.

### 1. Depend on the teaching, not on the teacher.

So true -- how many singers head to a specific studio to study with a certain teacher only knowing their name and reputation, but nothing about their technique or pedagogical philosophy? Too many think something like "Well, so-and-so won a huge voice competition so that means their teacher MUST know what they're doing!" Yes?!

Well, sometimes yes; sometimes no. Learning to sing is about many things, it is certainly not about studying with someone famous, or someone a singer might think will be politically the better choice. Those ideas are about furthering one's career either at a school or out in the big professional world. If you are still in need of technique, then make sure you are focusing on the teaching, not the teacher. If your teacher's teaching isn't making a positive impact in your singing, or if your teacher's teaching is too long a process ("stay with me and I will get you onto the Met stage with 6 hard years of work"), or overshadowed by other issues, like personality conflicts or too much psychological mumbo-jumbo they're not qualified to give, take your money elsewhere.

The same could be said of institutions. Depend on the teaching happening within those walls, not just on the reputation of those walls.

### 2. Depend on the meaning and not on the words.

This one is harder to understand. You have to access your instincts here. You have to listen between the lines and watch things you can only hear. It's about digging deeper. Into yourself, your score, your voice, your imagination. It's about trusting your own curiosity to ponder intent.

What are the intentions of your coach? Your teacher? The composer? The librettist? What are they trying to say that perhaps they can't articulate with words. Or notes. Or pitches. There's meaning all around us, yet we latch on to words only, all too often. "Your vowels are too dark." "It's marked piano." "I think you're not right for Edgardo." "Your high notes will come when you're ready." "Think blue."

Don't trust those words. Look for the meaning behind them. Trust your instincts.

### 3. Depend on the depth and not on the surface.

This one's easy. Ponder an iceberg. It's surface is not at all what its full structure is. The superficiality of all of us is simply not what we are. Mozart is not all "I, IV, V chord progressions" as a colleague once described his music, nor is Menotti a bad composer (over-rated maybe...)

Diving deep into a score, into a libretto, into a character, into a design or concept -- this is what makes me happy to be living in this sea of opera. There's just SO MUCH DEPTH in opera! It never ceases to amaze me when someone says they "know" Mozart's *Così fan tutte*. Really? How is that possible? I've been living with that opera in my head since the 1980s and I wouldn't ever think I knew it! I'm still pondering the depths of Act 2. It'll keep my head spinning until I die, and that's just one part of one opera by one master composer. If you don't like uncertainty, if you want to know the answers, if not knowing something leaves you anxious or upset or feeling stupid, or if you think there are answers to be found by looking at those black dots on those millions of white pages, then please think about doing something else with your short life. Become a critic perhaps.

### 4. Depend on wisdom, not concepts.

Lots of concepts out there. Many are quite helpful. "Nice is different than good" is a concept. When I sing Little Red's aria from time to time, it reminds me to open my mind about situations not always being as they seem. Wisdom is, again, instinctual. What makes something wise as opposed to smart, witty, or a revelation? Wisdom is something you find, I think. It is all around us, but forgotten or temporarily invisible until our mind's eye ponders an idea and passes through the surface of the idea into a deeper understanding.

It's through a focused, and concerted effort to delve the depths of discovery that one can find wisdom. It is through understanding meaning and intention that one can begin to dive down below these surfaces all around us. These efforts teach us as much as any teacher could or can.

It's a palindromic effort, really. By going inward, one discovers an "undiscovered country" all around us.
