+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-05-10T20:54:00-04:00"
lastmod = "2018-05-10T20:54:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525999867472/SQimage1.jpg.jpg"
primary_image_credit = " A lizard in a teapot and a deer, one of the shadow puppet projections from The Experiment In Opera production of Matthew Welch's And Here We Are.  Photo: Jeanette Oi-Suk Yew"
publishDate = "2018-05-10T20:54:00-04:00"
related_companies = ["scene/companies/experiments-in-opera.md"]
short_description = "The opera is billed as a shadow puppetry opera. That sounds interesting but it is a concept that, while lending a certain artistic edge, falls short of fulfilling the promise of collaborative storytelling. The impression it leaves is more that of a crutch, which Welch&#039;s fine composition does not need. "
slug = "and-here-we-are-voice-versus-volume"
title = "And Here We Are: voice versus volume"
+++

It's voice versus volume in [Experiments In Opera](/scene/companies/experiments-in-opera/)'s presentation of Matthew Welch's [*And Here We Are*](http://experimentsinopera.com/portfolio-item/and-here-we-are/), which he also conducts. The opera is based on a memoir of Edgar Kneedler, a detainee in a World War II interment camp. With few exceptions, the individual style and vocal quality that the three supporting singers bring to their roles, is compromised by the production's high-octane acoustics. Baritone Daniel Neer, who wrote the lumbering libretto, sings Kneedler who dominates as he supplies the narrative. One wonders if this didn't set out to be a series of soliloquies.

The opera is billed as a shadow puppetry opera. That sounds interesting but it is a concept that, while lending a certain artistic edge, falls short of fulfilling the promise of collaborative storytelling. The impression it leaves is more that of a crutch, which Welch's fine composition does not need. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525999788736/AHWAPressShot5.jpg.jpg)
<figcaption>*And Here We Are*, Experiments In Opera, 2018.</figcaption>
</figure>

Welch's music is stirring, urgent and pulsating. He has imbued his jazzy score with a perfect degree of exoticism that grows from memory rather than harsh reality. This is a sophisticated composition with a strong sense of place, built on solid musical values. At a less consuming volume, and with voices heard naturally in a balanced environment, the results would be quite new and stunning. The supporting singers could have played a more significant and expressive vocal roles had they not been caught up in a volumized sound design. By creating a more spacious sound, the opera might even have generated some compatibility with the feel of the puppetry. 

This is not to detract from the beauty of the Javanese shadow puppets as they appear on a large screen next to the singers. It is just that the puppetry barely relates. The images were graceful and mysterious. Their interplay would have been striking in the right context but, in fact, they detracted from the opera. Also, the puppetry fell short of addressing the issues of hope and survival, among other things, that the director, Jeanette Oi-Suk Yew, mentions in a brief program note explaining her use of it. 

The image of the lizard in a teapot was an exception. It was presented as an accompanying visual to the questions of a menacing guard, inscrutably sung by Joe Chappel, whose galvanized bass managed to break through the din. A Phoenix flying across the sun, one of the more arresting images was an obvious reference to Kneedler's spirit and momentarily expressed the unspoken. Here was a glimpse of how the puppetry might have been integrated to assume the role of shared storyteller. Had the other images been similarly related, we would have looked to them for clarification and abstract meaning. At the very least, the relevance of the puppets to the opera would not be questioned. 

When, for whatever reason, the puppeteers ceremoniously, and with some difficulty, took down the projection screen and replaced it with a miniature model of a proscenium stage, we were left to wonder if we had missed something along the way. The appearance within the proscenium of a line of dancers resembling the Rockettes alternating with that of a series of beetles offered no credible explanation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525999798039/AHWAElyseandDanielPhotobyAaronSiegel.jpg.jpg)
<figcaption>Elyse Kakacek and Daniel Neer in *And Here We Are*, Experiments In Opera, 2018. Photo by Aaron Siegel.</figcaption>
</figure>

In the name of adventure or, more aptly, experimentation, Welsh plays with the balance between music and voice. There are moments, especially when the voices are closely synchronized, when he succeeds in creating something that is vocally unique. Had he taken a different approach to sound, the evening might have been filled with fascinating musical experiments. Perhaps it was, but we couldn't discern them. There were instances of distorted sound that could have been avoided in the intimate setting of National Sawdust, which seats around 200, in Willamsburg, Brooklyn. The performance space resembles the exterior of the bird's nest stadium from the Beijing Olympics and is an excellent facility that beckons the new.

That the singers came through as much as they did was testimony to their commitment to the project. Mezzo soprano, Kate Maroney, who conjured a serene presence, was otherworldly as an enlightened if hallucinatory figure. Elyse Kakacek, a soprano who appeared to have uncommon brightness in her voice beyond the amplification, evoked a vivid fellow detainee in the internment camp. Chappel's character was created when he folded his arms across his chest and his powerful bass emerged. Neer was in a class by himself, which in this case, was not a positive.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525999819613/IMG_4022_preview.jpg.jpg)
<figcaption>*And Here We Are*, Experiments In Opera, 2018.</figcaption>
</figure>

Neer's baritone is large, flexible and expressive. His range is vast and his portrayal needed a director's check to avoid being overbearing. He was on a different acting page than the other singers. While they traveled in subtle suggestions and minimal gestures, Neer went full-throttle, almost as if this were a fully staged opera. His intensity relegated the others to backup singers, throwing the intention of the piece off course. His energy was boundless but was not in keeping with his character. 

It was difficult to fully evaluate the libretto because there were times when it was lost track of, our attention being diverted by the puppets. Also phrases crushed by distorted sound were missed. There was redundancy in the part of Kneedler, however. The degrading hardship had been firmly established. We heard too much and felt like we had heard some of it before. Despite the riveting instrumental work, the opera began to lag.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525999807843/IMG_1962_preview.jpg.jpg)
<figcaption>*And Here We Are*, Experiments In Opera, 2018.</figcaption>
</figure>

The musicians were consistently magnificent. Ben Holmes on trumpet was especially notable. His stolid presence, which would have, inadvertently, been center stage had there been a conventional stage, grounded the evening. With flawless technique, he employed several mandrels to produce steady, penetrating and remarkably diverse sound. Joe Bergman, Chris Graham, Mark Utley and Joe Tucker on percussion and drums provided rhythmic support and crucial atmospheric detail. Ian Riggs was solid on bass guitar with foreboding but forward moving playing. Emily Manzo's subtle work on the piano could have been utilized so much more, especially in tandem with Holmes.

*And Here We Are* points to the value of organizations like Experiments In Opera. This appears to be a work that is finding its way, or perhaps forging its own path, in the genre. It wholly deserves the opportunity to evolve that EIO has provided. There is abundant merit to the composition and with revisions to the libretto, a refined concept, and a balance of voice, music and volume; this is an experiment that could occupy a place of note in opera's future. As for the shadow puppets, it would be illuminating to experience them on their own terms, perhaps in their own opera. Their capacity for nuanced storytelling mixed with elements of opera is an experiment that could likely yield wondrous results.

