+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2018-01-21T12:29:00-05:00"
lastmod = "2018-01-21T18:22:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555443085/sq---Christopher-Kenney-and-Leah-Hawkins-as-Pa-and-Ma-Zegner-in-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg"
primary_image_credit = "Christopher Kenney and Leah Hawkins as Pa and Ma Zegner in Missy Mazzoli's Proving Up. Photo: Scott Suchman."
publishDate = "2018-01-21T18:22:00-05:00"
related_articles = ["articles/the-start-of-something-powerful-the-echo-drift.md","articles/oksana-g-its-so-out-of-this-world-and-yet-so-realistic.md","articles/new-season-offerings-from-esprit-orchestra.md"]
related_companies = ["scene/companies/washington-national-opera.md"]
related_people = ["scene/people/timothy-j-bruno.md","scene/people/leah-hawkins.md","scene/people/madison-leonard.md","scene/people/allegra-de-vita.md","scene/people/arnold-livingston-geis.md"]
short_description = "This story also asks questions about the very nature of the American Dream. In the clutches of the Sodbuster, Miles is driven to question his entire mission. He asks &quot;Does a window make a home? Does a deed make the land yours?&quot; While these questions might have been better left implied rather than sung out loud, they lead to another question: Who really benefited from America&#039;s Manifest Destiny?"
slug = "an-operatic-horror-story-proving-up"
title = "An operatic horror story: Proving Up"
+++

The Washington National Opera's American Opera Initiative Festival kicked off on Friday night with the world premiere of *Proving Up*, a one-act opera by Missy Mazzoli and librettist Royce Vavrek. Mazzoli and Vavrek came to Washington fresh off the success of *Breaking the Waves*, which premiered to acclaim at Opera Philadelphia in 2016, and the Kennedy Center's Terrace Theater was electrified with excitement for their newest work.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555157755/The-cast-of-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg)
<figcaption>The cast of *Proving Up*, Washington Natioanl Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

*Proving Up*, based on a short story by Karen Russell, centers around a family of homesteading pioneers in 19th century Nebraska, and from the first chilling notes from Mazzoli's chamber orchestra, conducted energetically by Christopher Rountree, it becomes apparent that this isn't *Little House on the Prairie*. No, this opera is a horror story complete with vengeful ghosts haunting a family, desperate and destitute, obsessively repeating the four standards their farm must meet in order to "prove up," or, to gain status as deeded landowners: 

"House of sod, acres of grain, five years of harvest, a window of glass." 

These four items are repeated again and again throughout the hour-long opera so often that this reviewer didn't even need to look them up in order to remember them the following morning. The final requirement is what the story hinges upon, glass being an expensive and rare commodity on the prairie, but there is one glass window in the area, which the farmers have planned to share, transporting it from house to house in advance of the inspector's arrival.  Is it cheating?  Sure, but it's soon revealed that this bit of scheming is the least nefarious act these people have been driven to commit by their hardships.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555225780/Arnold-Livingston-Geis-as-Miles-Zegner-in-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg)
<figcaption>Arnold Livingston Geis as Miles Zegner in Missy Mazzoli's *Proving Up*, Washington National Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

The family's youngest son, Miles, is tasked with transporting the window to a neighboring farm. Tenor [Arnold Livingston Geis](/scene/people/arnold-livingston-geis/) infuses the role with just the right blend of childlike innocence, naivety, and reckless mischief. In the context of its surroundings, Miles' music is jarringly cheerful and optimistic. He wants to make his father proud by successfully completing the task he’s been trusted with, "proving up" himself in a way, but he can't resist the temptation to gallop his horse after being told to take it slow and steady, or to to take the window out of its protective burlap in the rain just to see the beauty of the water beading on its panes.

Miles is followed on his journey by the ghosts of his two sisters who both died on the homestead, sung by mezzo soprano [Allegra De Vita](/scene/people/allegra-de-vita/) and soprano [Madison Leonard](/scene/people/madison-leonard/), they lurk about the farmhouse dressed in knee-socks and wrinkled pinafores, unseen by every member of the family except Miles. Mazzoli's score treats the sisters as one unit, always singing together in close harmonies, and their presence is reminiscent of the ghostly twins in Stanley Kubrick's *The Shining*. Their music is some of the most ear-grabbing of Mazzoli's score, at times taunting the family in sing-song dark nursery rhyme tunes, then whooping and swooping as if their voices are only the wind blowing across the prairie, and most strikingly, turning to a harsh, low, screeching belt. De Vita and Leonard handle the vocal demands of their roles with ease, and seem to have fun with the characters' dark playfulness.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555248588/Allegra-De-Vita-and-Madison-Leonard-as-Taller-Sister-and-Littler-Sister-in-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg)
<figcaption>Allegra De Vita and Madison Leonard as Taller Sister and Littler Sister in Missy Mazzoli's *Proving Up*, Washington Natioanl Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

Soprano [Leah Hawkins](/scene/people/leah-hawkins/) has a commanding presence as the family's matriarch, tired and bent over from the back-breaking labor of homestead life, mourning her lost daughters, and desperate to protect her remaining children, all while constantly praying for rain. Hawkins voice is powerful and beautiful, and she infuses it with the overwhelming sadness of a mother who is losing faith that this life was the right choice for her family. At night, when the rest of her (living) family is asleep, Ma confesses that she believes that the inspector who has the power to grant her family the deed to their land is merely "a rumor," that he is "smoke" - a line that is later repeated tauntingly by the ghostly sisters.

Opposite Hawkins is baritone Christopher Kenney as Pa, the driving force of the narrative. With a robust voice, and macho demeanor, his music barrels forward like a steam engine even as he drinks himself sick, leaving Ma to do most of the work, and he stubbornly makes decisions, like sending his youngest son to transport the window, in spite of his wife's insistence that "we can't spare Miles." He is so possessed by his desire to "prove up" that he is willing to do whatever it takes, even if that means compromising his morals.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555236439/Allegra-De-Vita%2C-Arnold-Livingston-Geis%2C-and-Madison-Leonard-in-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg)
<figcaption>(l-r) Allegra De Vita, Arnold Livingston Geis and Madison Leonard in Missy Mazzoli's *Proving Up*, Washington Natioanl Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

The story takes a turn when Miles is caught in a storm and meets a mysterious stranger, named in the program as "The Sodbuster" and sung by bass [Timothy J. Bruno](/scene/people/timothy-j-bruno/). There is some ambiguity as to whether the Sodbuster is a living homesteader so destitute that he is reduced to almost nothing, dressed in rags and covered in dirt, a wide-brimmed hat casting his face in shadow, or if he is yet another ghost of a failed farmer. What is clear is that he is not a kindly presence, and Bruno's performance is wonderfully unsettling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555273409/Timothy-J.-Bruno-as-The-Sodbuster-in-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg)
<figcaption> in *Proving Up*, Washington Natioanl Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

Alison Moritz's staging does a lot with a little. The sparsely set stage evokes the wide-open nothingness of midwestern prairie, and a rope curtain backdrop resembles stalks of wheat rustling in the wind. The family, though living together in one tiny sod house, seem isolated from one another. The spare staging, and Mazzoli's icy, dissonant music leave little room for intimacy or warmth in this gothic tale.

The best horror stories leave you asking questions, and *Proving Up* does that. On the way home from the theater, I found myself wondering, did the sisters in their ghostly mischief make this tragedy? Did they do it as an act of revenge for their deaths which might have been avoided had Pa not decided to head west? Was the Sodbuster a ghost or a living man? What became of his family? Was Ma right about the inspector being only a rumor?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516555248588/Allegra-De-Vita-and-Madison-Leonard-as-Taller-Sister-and-Littler-Sister-in-Missy-Mazzoli's-Proving-Up.photo-Scott-Suchman.jpg.jpg)
<figcaption> in *Proving Up*, Washington Natioanl Opera, 2018. Photo: Scott Suchman.</figcaption>
</figure>

This story also asks questions about the very nature of the American Dream. In the clutches of the Sodbuster, Miles is driven to question his entire mission. He asks "Does a window make a home? Does a deed make the land yours?" While these questions might have been better left implied rather than sung out loud, they lead to another question: Who really benefited from America's Manifest Destiny? For the family at the center of *Proving Up*, the effort to build a farm and become landowners was not so much a promise as a curse.
