+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2018-01-14T20:16:00-05:00"
lastmod = "2018-01-15T12:53:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978720270/sq---Josh-Lovell_Amber-Wagner_TURANDOT_LYR171202_318_c.Todd-Rosenberg.jpg.jpg"
primary_image_credit = "Josh Lovell (Altoum) and Amber Wagner (Turandot) in Turandot, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg."
publishDate = "2018-01-14T20:16:00-05:00"
related_articles = ["articles/a-problematic-creaky-old-masterpiece-les-vpres-siciliennes.md","articles/rohs-madama-butterfly-better-to-be-furious-than-bored.md","articles/pass-the-tissues-a-beautiful-new-bohme-in-chicago.md","articles/glamour-fury-idomeneo-in-chicago.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/amber-wagner.md","scene/people/janai-brugger.md","scene/people/stefano-la-colla.md","scene/people/zachary-nelson.md"]
short_description = "Ultimately, the vision of &quot;China&quot; that Puccini articulated with his Turandot is pure fantasy. While his scrupulousness in incorporating elements of Chinese music-making into his score is self-evident, there is little to suggest the other trappings of Turandot are anything other than an over-eagerness on the part of Puccini and his librettists to produce a spectacle that no one had seen before."
slug = "an-operas-evolving-relevance-turandot"
title = "An opera&#039;s evolving relevance: Turandot"
+++

An imperious gold dragon coils around the stage of the Lyric this January, its enormous serpentine body and outstretched talons frame the stage for performances of [*Turandot*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/turandot-opera-tickets), Puccini's final and most lavish opera. This visually splendid production, designed by Allen Charles Klein, has the old-school spectacle you crave in a Turandot without the elaborate fussiness of Zeffirelli's famed Met production.

The opera begins with the recitation of Princess Turandot's terrible decree: she will only marry a man who can correctly answer her three riddles. Any man who fails will be put to death. This pronouncement is made by third-year Ryan Opera Center bass Patrick Guetti, who cuts an imposing figure as the Mandarin, with a deeply sonorous, captivating voice. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978301131/TURANDOT_LYR171202_062_c.Todd-Rosenberg.jpg.jpg)
<figcaption>*Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg.</figcaption>
</figure>

A would-be suitor will soon be put to death. Villagers flood the stage and from the melee emerge three figures: Calaf, (tenor [Stefano La Colla](/scene/people/stefano-la-colla/)), his father, King Timur, (Lyric regular Andrea Silvestrelli), and their ill-fated servant-girl Liù, (soprano [Janai Brugger](/scene/people/janai-brugger/.) Brugger is a Chicago native making her Lyric debut with the January performances of *Turandot*, continuing from Maria Agresta's run in December. There is no doubt, she is a consummate, committed actor with a beautiful, flexible instrument. One of the most arresting things about Brugger's performance was her daring to sing very, very softly—immediately drawing the audience in with her arresting Act I aria, "Signore ascolta." In an opera where all too easily the characters can become mere archetypes, Brugger's earnest portrayal of Liù is truly beautiful to watch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978321897/Andrea-Silvestrelli_Stefano-La-Colla_TURANDOT_LYR171202_023_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Andrea Silvestrelli (Timur) and Stefano La Colla (Calaf) in *Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg.</figcaption>
</figure>

Silvestrelli's turn as King Timur, (his twelfth role at the Lyric and second this season), was more successful than other recent credits. His aging (but still booming) sound is perfect for the character of Calaf's elderly father and Silvestrelli's response to Liù's death in the third act was very moving and tender.

*Turandot* also marks the Lyric debut of tenor Stefano La Colla, who delivered a serviceable Calaf, though his performance lacked the dramatic urgency of Janai Brugger and the vocal prowess of [Amber Wagner](/scene/people/amber-wagner/) as Turandot. His singing became better over the course of the evening but generally lacked the shaping and nuance that Puccini’s melodies so deserve.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978358347/Amber-Wagner_TURANDOT_LYR171202_314_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Amber Wagner (Turandot) in *Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg.</figcaption>
</figure>

Ryan Opera Center alum Amber Wagner possesses a voice that is undeniably massive and beautiful. Even in the vocal stratosphere that this role demands, Wagner maintains a sense of ease and a remarkably consistent, cushy tone that is always lush and easy to listen to. I was
captivated by Wagner's commanding (but never petulant) and vulnerable (but never weak) characterization of Princess Turandot. Turandot's emotional journey is framed by the tragic deaths of two women: her predecessor is abducted and brutally murdered by the leader of an invading army, an event that spurs Turandot's creation of the riddle game as a way to insulate herself from conquest by men. Liù's death — the result of Turandot's desire to avoid wedding Calaf at all costs — is the other crucial tragedy. In Wagner's subtle portrayal, it is through watching love destroy another woman that Turandot realizes she herself has already fallen for Calaf, which in equal parts thrills and terrifies her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978386400/Keith-Jameson_Rodell-Rosel_Zachary-Nelson_TURANDOT_LYR171202_131_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Keith Jameson (Pong), Rodell Rosel (Pang), and Zachary Nelson (Ping) in *Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg.</figcaption>
</figure>

*Turandot*, along with *Madame Butterfly*, *The Pearl Fishers* and other operas set in ambiguously "Asian" landscapes are increasingly deemed problematic for their exoticist/Orientalist bents. Undeniably, none of these operas could have been written without
the backdrop of colonialism and eurocentrism that influenced art across all genres during the 19th and early-20th centuries. In "Turandot: Modernity, Orientalism, and Love," a beautifully composed essay by Susan Halpern included in the program book, Halpern goes to great lengths to couch Puccini's fascination with Chinese culture and his dramatic choices with *Turandot* within the geopolitical realities and artistic movements of the early-twentieth century. Her aim is to illuminate how *Turandot* is, (for better or worse), a complex product of its time.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516038797502/Janai-Brugger_TURANDOT_c.Andrew-Cioffi.jpg.jpg)
<figcaption>Janai Brugger (Liù) in *Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Andrew Cioffi.</figcaption>
</figure>

Ultimately, the vision of "China" that Puccini articulated with his Turandot is pure fantasy. While his scrupulousness in incorporating elements of Chinese music-making into his score is self-evident, there is little to suggest the other trappings of *Turandot* are anything other than an over-eagerness on the part of Puccini and his librettists to produce a spectacle that no one had seen before.

For my part, I am less interested in whatever futurist symbolism and patriotic zeal drove Puccini to create *Turandot*, and am far more interested in how his elaborate telling of this "Chinese" story in such an over-the-top, fantastical way illuminates issues that we are undeniably grappling with in 2018: a growing ambivalence toward the institution of marriage, insidious fears about women in positions of political power, the archetype of the vengeful, emotionless woman, and the oft-unspoken anxiety that to submit to a relationship is to lose one's autonomy and sense of purpose. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978407285/Josh-Lovell_Amber-Wagner_Stefano-La-Colla_TURANDOT_LYR171202_618_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Josh Lovell (Altoum), Amber Wagner (Turandot), and Stefan La Colla (Calaf) in *Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg.</figcaption>
</figure>

Puccini's "LOVE CONQUERS ALL" pivot in Act III elicited audible groans from the audience last night. When Calaf victoriously proclaims to Princess Turandot, "You are mine now," I twitched in my seat, half-hoping Turandot would decide right then to behead this man who would subdue her. The ultimate message of the opera, as articulated plainly by Calaf, is that love is not subjugation but is the truest freedom. 

That this feels trite and a bit feeble is perhaps less a sign that it's time for opera to move on from this titanic work and more a sign that an opera's relevance, meaning, and even political resonances can evolve and change with time, however limited in perspective its original composition may have been.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515978520627/TURANDOT_LYR171202_077_c.Todd-Rosenberg.jpg.jpg)
<figcaption>*Turandot*, Lyric Opera of Chicago, 2017/18. Photo: Todd Rosenberg.</figcaption>
</figure>

The Lyric Opera Chorus — 85-strong and dressed as villagers, crowded the stage and filled the theater with glorious, full-throated singing from top to finish, leaving no doubt that this is one of the very finest opera choruses in North America. The Chicago Children's Chorus made a lovely contribution as well.

Sir Andrew Davis leads the massive orchestra and offstage brass with aplomb. Moments of shaky coordination between principals and the instrumentalists below were quickly resolved and soon forgotten. You have three more chances to catch *Turandot* onstage at the Lyric Opera of Chicago, January 17, 21, and 27th.

>For details and ticket information for Lyric Opera of Chicago's [Turandot](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/turandot-opera-tickets), follow our box office links below.
