+++
author = ["authors/laura-attridge.md"]
categories = "Op-ed"
date = "2017-07-16T10:27:00-04:00"
lastmod = "2017-07-17T08:13:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500216289621/2017-07-16---Letter.jpg.jpg"
publishDate = "2017-07-17T08:13:00-04:00"
short_description = "Panels don&#039;t often offer feedback to candidates: it&#039;s time-consuming and usually difficult to successfully administrate in the aftermath of a set of auditions. So here&#039;s a general note I wish I could send to everyone who auditions for me:"
slug = "an-open-letter-to-audition-candidates"
title = "An open letter to audition candidates"
+++

Dear Audition Candidate,

So here we are again, facing each other across another room. Your CV is on the table in front of me, between us: a small bridge towards understanding who you are and what you have to offer me. And then there's you, preparing to sing your first aria, while the air is still full of possibility.

I should probably mention at this juncture that I've been where you are: on your side of that table, wearing my smartest audition outfit and my most engaging smile. Back in the day. So I know what it feels like. But it's rare that you get a chance to experience, or even get an insight into, what it's like on my side. So I thought I'd write to you and see what I can do to lift that invisible curtain, just a little. After all, it's only fair.

## Trust

The main thing I'm hoping to feel by the end of your audition is trust - which seems simple enough, but in my experience, trust is formed of a myriad of factors, some tangible but others a little harder to pin down.

A colleague of mine recently drew me a "trust graph", with Care on one axis, and Competence on another. He said, "You have to have both of these elements to trust someone." It applies to all sorts of things in life, but I find it particularly helpful to consider in auditions. 

Someone can be high on the Care axis for a numerous reasons: if they're warm and friendly, and I connect with them personally; if they show me they've put a lot of thought and care into their audition, through research and preparation; if they display clearly that it's my project they're particularly interested in being a part of, and they've already put some emotional investment in, like I have. But if these are the only things I'm getting, they can only rise in my affection, not my trust. 

On the other hand, to progress on the Competence scale I need to see different things: that you're vocally able to sing the role to a particular standard; that you're an organised and well-prepared colleague; that you can bring acting and physical awareness to the table; that you're calm under pressure; et cetera. Again, if you're only giving me Competence, I will respect you, but I won't trust you.

Only by gaining ground on both axes can you gain my trust, and I will only want to work with you if I trust you.

## Hope

You walk into the room hoping I'll want to work with you. Well, guess what? I'm hoping the same thing. You've probably heard that before, but I'm going to say it again, because it's a difficult concept to really get your head around when you're the one standing there feeling judged: I want to want to work with you as much as you want me to want to work with you. 

I'm sitting there behind my table, willing candidate after candidate, without exception, to be the answer to my casting prayers. I promise you, you could not walk into a room full of people more prepared to like you, to cast you.

But auditions suck, right? You know what: they suck for me, too. Because more often than not, I don't get to see how fantastic you are because you're underprepared, or nervous, or disorganised, or trying to be what you think I want you to be instead of yourself. I can't tell you how frustrating that is.

## Control

Good news! There are things you can take responsibility for, and things you can't. Yes, that's all good news.

As you'll know from the many "Top Ten Tips for Auditions" articles floating around out there, there are all sorts of factors you can control – to boost both the Care and Competence axes – which I needn't list here. These are important things to master, and can simply but effectively ensure you've got the foundation for a fantastic audition.

As you'll also know, there are plenty of factors out of your hands: subjective impressions of your performance and personality, whether we've heard your aria thirty times already that day, who else we're thinking of casting opposite the role you're going for, and so on.

Here's the great thing: if you truly take responsibility for the things you can control, you can know with absolute certainty that the panel's decision – incorporating all those uncontrollable things – was nothing to do with you, and everything to do with them. If you show up as your authentic self, you give me the clearest possible insight into what you have to offer as an artist and colleague, and with this knowledge I can make the best decision about who is right for this particular role, in this particular project.

## Gratitude

Panels don't often offer feedback to candidates: it's time-consuming and usually difficult to successfully administrate in the aftermath of a set of auditions. So here's a general note I wish I could send to everyone who auditions for me:

Thank you. For your courage and generosity in sharing your craft with me and my colleagues on the panel. For the time and effort spent preparing and travelling. For offering yourself as a potential collaborator in my rehearsal room, as part of my project. For allowing yourself to be vulnerable. For trusting me.

Good luck.

Yours sincerely,

Laura Attridge

>Laura would love to work with you on your audition technique at her upcoming masterclass [Preparation and Presentation: Opera Auditions Masterclass](https://www.eventbrite.co.uk/e/preparation-and-presentation-opera-auditions-masterclass-tickets-35771086282), as part of And So Forth's autumn series of development workshops for performers. Sessions on [acting](https://www.eventbrite.co.uk/e/script-vs-score-acting-for-opera-singers-tickets-35770738241) and [physical characterisation](https://www.eventbrite.co.uk/e/moving-characterisation-the-performer-the-body-tickets-35771390191) are also available. For full details, visit the [And So Forth website](www.asfp.uk/project/workshops).
