+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-06-22T20:51:00-04:00"
lastmod = "2018-06-22T21:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529714626644/sq006125_fa45b08dd38f438e99133f3f98486e25_mv2_d_4129_4432_s_4_2.jpg.jpg"
primary_image_credit = "Chelsea Beatty (left) and Arielle Rogers in Divas. Photo by TStop Pictures."
publishDate = "2018-06-22T20:51:00-04:00"
short_description = "But of course, I would be remiss if I did not mention Arielle Rogers as Sisieretta Jones. Arielle Rogers had easily the most to do throughout the night: Sisieretta eventually became the emotional core of the evening, and that is no small task."
slug = "an-insightful-relevant-look-at-divas"
title = "An Insightful, Relevant Look At Divas"
+++

In Laura Neill's [new play *Divas*](http://www.operahub.org/upcoming), nine historical opera divas find themselves trapped in a set of barriers in the afterlife, in which they spend the entire play debating ways to get out. At one of the divas' suggestions that they start relating the stories of their lives, Swedish diva Jenny Lind wryly asks something along the lines of "has this become story time now?" At around the time she initially asked, I felt like she was speaking for the audience, which by that point had been treated to a monologue and aria by no less than Adelina Patti herself.

However, as the play wore on, and each successive diva told each other their life stories through monologue and aria, a singular thread of struggle against societal norms and expectations began to peek through all the monologues, whether it be through Pauline Viardot Garcia's lamentations against being called a "hermaphrodite" in her lifetime through 19th-Century France or with Lina Cavalieri's anger at the Americans responsible for the World War II bombing in which she perished. The common connective thread ran through the whole evening, and it was this thread that held the whole evening together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529714927784/006125_4ce67cb75d1a4b46bd492aa0cc122276_mv2_d_5701_3800_s_4_2.jpg.jpg)
<figcaption>The ensemble in *Divas*. Photo by TStop Pictures.</figcaption>
</figure>

It also helps that Laura Neill does more with her premise than simply have all the divas park in front of the audience and tell them their life stories: after all, it has the overarching plot, and by necessity all the divas interact with each other. Much of their dialogue is full of incredibly witty banter, and when the women are arguing with each other (as they often do), they have so many ingenious insults and quirks they throw at each other that it wrangled a healthy amount of laughs. (A favorite moment of mine came when American diva Geraldine Farrar asked Jenny Lind "didn't you perform with a circus" in response to Lind putting down fellow American Sisieretta Jones for singing in the vaudeville circuit.)

But the real magic of Neill's script is that it finds links between the disparate backgrounds of its divas and really finds the soul of what makes them so alike. There's a moment early in the show in which Sisieretta, who was African-American, connects with Russian diva Parasha Kovalyova over their shared ties to slavery (Parasha was a serf, whereas Sisieretta was the daughter of a former slave): it gives Parasha the first full-bodied lines of dialogue in the show, and when they courtesy to each other it provides a moment of solidarity that hints at what eventually happens to all of these women. There are many other connections the show utilizes to its advantage (Maria Malibran and Viardot Garcia’s connection as sisters, Lind and Viardot Garcia singing a duet because they sang one together in real life, the fact that Sisieretta was called the "Black [Adelina] Patti"), but they all coalesce into a beating heart that imbues the play with a human element that keeps the whole enterprise from being incredibly preachy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529714937135/006125_5b97b446358c4e5ca1049ac21e9ec8b3_mv2_d_6720_4480_s_4_2.jpg.jpg)
<figcaption>Arielle Rogers in *Divas*. Photo by TStop Pictures.</figcaption>
</figure>

Of course, peppered throughout is a selection of arias and, eventually, duets from each of these singers' repertoires: the selection was varied and diverse in terms of composership, ranging from Gluck and Meyerbeer all the way to Puccini and Florence Price. The conceit generally worked quite well, and, barring one or two exceptions, the aria selections often served the story, which is no small feat considering that they were all plucked out of their original contexts and inserted into new ones. "Sì, mi chiamano Mimì" became Lina Cavalieri's warm vocal intro, for instance, and "Aux langueurs d'Apollon" proved to be a rousing eleven o'clock number for Sophie Arnould to rally the rest of the women.

Of course, this required the talents of actual opera singers, which always proves a challenge when it comes to spoken dialogue. And here, they chose a very strong ensemble cast, all of whom were quick on the draw with their banter but who also were able to find the humanity of their characters. In particular, Lindsay Conrad made for a delightfully quick-witted Sophie Arnould, and Carrie Reid-Knox brought plenty of pathos to the ever-beleagured Maria Malibran. Also noteworthy was Erin Anderson as a Jenny Lind who hides behind the need to pray before her layers are peeled away, and Kathryn McKellar's dignified, warm performance as Lina Cavalieri.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529714946343/006125_6860e74a886b4eddbbaf921a61f20e5c_mv2_d_6720_4480_s_4_2.jpg.jpg)
<figcaption>(l-r) Carrie Reid-Knox, Erin Anderson, and Glorivy Arroyo in *Divas*. Photo by TStop Pictures.</figcaption>
</figure>

Vocally, the cast was slightly more hit and miss. Christie Lee Gibson delivered the best spoken monologue of the night as Parasha Kovalyova, but she seemed uncertain of herself when it came time for her to sing, and it showed when singing "O toi que j'aime" with a voice that seemed almost too frail for that aria's difficult writing. Abigail Whitney Smith ended up not having much to do as Geraldine Farrar, but her rendition of "Senza mamma" from *Suor Angelica* was easily the best part of the first act. Other highlights included Chelsea Beatty giving "Sempre libera" a defiant air different from the one Adelina Patti would have given to Violetta, and I also quite liked Glorivy Arroyo's deeper voice when she sang one half of "La mère grand".

But of course, I would be remiss if I did not mention Arielle Rogers as Sisieretta Jones. Arielle Rogers had easily the most to do throughout the night: Sisieretta eventually became the emotional core of the evening, and that is no small task. Nevertheless, Rogers met the demands of the role head-on. As an actress, she conveyed the soothing nature of the character and her wish to be labelled on her own terms with dignity and a sense of bitterness that found the right times to come out. Her voice was warm and wonderful, and her rendition of Lullaby (for a Black Mother) was the perfect way to start Act 2. It's almost a pity she is placed second on the cast list in the program: Ms. Rogers should have higher billing than that!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529714954027/006125_8ab3c10817da424680b264819230bf37_mv2_d_6419_3792_s_4_2.jpg.jpg)
<figcaption>The ensemble in *Divas*. Photo by TStop Pictures.</figcaption>
</figure>

These women all found ways to bring what is a very wonderful play to life, but alas, there are two issues with the play. The first, is that its intermission seems entirely pointless. I do not know if this was strictly from Laura Neill, as the closing tableau of Act 1 was identical to the opening tableau of Act 2, so part of me is tempted to say it was a directorial decision to give the audience a break. However, it deflates some of the energy that the show built up right before the end of the first act. It also betrays a small lack of faith in the audience, one which seems unwarranted: if patrons can sit through *Rheingold* with no problems, then this should be no issue to sit through in one go.

The second, is that its minute-long epilogue was incredibly confusing, particularly in combination with the play's prologue. The play begins with nine singers sitting in a dressing room talking about the issues opera singers today face. This prologue bears no connection to the plot, but it provides a contemporary analogue to the central theme while also setting up the motif of remembrance of the past. However, the symbolic function of the prologue is undercut by the epilogue. After all of the divas sing a final aria together, the barriers finally fall and the women are freed, and then… the divas suddenly become the women in the dressing room? Was the entire preceding play a fantasy the nine women from the prologue were acting out? Were we in the afterlife after all? It might have been wiser to cut the spoken epilogue entirely: the show could not have chosen a better conclusion than in letting all of the divas sing "Dido's Lament": the line "remember me, but ah, forget my fate" offers the perfect thematic double bar, particularly when Neill turns the lyric on its head by having Sisieretta sing "do not forget my fate" right before the barrier breaks.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529714963465/006125_bfa53dd58ebe439f8725e404f2198b23_mv2_d_6720_4480_s_4_2.jpg.jpg)
<figcaption>The ensemble in *Divas*. Photo by TStop Pictures.</figcaption>
</figure>

Still, these mishaps became relatively minor in the grand scheme of things. The material these women have to work with is already quite strong in a number of ways, and the performances involved only made the material stronger. With any luck, this play will have an afterlife much less tumultuous than that of the divas it portrays, and it will be a well-deserved afterlife.
