+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2019-03-19T17:01:24+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553015129/media/2019/03/sqSoYoungPark_ANAMERICANDREAM_LyricOperaofChicago_LYR190314_195.jpg"
primary_image_credit = ""
related_articles = []
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/nina-yoshida-nelsen.md", "scene/people/christopher-magiera.md", "scene/people/so-young-park.md", "scene/people/catherine-martin.md"]
short_description = "With music by Jack Perla and libretto by Jessica Murphy Moo, An American Dream spotlights the lives of two families against the backdrop of Japanese internment by the U.S. government following the bombing of Pearl Harbor in 1941."
slug = "an-american-dream-an-opera-that-hits-home"
title = "An American Dream: an opera that hits home"
youtube_url = ""

+++
The success of Lyric Unlimited, the LOC's civic outreach initiative, is founded on its ability to mount crucial new operas that resonate with the times and communities the program serves. Following last season's captivating [_Fellow Travelers_](/fellow-travelers-is-luminous-in-chicago/), Gregory Spears opera about the 1950's "lavender scare," Lyric Unlimited again impels Chicago audiences toward self- and historical-reflection with its run of [_An American Dream_](https://www.lyricopera.org/concertstickets/calendar/2018-2019/an-american-dream-opera-tickets), performed twice this past weekend at the Harris Theater for Music and Dance.

With music by Jack Perla and libretto by Jessica Murphy Moo, _An American Dream_ spotlights the lives of two families against the backdrop of Japanese internment by the U.S. government following the bombing of Pearl Harbor in 1941.

During the opening orchestral prelude, we meet the Kobayashis, a hardworking Japanese-American farming family living a quiet life on Puget Sound Island. Fearful of increasing persecution and the government-mandated "evacuation" of people of Japanese decent, the Kobayashis consolidate and destroy any personal items reflecting their heritage. Papa, Makato, snaps a beloved vinyl record while Mama, Hiroko, concedes to burn old photographs of her parents. Their daughter, Setsuko, however, refuses to discard her Hinamatsuri doll, a treasured heirloom that belonged to her mother and grandmother; instead, she hides it under the floorboards of her bedroom.

> As a whole, the cast of this production delivered heartfelt and gripping performances.

Jim Crowley and his wife Eva enter the scene as prospective home-buyers with an eye toward the Kobayashi property. As Eva, herself an immigrant of German-Jewish origins, roams and admires the surrounding land and the promise of safe harbor it offers, Jim takes advantage of the Kobayashi's plight with a low-ball offer for the purchase of their home. At the same moment, FBI agents arrive to arrest Makato Kobayashi, naming him a suspected threat.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553015255/media/2019/03/JeffDiebold_AoLi_NinaYoshidaNelsen_ANAMERICANDREAM_LyricOperaofChicago_LYR190314_139.jpg){{% /md %}}

<figcaption>Jeff Diebold, Ao Li, and Nina Yoshida Nelsen in An American Dream, Lyric Opera of Chicago/Lyric Unlimited, 2019. Photo: Todd Rosenberg.</figcaption>

</figure>

While the Kobayashi family struggles with incarceration and separation from one another, Jim and Eva busily settle into their new home with the hope that Eva's parents will soon escape Germany and join them in America. Eva, however, discovers Setsuko's doll and begins to question Jim about the house's previous owners. In the face of Jim's cold-heartedness ("They were Japs," he says, "sent to the camps."), Eva finds and reaches out to Setsuko, inviting her to their home at the war's end. In the opera's heart-wrenching denouement, Setsuko confronts Jim about his coercion. Eva returns to Setsuko her favorite doll and Setsuko hands Eva a letter delivered three years earlier as they were being ousted. It was from Germany: Eva's parents were murdered on their own doorstep by the Nazis.

> Vocally and dramatically they bear much of the opera's emotional weight and there was a dignity suffused with quiet pain in the manner in which the singer-actors carried it.

_An American Dream_ is an opera that hits home. Part of its poignancy lies in how it forces us to grapple with the more uncomfortable aspects of the notion of "home:" its pliability, fragility, and ephemerality. At various moments in the piece, both the Kobayashis and the Crowleys repeat the line, "They said America would be a good place for us."

For several members of this production's cast and leadership, the show's gnarled realities shaped their personal ancestries. For mezzo-soprano [Nina Yoshida Nelsen](/scene/people/nina-yoshida-nelsen/), who created the role of the mother, performing Hiroko allows her a way to commune with her great-grandmother and grandmother, both of whom were placed in detention centers. In the program book, director Matthew Ozawa discusses how his family was forcibly relocated to a camp in Wyoming, "a prison patrolled by armed guards and surrounded by barbed wire fences," and where his father was born.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553015272/media/2019/03/CatherineMartin_ChristopherMagiera_ANAMERICANDREAM_LyricOperaofChicago_LYR190314_178.jpg){{% /md %}}

<figcaption>Catherine Martin and Christopher Magiera in An American Dream, Lyric Opera of Chicago/Lyric Unlimited, 2019.</figcaption>

</figure>

As a whole, the cast of this production delivered heartfelt and gripping performances. Yoshida Nelsen, together with bass-baritone Ao Li as Makoto Kobayashi, were particular standouts. Vocally and dramatically they bear much of the opera's emotional weight and there was a dignity suffused with quiet pain in the manner in which the singer-actors carried it. Both Yoshida Nelsen and Li possess vibrant instruments that are backed by intelligence and sensitivity for dramatic inflection.

> Some of the most touching moments were those between Martin and Park, especially Eva's empathy for a fellow immigrant of a persecuted minority.

As Setsuko Kobayashi, we heard soprano [So Young Park](/scene/people/so-young-park/). In this opera, Setsuko traverses the most complete character arch. From a carefree child, to an imprisoned caretaker for her ailing mother, to a poised adult representative of her family in her confrontation of Jim—Park navigated the look and sound of her evolving role with stunning aplomb and conviction. Her voice has the clarity and agility one would expect of someone who is making her name these days as the Queen of the Night and Gilda. Setsuko's most outwardly powerful moment comes at the opera's conclusion and though Park certainly held her own against baritone [Christopher Magiera](/scene/people/christopher-magiera/) and mezzo-soprano [Catherine Martin](/scene/people/catherine-martin/) (as Jim and Eva Crowley), it was in the soft, transient moments of intimacy where Park really shined.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553015284/media/2019/03/SoYoungPark_ANAMERICANDREAM_LyricOperaofChicago_LYR190314_108.jpg){{% /md %}}

<figcaption>So Young Park in An American Dream, Lyric Opera of Chicago/Lyric Unlimited, 2019.</figcaption>

</figure>

Catherine Martin was superb as the cautiously hopeful, but deeply anxious Eva. Rich and sonorous, her voice easily cut through the mellowing acoustics of the Harris Theater. This opera is driven primarily by the women and the trio of Martin, Park and Yoshida Nelson comprised a first-rate ensemble. Some of the most touching moments were those between Martin and Park, especially Eva's empathy for a fellow immigrant of a persecuted minority. Jim Crowley, a hardened war veteran, is the least fleshed out character. Though we get a glimpse into his background and psyche at the very end of the piece, for the most part, he is meant to represent an archetypical mid-century American man: prideful, repressed, looking out for number one. Christopher Magiera deserves applause for bringing some depth to his character, but, in his disdain and indifference toward the "other," he succeeded most brilliantly in being unlikable.

> There's much food for thought in this piece.

Jack Perla's score for this opera is understated, efficiently paced, and quite traditional in its structure of divisible solo, duo, and ensemble numbers. A tonally based minimalism pervades this piece with crushing dissonances at crucial dramatic moments as well as subtle pentatonics for moments of nostalgia and loss. Conductor Daniela Candillari leads the chamber ensemble with effortless elegance, nuance, and shape. Candillari conducted last season's _Fellow Travelers_ and it was wonderful to see her back in Chicago in repertoire upon which she is leaving a decisive stamp.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1553015298/media/2019/03/SoYoungPark_NinaYoshidaNelsen_AoLi_ANAMERICANDREAM_LyricOperaofChicago_LYR190314_213.jpg){{% /md %}}

<figcaption>So Young Park, Nina Yoshida Nelsen, and Ao Li in An American Dream, Lyric Opera of Chicago/Lyric Unlimited, 2019.</figcaption>

</figure>

In its lean 70-minute runtime, _An American Dream_ packs a punch. And it could not have come at a more timely hour. We've heard over the past half-century the words, "never again" or "never here." But the visuals in _An American Dream_ and the emotions it stirs feel eerily familiar and alarmingly close to home. There's much food for thought in this piece.