+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2018-12-02T12:33:00-05:00"
lastmod = "2018-12-02T12:46:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771863736/sq0006Gaa%CC%82lleArquezasCarmenROH.jpg.jpg"
primary_image_credit = "Gaëlle Arquez in the title role of Carmen, Royal Opera House, 2018. Photo: Bill Cooper."
publishDate = "2018-12-02T12:46:00-05:00"
related_articles = ["articles/androgyny-is-sexy-carmen-at-roh.md","articles/in-review-carmen-at-nashville-opera.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/brian-jagde.md","scene/people/gaelle-arquez.md"]
short_description = "We open to a massive set of stairs as wide as the stage. Perched atop is a lone figure in garishly flamboyant toreador garb. This is our narrator and we understand her to be Carmen, or at least, a version of her. She is an omniscient and timeless figure, as if speaking to us from beyond the grave to tell her story."
slug = "an-absolute-triumph-koskys-carmen"
title = "An absolute triumph: Kosky&#039;s Carmen"
+++

It's rare to come to a performance where the energy in the space feels palpable even before it begins. Perhaps it was my own excitement about seeing this first revival of the now infamous [Barrie Kosky production](http://www.roh.org.uk/people/eleonora-buratto) that saw its UK premiere at the Royal Opera last season, but there seemed to be a definite hum in the air. It was utterly electric. It was out with the old and in with the new. This was not to be the version of *Carmen* that everyone knows.
	
We open to a massive set of stairs as wide as the stage. Perched atop is a lone figure in garishly flamboyant toreador garb. This is our narrator and we understand her to be Carmen, or at least, a version of her. She is an omniscient and timeless figure, as if speaking to us from beyond the grave to tell her story. The choice to cut the recitative and replace it with a new text (including some from the original Mérimée novella that inspired the opera) was an effective one. It allowed the story to be told through a different lens, one that exaggerated this overarching sense of impending tragedy that is so present in the music. The narrated, voice over text, performed by a sultry female voice, let us in on the characters inner thoughts and feelings from the perspective of an outside observer. Because the recitative was missing, it began to feel a bit like a hit-parade as we rolled through the first act, familiar piece after familiar piece. But there was also something unidentifiable and new in the way it was reimagined. In a way, it felt as though I was watching a completely new opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771493051/0182CarmenProductionimageROH.jpg.jpg)
<figcaption>A production image of *Carmen*, ROH, 2018. Photo: Bill Cooper.</figcaption>
</figure>

A satisfyingly spartan production, the focus became the choreography and storytelling through the language of the body. There was an ambiguity of space and time in which beautiful character vignettes were created, giving the production an eternal sense as though it had always been and always would be. The choreography was thrilling. I was enamoured with the energy, charm, and humour it imbued into the piece. I felt as though I was watching a performance by a clowning theatre troupe. There is something so intuitive about the use of dance in opera. It used to be the traditional way opera was performed and it translates so well to the operatic stage I have to wonder why we ever moved away from it. It interpreted every emotion into a physical language that reflected the music flawlessly. 

The staging also made great use of the chorus who became almost like central characters in the story. It was a great example of the beautifully powerful images that can be created with a large number of bodies on stage. Every aspect of this production was carefully crafted and delightfully surprising including Joachim Klein's lighting design which was bold, a little strange, and extremely theatrical.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771508480/0867CarmenproductionimageROH.jpg.jpg)
<figcaption>A production image of *Carmen*, ROH, 2018. Photo: Bill Cooper.</figcaption>
</figure> 

French mezzo soprano [Gaëlle Arquez](/scene/people/gaelle-arquez/) bravely took on the title role in place of an ailing Kesenia Dudnikov, although this is now old hat for Arquez who made her Royal Opera debut in last season's production of *Carmen* and also performed the role in Frankfurt in 2017. This is a character she knows well and has fully embodied, that much was clear. Every move she made with her body was calculated, every gesture had reason, every look had a meaning. She was completely engaging. Her voice was a clean and smooth mezzo colour with incredible versatility in the lower part of her range, making her perfectly suited to the role.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771657540/0094Gaa%CC%82lleArquezasCarmenROH.jpg.jpg)
<figcaption>Gaëlle Arquez as Carmen in *Carmen*, ROH, 2018. Photo: Bill Cooper.</figcaption>
</figure>

Bass Alexander Vinogradov was slightly miss-cast as Escamillo for my taste. I would have preferred a noble baritone colour but he nevertheless sang the role with easy confidence though his tone was so rich it lacked definition and bordered on monosyllabic. But he nailed Escamillo's key character trait, which is that he is unabashedly aware of his own celebrity and happy to bask in it. It is the appeal of this celebrity that first captures Carmen, and without it, the story doesn't work. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771673283/0145EleonoraBurratoasMicaa%CC%82laROH.jpg.jpg)
<figcaption>Eleanora Buratto in *Carmen*, ROH, 2018. Photo: Bill Cooper.</figcaption>
</figure>

Italian soprano Eleanora Buratto made a brave effort in her Royal Opera debut as Micaëla. It was a beautiful sound but felt laboured. Unsettlingly, I could sense how hard she was working and could feel her uncertainty. She was, however a charming Micaëla, seemingly able to capture her essence with ease. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771679909/1064BrianJadgeasDonJosC%CC%A7ROH.jpg.jpg)
<figcaption>Brian Jagde as Don José in *Carmen*, ROH, 2018. Photo: Bill Cooper.</figcaption>
</figure>

American tenor [Brian Jagde](/talking-with-singers-brian-jagde/) was a slightly lacklustre Don José. But then again, Don José is kind of a lacklustre character, his weakness makes me so woefully unloveable. But it was in the moments of extreme rage and passion that Jagde really shone, using the power of his sound effectively making it clear just how startlingly on the edge José is.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543771686880/0501AigulAkhmetshinaasMercC%CC%A7da%CC%88sandHaegeeLeeasFrasquitaROH.jpg.jpg)
<figcaption>Aigul Akhmetshina as Mercédès and Haegee in *Carmen*, ROH, 2018. Photo: Bill Cooper.</figcaption>
</figure>

As a reviewer, I see a lot of opera, some of it good, but quite a lot of it that feels the same. Kosky's production is an absolute triumph and a rare treat to be able to be genuinely surprised, and entertained in the most unexpected and thought provoking ways. It proved to me that as we continue to talk about the need to reimagine opera for the 21st century, that there are infinitely inventive ways of doing it that not only respect the heart of the story but give it profound meaning.
