+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-08-22T10:02:00+01:00"
lastmod = "2016-08-23T09:22:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1471863555435/2016-09-22---Amy-Winehouse.jpg.jpg"
publishDate = "2016-08-23T09:22:00+01:00"
short_description = "What struck us about her story is the apparently objective frenzy that audiences have over the human voice. Singers of all genres are made to understand early on that their voice is only part of a puzzle (albeit a vital part); they need self-discipline, they need to hustle and make business contacts, they need to want their career to happen, and to make their career happen."
slug = "amy-winehouse-the-power-of-an-audience"
title = "Amy Winehouse &amp; the power of an audience"
+++

If you've not yet seen [*Amy*](http://www.imdb.com/title/tt2870648/), the 2015 documentary about the life and career of Amy Winehouse, put it on your short-list.

The Oscar-winning documentary by Asif Kapadia is compelling, compiled of footage of Winehouse onstage, previously unseen home videos from her teenage years and early career, and conversations with her friends and family. Even casual fans of Winehouse knew her for both a soulful voice and a compulsive, addictive personality; Kapadia puts all of the pieces of her life into a linear context of sorts, and though the end of *Amy*'s story isn't surprising, it's sad, and frustrating.

Like with any non-fiction work that gets us emotionally invested, *Amy* could very well be fraught with bias. In fact, Winehouse's family has [fought back](https://www.theguardian.com/music/2015/apr/27/amy-winehouse-documentary-family-cannes-film-festival) against Kapadia, saying he painted a negative picture of them, including "specific allegations made against family and management that are unfounded and unbalanced."

Even if Kapadia did make a point of villainizing the people around her, two things were crystal clear: Amy Winehouse had real love for jazz and soul music, and she got more famous than she ever wanted to or anticipated.

Winehouse may have seemed an oddity in the world of Grammy Award-winning artists and megastars; she was shy to relish in fame and praise, and whenever she sang a big show on a big stage, there seemed a very human moment of insecurity, as though she wasn't sure what to do with the audience's attention after she had finished a song.

You may ask, *why did she want to be a singer if she didn't like fame?* Frankly, hardly any singers become "famous", especially those more steeped in jazz and soul genres like Winehouse. The stuff that made her an excellent artist - pure love for the music, and the only chased goal being the chance to make more music - actually made her less fit to be a superstar. It seems, that if it had been up to Winehouse alone, she would have been just fine with all of that.

What struck us about her story is the apparently objective frenzy that audiences have over the human voice. Singers of all genres are made to understand early on that their voice is only part of a puzzle (albeit a vital part); they need self-discipline, they need to hustle and make business contacts, they need to want their career to happen, and to *make* their career happen.

So, it's an extraordinary thing for a singer to become a household name, almost without a conscious effort to do so. Sure, Winehouse put in the work; she wrote songs, recorded them, made public appearances for her albums, gave shows at huge venues. 

Yet in the 21st century, it's a fair expectation that the work Amy Winehouse did could easily have been overshadowed by artists like Lady Gaga, Beyoncé, and Katy Perry. Their performances were *big*, suitable for stadiums filled with thousands of people. 

Aren't "young people these days" supposed to be immune to the magic of a simple voice? Aren't audiences all yearning for backup dancers and pyrotechnics to go with their favourite songs?

And yet, Winehouse stayed old-school. Inspired by folks like Sarah Vaughan and Billie Holiday, she wrote songs that were heartfelt and more than a little autobiographical; best of all, she simply stood there and sang them. 

And people went insane for it. They loved her voice - a well-timed appearance of a "real" voice in the midst of so much over-produced auto-tune - and they loved her demons; accidentally, it seems, Amy Winehouse had created a persona, a two-faced person of intrigue who was perceived to be a master of music, and a disaster of life.

Isn't it a powerful thing, the human voice? In Winehouse's case, her voice compelled millions of people not only to listen to her music, but for media channels to talk about her and photographers to follow her with a blinding deluge of camera flashes and inane questions. On the one hand, there's an understood factor to being a really successful singer, and that's having your privacy disappear; but on the other hand, on the side of general human decency, there's nothing about a singer's talent that entitles the media to infect their lives offstage.

Despite the demons of addiction, eating disorders, and ill-directed fame, Winehouse offered contemporary proof that the human voice is a phenomenon that doesn't fade. It doesn't get replaced by impressive dancing and memorable costumes, if the singing is honest and the voice holds some mysteries. 

Amy Winehouse got the career that so many singers want; what's almost more interesting is the fact that she represented a huge portion of performers who love the work more than the applause.
