+++
author = ["authors/greg.md"]
categories = "Review"
date = 2022-03-23T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1648045042/media/2022/03/sqAmplified1_xcur8i.jpg"
primary_image_credit = "Aria Umezawa and Teiya Kasahara, two co-founders of Amplified Opera. Photo: Dahlia Katz."
related_articles = ["articles/inaugural-watershed-festival-to-celebrate-opera-and-musical-theatre-in-kingston.md", "articles/good-ideas-rehearsalasperformance.md", "articles/aria-umezawa-opera-5s-die-fledermaus-with-surprises.md"]
related_companies = ["scene/companies/amplified-opera.md"]
related_people = ["scene/people/megan-miceli.md", "scene/people/marion-newman.md", "scene/people/aria-umezawa.md", "scene/people/teiya-kasahara.md"]
short_description = "It's been quite the long-haul here in the GTA, but it's great to be back on the beat. After two years out of the habit, it was great to find myself at the Museum of Contemporary Art to check out Amplified Opera's first offering in their concert series — after several delays — AMPLIFY 1.0."
slug = "review-re-telling-stories-with-amplify-1-0"
title = "Review: Re-telling stories with Amplify 1.0"
youtube_url = ""

+++
Hello, Schmop-Tops!

Did ya miss me? I missed you.

It's been quite the long-haul here in the GTA, but it's great to be back on the beat. After two years out of the habit, it was great to find myself at the Museum of Contemporary Art to check out [Amplified Opera](/scene/companies/amplified-opera/)'s first offering in their concert series — after several delays — _AMPLIFY 1.0_.

The newest company-in-residence with the [Canadian Opera Company](/scene/companies/canadian-opera-company/), Amplified Opera, co-founded by [Aria Umezawa](/scene/people/aria-umezawa/), [Teiya Kasahara](/scene/people/teiya-kasahara/), [Asitha Tennekoon](/scene/people/asitha-tennekoon/), and [Marion Newman](/scene/people/marion-newman/), has partnered with MOCA to present this series surrounded by the immersive exhibit, _I AM YOUR RELATIVE_ by Jeffrey Gibson — a vivid, explosion of colours, texts, and images all collected from his past decade of work prioritizing the voices of Indigenous, Black, Brown, and queer voices. The piece is intended to be used by MOCA to host a variety of interdisciplinary presentations.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1648045123/media/2022/03/Amplified1_JonathonTopher_ifg6q2.jpg){{% /md %}}

<figcaption>Jonathan Christopher and Topher Mokrzewski in MisogyME, Amplify 1.0, Amplified Opera, 2022. Photo: Dahlia Katz.</figcaption>

</figure>

The scene was a clever juxtaposition for this concert series, which featured artists whose voices Gibson's work has been, well, amplifying. _AMPLIFY 1.0_ was three concerts performed in repertory and paired differently each night:

The first in the series for me was _MisogyME_, a piece examining a man's role and experiences with Toxic Masculinity. Performed by baritone Jonathan Christopher, pianist Topher Mokrzewski, and director Michael Mohammed, the programme was an interesting mix of musical theatre, opera, and performance art.

Featuring pieces from _Le nozze di Figaro_ to _Hamilton_ and almost everything in between, the pieces were well-sung overall by Christopher, but it was clear that he felt more at home in the musical theatre genre. During Coalhouse's Soliloquy one could hear the influence of late 90s/early 00s Broadway baritenors like Brian Stoke Mitchell and Norbert Leo Butz. Mokrzewski managed the shifts between the varied genres with incredible skill.

The through-line of the piece did get a little disjointed as Mohammed led some of the curations. The points of interjection that consisted mainly of a single quote were more effective, but the longer and more informative they became, the more it drew away from the flow of the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1648045168/media/2022/03/Amplified1_Panel_jyhfuh.jpg){{% /md %}}

<figcaption>Topher Mokrzewski, Jonathan Christopher, and Michael Mohammed is discussion for MisogyME, Amplifiy 1.0, Amplified Opera, 2022. Photo: Dahlia Katz.</figcaption>

</figure>

The show also featured a short panel conversation between the three of them. I felt this also disrupted the flow because it also featured a moment for the audience to break into small groups and ask each other questions prompted by a quote by Caitlin Moran. While this is great for a seminar or lecture situation, it felt a bit out of place, especially considering it took place two-thirds of the way through the programme and not at the end.

I also found the narrative of the show focused more on men and toxic masculinity — which is a very important discussion to have — and less about actual misogyny, as the title seemed to imply. There were examples of Mozart Men, who are known to audiences as problematic, but I felt that the examples chosen — while they worked well together musically — maybe didn't further the thesis the way they wanted it to. Another example was using Sweeney Todd's "Epiphany" to talk about toxic masculinity/misogyny when Judge Turpin's "Johanna (Mea Culpa)" was right there.

Overall, the show was effective and brought up many important questions that we don't quite have the answers to yet, but need to continue to be discussed in order to get there.

Second up was _WRECKONCILIATION_, featuring Cree-Metis baritone Jonathon Adams and Kwagiulth and Sto:lo First Nations mezzo Marion Newman-Nege'ga, with violinist Kathleen Kajiokav, cellist Keiran Campbell, and harpsichordist Chirstopher Bagan performing the works of Henry Purcell alongside a piece composed by Newman-Nege'ga.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1648046268/media/2022/03/Amplified1_MarionJon_i6expm.jpg){{% /md %}}

<figcaption>Marion Newman-Nege'ga and Jonathon Adams in WRECKONCILIATION, Amplify 1.0, Amplified Opera, 2022. Photo: Dahlia Katz.</figcaption>

</figure>

The idea behind this show was that during the time Purcell was composing this music, the Beaver Wars were taking place on this side of the Atlantic. These pieces were chosen because of their historical chronology, but also because Purcell was known to write about nature and the environment around him. Occupying this music as indigenous/First Nations artists, Adams and Nege'ga sang them using texts reimagined through an Indigenous lens by writer Yvette Nolan.

Adams sang with an elegant, delicate line and with exquisite ornamentation. Newman-Nege'ga sang with her characteristic richness while bringing out a brilliance over the top of her register. Interspersed among the Purcell were vignettes guiding us through the journey that brought us to where we are today and what we must do to reach reconciliation before we wreck everything completely. The penultimate piece was Newman-Nege'ga's _KINANU_, sung in her native tongue while accompanying herself on her drum. The chants echoed off the walls of the museum while being echoed in the images of Gibson's work itself.

Rounding out the programme was _SPOTLIGHT: Out on a Limb_, featuring soprano Megan Miceli, pianist and trumpeter Jennifer Pols, and director Bridget Ramzy. Now, this was quite the unique programme. _SPOTLIGHT_ was a discussion centered around disability and the differently-abled. Both performers, Miceli and Pols, are missing one of their hands.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1648046323/media/2022/03/Amplified1_Megan_bxuzlp.jpg){{% /md %}}

<figcaption>Megan Miceli and pianist Jennifer Pols in SPOTLIGHT: Out on a Limb, Amplify 1.0, Amplified Opera, 2022. Photo: Dahlia Katz.</figcaption>

</figure>

Miceli opened with some powerful Handel that rang out high above the unfortunately distracting daily business of MOCA itself. I found Miceli to be warm and inviting. Her anecdotes were charming, funny, sincere and at times self-effacing which made her all the more endearing.

Pols followed up with some Mozart that had been rearranged to accommodate her missing left-hand. In an incredibly informative interlude, Pols actually walked the audience through how she makes these musical accommodations without sacrificing the pursuit of excellence.

A high point for me was when the two paired up for some Debussy. "La plus que lente" was rearranged by Pols to include Miceli, in a soaring, virtuosic, vocalise that was at times pure Debussy magic and at times dancing with sounds more reminiscent of a Gershwin — a nice homage Pols background in Jazz from Humber College. Another great piece was _High the Veils Wave_ by Lieke van der Voort, commissioned specifically for Jennifer with her disability in mind. It employed incredible soundscapes alongside vocalisations from the pianist. It was ethereal, other-worldly, and conjured images of fog and fae.

All in all, it was a great couple of evenings out. However, if heading to an event at MOCA I would suggest attending one during the evening as opposed to a matinee. While it's great to see a venue like MOCA busy, it was quite distracting to be watching a show with a busy cafe and gift shop ringing up customers in the same room.