+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-09-10T12:08:00-04:00"
lastmod = "2017-09-12T12:02:00-04:00"
preamble = "Based in New York, [American Opera Projects](/scene/companies/american-opera-projects/) has built up a nearly 30-year history of developing new opera. Their work has resulted in over 30 world premieres, including *This is the Rill Speaking* (Hoiby/Schulgasser, 2008), [*Harriet Tubman: When I Crossed That Line to Freedom*](http://www.aopopera.org/tubman/) (Nkeiru Okoye, Irondale Center, 2014), and [*As One*](http://www.aopopera.org/AsOne/#) (Kaminsky/Cambell/Reed, BAM, 2014).\n\nAOP also offers the chance for composers and librettists to put their works-in-progress on their feet with the help of a cast of singers and a live audience, in their First Chance Development Workshops. This fall sees five such workshop productions, of [*Six. Twenty. Outrageous*](http://www.aopopera.org/events.html#620firstchance2017) (Davis/Frank/Fitch) September 18, [*The Echo Drift*](http://www.aopopera.org/events.html#EchoDriftScandinaviaHouse2017) (Karlsson/de Voss) October 5, and [*Gulliver's Travels*](http://www.aopopera.org/events.html#gulliver2017) (Bond/Greco) October 6, [*A Thousand Splendid Suns*](http://www.aopopera.org/events.html#suns2017) Nov. 18-19, and [*Wolf-In-Skins*](http://www.aopopera.org/events.html#wolfinskins2017), November 29-30.\n\nAs a librettist, [David Cote](/scene/people/david-cote/)'s operatic work is closely connected with American Opera Projects. With AOP, he has workshopped *Fade* and [*The Scarlet Ibis*](http://www.aopopera.org/scarletibis/) with composer Stefan Weisman, and [*Three Way*](/safe-words-masquerades-nashville-opera-presents-three-way/) with composer Robert Paterson. In progress with AOP are Cote's *We've Got Our Eye on You* with Nkeiru Okoye, and *American Atheist* with Weisman, based on the life and murder of atheist [Madalyn Murray O'Hair](https://en.wikipedia.org/wiki/Madalyn_Murray_O%27Hair).\n\nWe spoke with Cote about the function of an organization like American Opera Projects, and the enormous value of having a workshop environment for new opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505060919161/2017-09-10---AOP-square.jpg.jpg"
primary_image_credit = "American Opera Project's Composers & The Voice, 2013-14 session, South Oxford Space, Brooklyn. Photo: Ted Gorodetzky."
publishDate = "2017-09-12T10:15:00-04:00"
related_articles = ["articles/how-did-we-do-second-movement-presents-rough-for-opera-16.md","articles/living-up-to-its-name-experiments-in-opera.md","articles/talking-with-composers-mark-adamo.md","articles/great-operas-dont-just-happen.md"]
related_companies = ["scene/companies/american-opera-projects.md"]
short_description = "&quot;You hear the work, and you hear the audience hearing the work. That&#039;s invaluable. As a theater critic, I am by nature self-critical. As an editor, I know the work can always be better. I want to see how the audience reacts. I want to hear their thoughts afterward. You won&#039;t take every suggestion to heart, but one good note can have a huge effect on the final outcome.&quot;"
slug = "american-opera-projects-youre-seeing-the-opera-in-microcosm"
title = "American Opera Projects: &quot;You&#039;re seeing the opera in microcosm.&quot;"
+++

## How has American Opera Projects played a role in your professional career?

If it weren't for AOP I wouldn't be writing opera. Years ago, I attended a [Composers & The Voice](http://aopopera.org/composers_voice/) event because a college friend, Stefan Weisman, was showing work. That fired my imagination about what opera could be: complex music and stylized text. I wanted to be part of it, that weird and wonderful alchemy. 

Shortly after, Stefan and I saw David Lang and Mac Wellman's *The Difficulty of Crossing a Field* at Montclair State University's Peak Performance series, and basically, I wouldn't stop bugging him to let me write a libretto or song lyric. Stefan was tight with AOP, which produced his opera *Darkling*, and they eventually became my home for new work. Nearly everything I've done so far, AOP has been involved on some level: libretto reading, co-producing, or presenting work in concert. That includes *Fade* (2008) and *The Scarlet Ibis* (2015) with Stefan; and *Three Way* (2017) with Robert Paterson and *We've Got Our Eye on You* (in progress) with Nkeiru Okoye. Like I said: They are my opera home.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505060953242/2017-09-10---Cote-Paterson.jpg.jpg)
<figcaption>David Cote (left) and composer Robert Paterson at the opening night party of *Three Way*, BAM Fisher, Brooklyn, NY. Photo via [AOP](https://www.flickr.com/photos/americanoperaprojects/sets/72157682345991542/with/35489851115/).</figcaption>
</figure>

## What do you think the average opera fan may not know about the process of developing new works?

In my experience, companies that develop new work can be cliquey — if you're not part of the club or the "brand," you don't matter. Or else they're limited by one person's taste, and if that person's taste stinks, heaven help you. AOP is a lot savvier and more adventurous. The sheer diversity of the works they're developing reflects the diversity in new American opera. I mean, you have avant-garde experiments (*The Echo Drift*), historical drama (*The Leopard*), folklore (*Br'er Rabbit*), the whole gamut. I think that's because Charles [Jarden, General Director] and Matt [Gray, Producing Director] are simply smarter about theater and storytelling. They're interested in what makes good music drama, not how to chase a trend.

They also know that when it comes to new opera, there are no rules. There's no one way to write a great libretto, or translate a libretto into effective musical drama. So the composer, librettist and producer need to proceed very carefully and methodically, to answer the fundamental questions: What story are we trying to tell? Does it sing? Is it dramatic? [Composers & The Voice](http://aopopera.org/composers_voice/) is probably the country's best training program for new composers and librettists. It lets them make mistakes in the rehearsal room, which can be wonderfully liberating.

Opera fans might not know that developing new work is a slow process. It should involve libretto readings before a single note has been written, workshops, audience feedback, and more workshops. Opera is such a complex and expensive endeavor, it doesn't have the same margin of failure that commercial musical-theater enjoys. Your average Broadway-style musical has three or four weeks of previews that allow for rewrites, cuts, new material and re-staging. Once, I saw Tony Kushner interview Stephen Sondheim. Kushner asked Sondheim why he never wrote opera. Sondheim's answer: "Previews. In opera, you only get one."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505060789877/Coteportrait.jpg.jpg)
<figcaption>David Cote, librettist (*Three Way*, *Fade*, *The Scarlet Ibis*). Photo by Jenny Woodward.</figcaption>
</figure>

Opera also hangs on to a rather antique notion that the artists are infallible. When you get librettists who think their first draft is poetic genius, or composers who think their score is hewn in stone, it's a recipe for mediocrity. Which is ironic, really. Composers and librettists who have been elevated to a sort of 19th-century godlike status won't do the hard dramaturgical work to turn a flawed, uneven score into a great one. That's why so many operas have their much-hyped world premiere, get mixed reviews and lukewarm audience response, then sink from view. Which is depressing. So, I think opera can learn a lot from Broadway.

It's a numbers thing. The odds against seeing good new opera are too great. Why? Because it's so damn expensive. Each year, hundreds of new plays premiere across the country. Let's say a dozen are legitimately good or great. Dozens of new musicals premiere. Maybe five are wonderful. Every 15 or 20 years you get a *Hamilton*. But there are so few new American operas premiered each year, the odds are that much greater you'll see something mediocre or even bad. That's why I love that AOP develops so many projects; they're helping to increase the pool of good new opera.

## What does an opera creator like yourself get out of a workshop performance with an audience?

You hear the work, and you hear the audience hearing the work. That's invaluable. As a theater critic, I am by nature self-critical. As an editor, I know the work can always be better. I want to see how the audience reacts. I want to hear their thoughts afterward. You won't take every suggestion to heart, but one good note can have a huge effect on the final outcome. I've done workshops that led me to cut pages of libretti, to let the music do the driving. Or you realize a hole exists in this scene, but you can plug it with a line or two. And if you’re writing comic opera, as I’ve done, you need live bodies in the room to see if they're physically responding to the jokes.

## What do you think listeners can uniquely take away from a workshop performance?

Oh, that's hard. I could be cynical and say: All opera looks and sounds like crap in workshops. The piano-vocal is too sketchy and puny, or there's no staging to make sense of the relationships. But I think if you're genuinely interested in new opera, you can see past the roughness and enjoy the process. It's like you get to see the skeleton before flesh and organs go in, before the skin is rolled over and body is clothed. You're seeing the opera in microcosm. Opening nights are glamourous and fun, but being in the room with your collaborators and a great producer like AOP, making minute, crucial adjustments, that's thrilling.
