+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2020-10-19T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Stephen Powell's _American Composers At Play_ is [available for purchase](https://stephenpowell.us/recordings) via his website."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1602785547/media/2020/10/sqPowellAlbum_fxdad5.jpg"
primary_image_credit = ""
related_articles = ["articles/recording-dame-smyth-pretty-good-for-a-woman.md", "articles/american-opera-projects-youre-seeing-the-opera-in-microcosm.md", "articles/orlando-gender-bending-and-the-sound-of-androgyny-in-vienna.md"]
related_companies = []
related_people = ["scene/people/stephen-powell.md"]
short_description = "Wrapping his selection of American art songs with works from poets who are celebrated and time-honored masters may partially explain why Powell has arranged the songs somewhat thematically rather than by composer. Whatever his rationale, \"Billy in the Darbies\" remains the soul of this undertaking."
slug = "american-composers-play-for-stephen-powell"
title = "American composers \"Play\" for Stephen Powell"
youtube_url = ""

+++
[Stephen Powell](/scene/people/stephen-powell/) is a hearty baritone entering his fourth decade as an opera singer. His first solo recording boasts the participation of four illustrious American composers - John Musto, William Bolcom, Lori Laitman, and Ricky Ian Gordon - all of whom provide piano accompaniment as well as their songs. As Powell puts it in his effusive notes to [_American Composers At Play_](https://stephenpowell.us/recordings), "For decades I've wanted to perform the work of living composers with the composers themselves playing their compositions...these four giants have liberated my American voice."

Good for them. But in return they require keen interpretation, something quite removed from Powell's perfectly burnished tone and polished technique. There are many moments of fine singing, indeed one that feels genuinely definitive on this recording. Others simply set on the ear. They are not without energy or commitment, but lack a distinct voice, American or otherwise. We expect more connection from the close collaboration for which Powell expresses much gratitude.

The first disconnect appears early with John Musto's sharply crafted songs set to three of Dorothy Parker's short poems. Parker, that acerbic observer, writer and mainstay at the fabled Algonquin Roundtable, packs a punch in the blink of an eye, or more specifically a sardonic wink. The songs are too fleeting for Powell to find their requisite tone. 

The cynical "Social Notes", and especially "Résumé", Parker's ode to suicide, require world-weary drollness. Powell's reading is good-natured humor rather than stinging observation. He fares better with the unusual, at least by Parker's standards, "The Sea", a melancholy seascape, more wistful than ironic, into which he settles comfortably with beautifully rounded tones. Musto plays his deft tunes as if they were standards for the cognoscenti.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1602785895/media/2020/10/StephenPowell-SueReno_gdcnqh.jpg){{% /md %}}

<figcaption>Stephen Powell, baritone. Photo by Sue Reno.</figcaption>

</figure>

The composer's lovely set of six songs for baritone and guitar from poems by James Laughlin, grouped under the heading "The Brief Light" are hit and miss. In "The Dancer" Powell lacks passion for which the song fairly begs. A flamenco-based affair of obsessive longing, it is only pallid recollection without it. What a pleasant surprise then to hear "Song," another expression of longing, this time spurred by a fleeting glance and "Voices," quite the internalized romantic war, embellished with lustrous shading and subtle emotional variation. The acclaimed guitarist Jason Vieaux embraces the set.

> The song is tragic, not in an epic or political way but in a deeply personal sense that weighs heavily on the psyche.

William Bolcom and Powell coalesce with considerable charm on three of Bolcom's brief and remarkably different songs, all with texts by Arnold Weinstein. Powell notes that after having asked Bolcom many questions about his songs, the composer replied "Do what I wrote! I took the time to make the notations, so just do what I wrote." Bolcom's directness and Powell's willingness to comply are commendable.

"Waiting" is a mournful refrain in which Powell captures the hopeful spirit of the downtrodden. In "Can't Sleep", Bolcom sets Weinstein's dream-induced murmurs in a rolling romantic rhythm to which Powell responds with nuanced shading and lovely control. "Satisfaction" is a wise and witty lesson that benefits from the baritone's crisp delivery. The songs sparkle like small gems as Powell calibrates his voice to their scale with taste and intelligence.

Powell's renditions of Bolcom's more extended works are equally splendid. "Song of Black Max", again with text by Weinstein, is pure theater, firmly planted in the Weimar era. Powell gives mysterious voice to Bolcom's lurid world and sings the story of this decadent character in a sinister tone. In that vein "Lady Death", with text by A.D. Winans, proves that Powell can channel the dark side when he wants to.

> The song has a cadence but it never slithers.

"Billy in the Darbies", in which Powell is joined by the fine Attacca Quartet, is the harrowing centerpiece of this recording project. Bolcom's setting of Herman Melville's poem about the fate of Billy Budd, the doomed sailor in handcuffs (darbies) as he awaits his fate, is by turns resigned, oddly humorous and in its descriptions of the subterranean, strangely beautiful. Rendered with understated pathos, Powell is at once the center of great tragedy but also its observer. There are few moments in opera, much less in art song, where reflection and observation carry such power. The song is tragic, not in an epic or political way but in a deeply personal sense that weighs heavily on the psyche. It is hard to imagine another singer surpassing the acuity on which Powell turns or accompaniment as haunting and refined as that provided by the Attacca Quartet. This writer would co-opt the sunny positioning of _American Composers At Play_ and call the project _Billy In the Darbies and other songs_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1602785925/media/2020/10/PowellAlbum-composercollage_fwksay.jpg){{% /md %}}

<figcaption>The composers of Stephen Powell's new album, American Composers At Play. Clockwise from top left: Ricky Ian Gordon, Lori Laitman, John Musto, and William Bolcom.</figcaption>

</figure>

The language of Thomas Lux's unassuming poetry clings nicely to Lori Laitman's clipped compositions. Powell thoughtfully finds the tones to balance the everyday observations with their philosophical implications. He might have supplied "Snake Lake" with a bit more than the occasional hiss to fully render its reptilian content. The song has a cadence but it never slithers. In contrast "Refrigerator, 1957" benefits from Powell's moody inventory of its contents that suggest far more than a boiled potato and a chicken carcass. "A Small Tin Parrot Pin" with rapid-fire delivery dictated by the sound of the words, appears to make light of its humanist leanings but Powell imbues it with an insightful warmth. The title poem of this group, "Men With Small Heads" speaks valiantly for those with challenged visual perspective. Powell creates interesting linguistic effects but his booming baritone overlooks a child's point of view.

> Powell's careful nurturing of the song's growing intensity is complemented by the composer's tremulous piano work.

Ricky Ian Gordon is a veteran of the singer-composer collaborative process, having worked, along with Jake Heggie, Glen Roven and Lowell Liebermann, with bass-baritone [Daniel Okulitch](/scene/people/daniel-okulitch/) on his 2013 recording of American art songs. Powell and Okulitch cross paths on "Bus Stop", Gordon's turbulent setting of Donald Justice's enigmatic poem. Powell's careful nurturing of the song's growing intensity is complemented by the composer's tremulous piano work. The ambiguity of the poem leads to existential irony. Powell's interpretation is a subtle triumph.

There are so many ways to approach Gordon's work. This prolific composer and sometimes lyricist maintains the refined posture of opera and smartly dips into the grab bag of emotions and styles feeding popular song. In addition to "Bus Stop" Powell has wisely selected songs that suit his inclination as well as his voice. "A Horse With Wings", a celebratory yet reflective song, would communicate well in a less exalted range but Powell maintains full baritone mode while cloaking his voice in a welcome softness and breathiness. He makes "I wanna..." for "I want to..." sound natural without the tell-tale condescension that such colloquialisms often reveal. Powell brings the very modern and complex character in this song to life.

> Whatever his rationale, "Billy in the Darbies" remains the soul of this undertaking.

One of the marvels of Gordon’s talent is how he combines so much theatrical energy into songs of death and regret. "The Good Death", with text by Mark Campbell from the Civil War song cycle, _Rappahannock County_, is penetrating and painful. The reccurring word "mean", punched the first time it is uttered and prolonged the second, centers the story of a dying solider who missed the noble "good" death on the battle field, to die instead with a burning fever in a typhoid tent. Powell tells the story with dispiriting poignance accompanied by expressive piano work by Gordon and violinist Amy Schroeder. "Father's Song", from _Sycamore Trees_, for which he wrote both music and lyrics, is the regretful recollection of a father mourning the death of his daughter from an overdose. The sentiment feels specific to the moment but reaches far beyond showing that regret knows no bounds. Nor it seems does Powell's empathy for the figure he creates with such depth.

[_American Composers At Play_](https://stephenpowell.us/recordings) contains 29 songs. Within the first four minutes Gordon's setting of Edna St. Vincent Millay’s "Souvenir" appears. Near the end of the recording John Musto's "Nothing Gold Can Stay" and "The Rose Family", from two poems by Robert Frost are followed by "If", part of Laitman’s _Four Emily Dickinson Songs_. Wrapping his selection of American art songs with works from poets who are celebrated and time-honored masters may partially explain why Powell has arranged the songs somewhat thematically rather than by composer. Whatever his rationale, "Billy in the Darbies" remains the soul of this undertaking.