+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2018-03-06T16:29:00-05:00"
lastmod = "2018-03-06T16:29:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520371471413/sq---Alcina_728_C.jpg.jpg"
primary_image_credit = "Alcina, American Baroque Opera Co., 2018. Photo: Karen Almond."
publishDate = "2018-03-06T16:29:00-05:00"
related_articles = ["articles/he-saidshe-said-alcina-at-opera-atelier.md"]
related_companies = ["scene/companies/american-baroque-opera-co.md"]
short_description = "Alcina is definitely a musician&#039;s opera: one goes to it not so much for the story, but for what Handel has entrusted his virtuoso cast to contribute to the plot through great lyric vocalism and expansive lines, with coloratura used quite sparingly, which renders this a difficult piece to make interesting."
slug = "american-baroque-opera-cos-first-staged-opera-a-winner-in-alcina"
title = "American Baroque Opera Co.&#039;s first staged opera a winner in Alcina"
+++

This past weekend, the [American Baroque Opera Company](/scene/people/american-baroque-opera-co/) had its first staged operatic performance, for which its previous season concerts were a very pleasing sampler. In presenting George Frideric Handel's *Alcina* this past weekend, they demonstrated a fresh, uncluttered approach to Baroque opera that I have long awaited in this part of the country, one which trusts that all the disparate elements in the production will combine together to form a cohesive whole.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520370206522/Alcina_570_C.jpg.jpg)
<figcaption>*Alcina*, American Baroque Opera Co., 2018. Photo: Karen Almond.</figcaption>
</figure>

*Alcina* is definitely a musician's opera: one goes to it not so much for the story, but for what Handel has entrusted his virtuoso cast to contribute to the plot through great lyric vocalism and expansive lines, with coloratura used quite sparingly, which renders this a difficult piece to make interesting. The ensemble portrayed this outline as a deliberate choice on Handel's part to convey the languid atmosphere of Alcina's court; their judicious pruning of the score was just right to allow the story to feel natural, and to not let the high number of slow arias become laborious. Artistic Director Eric Smith, leading from the cello, certainly had his work cut out for him in terms of keeping this score from becoming monotonous, and his ensemble succeeded with aplomb, especially with Brad Bennight's skilled continuo accompaniment on a very supple instrument well-suited to intimate textures.

The production at the Arts Mission Oak Cliff, situated in a former Dallas church building, featured a set agreeably married to the restrictions of this venue. The set proper consisted of a painted backdrop with plenty of artfully arrayed brown columns which resembled the interior of the Drottningholm Court Theatre. At the center of this was Alcina's (Lyndi Williams Krause) crystal ball, situated beneath a seaside vista. When she would periodically retire to her crystal ball to try her hand at casting her spells, I got the sense of being at that very moment physically drawn in to her private chambers, thanks to the set's ingenious use of perspective.

Likewise, I felt that this set drew the audience in to actually listening to the music on its own terms, as there was neither need nor space for any extraneous onstage elements. Out of necessity, as there was only one exit close to the stage, the ingenious director, Rebecca Choate Beasley, used the whole space to advantage in a very immersive fashion, taking advantage of every side of the hall for the use of entrances.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520371165997/Alcina_459_C.jpg.jpg)
<figcaption>*Alcina*, American Baroque Opera Co., 2018. Photo: Karen Almond.</figcaption>
</figure>

In the title role, Krause admirably brought to the forefront the numerous shades of Alcina's enigmatic and subtly developed character. She navigated the many sides of said role with dexterity, controlling which side she would reveal next, whether tender, beguiling, enraged; in short, Krause revealed the role's sympathetic side by being completely human and vulnerable, despite her crushed illusions of power. This expressive fluency was all the more remarkable by the fact that she was a late replacement in the title role, though one would have sworn she had been in Alcina's shoes all her life: on top of smooth cantabile lines, her acting was compelling, worthy of a Phèdre.

As Ruggiero, Nicholas Garza showed himself capable of a wide variety of expression, necessary for the role to be convincing on anything other than a surface level. It evolved over the evening from a languid role to one filled with youthful, heroic vigor. By the time of "Sta nell'ircana," his big coloratura showpiece, with a pert natural horn solo by Nancy Piper, he radiated an aura of Ruggiero finally being in his true element. And yet, when the veil of illusion was first lifted from him, he still retained his capacity of speaking in agreeably anodyne courtly tones with "Mio bel tesoro," in which he must walk a thin tightrope to convince Alcina that nothing has changed at all, even when delivering his asides to the accompaniment of conspiratorial recorders.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520371177714/Alcina_582_C.jpg.jpg)
<figcaption>*Alcina*, American Baroque Opera Co., 2018. Photo: Karen Almond.</figcaption>
</figure>

In regard to Jendi Tarde's illuminating portrait of Morgana, I was always keen to know, "Whatever will she do next?" Whereas Alcina has a wand for a weapon, Morgana stuck with a classic handheld fan, with which she excelled at exuding a conniving air. In her exuberant flirtations with the disguised Bradamante (Hannah Ceniseros), she certainly had no need to be subtle. Indeed, I get the sense that Morgana's purpose in life is to seize every moment she can and make it as self-referential as possible. Her "Ama, sospira" was especially indulgent and sensuous in this regard. In her Act III aria, "Credete al mio dolore," wherein she took her sweet time in seducing Oronte (Tony Hughes) once again, and pulling him along to the dulcet tones of Handel's ductile cello solo, she clearly trusted the process and signaled her confidence in her approach by means of an agreeably final whip of the fan, the equivalent of a wink.  When one has a fan, one can clearly do anything. 

As Oronte, Hughes showed himself likewise superb at giving impulsive, knee-jerk reactions to all the uncontrollable situations going on around him. Though his coloratura could benefit from more precision, his vocal production was nevertheless very expressive, and enabled us to see that he was more than just a military man. Certainly his final aria convincingly made the case for his wanting love to be a lot more genuine and easy to navigate than he has discovered; how universal this felt indeed!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520371186224/Alcina_736_C.jpg.jpg)
<figcaption>*Alcina*, American Baroque Opera Co., 2018. Photo: Karen Almond.</figcaption>
</figure>

Hannah Ceniseros gave one of the most consistently compelling performances of the evening as Bradamante, a turbulent role which showcased her skill with coloratura, yet never obscuring her tenderness for Ruggiero. She was excellent at showing that she was ill at ease with the ways of the world, and her stance was routinely marked by lots of nervous grins and handshakes, especially while making nice talk with Morgana, who is only too eager to draw the wildest conclusions therefrom. When around other characters, Ceniseros expertly plied her skills at stalling for time by stating the obvious for as long as possible, as many an admirer of Elizabeth McCord will appreciate. 
 Her companion, Melisso (Joshua Hughes), showed himself familiar with the ways of the world, an indispensable help in helping her navigate the unfamiliar world she found herself in, and his rough and ready vocalism betrayed his familiarity with human nature without descending into farce.

As the boy Oberto, who has no real idea of how to conduct himself in Alcina's artificial surroundings, Leslie Hochman gave a skilled and engaging performance which made the most of this character. Her body gestures were very artificial, this agreeably conveying the image of a fish out of water, appropriate for a show that takes place on an island, with intense energy in her last rage aria.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520371158030/Alcina_311_C.jpg.jpg)
<figcaption>*Alcina*, American Baroque Opera Co., 2018. Photo: Karen Almond.</figcaption>
</figure>

In short, *Alcina* has compellingly proven that the American Baroque Opera Company, at the end of their first year, is quite ready to take on the Lone Star State by storm, provided the resources and capital needed to bring their ambitions to fruition. Many modern companies can definitely take a hint from this ensemble's holistic conception of the world that is opera, one that shows that tradition need not suffer from the perceived stigma of being associated with stifling routine. Rather, the [American Baroque Opera Company](/scene/people/american-baroque-opera-co/) offers an image of opera as a whole that is at once fresh and well-worn, completely unpretentious and effortlessly opulent, and which uses the subdued tones of this company's chosen repertoire to leave plenty to the imagination and let the music speak for itself, arouse discussion, and contribute to the general welfare.
