+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = 2019-11-04T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Houston Grand Opera's production of [Saul](https://www.houstongrandopera.org/saul) is onstage through November 8."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1572893414/media/2019/11/sqHGOSaul2019LynnLane-133_pd0tzv.jpg"
primary_image_credit = "Christopher Purves in the title role of Saul, Houston Grand Opera, 2019. Photo: Lynn Lane."
related_articles = ["articles/rigoletto.md", "articles/back-to-school-opera-a-practical-glossary.md", "articles/talking-with-singers-christopher-purves.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/keith-jameson.md", "scene/people/aryeh-nussbaum-cohen.md", "scene/people/christopher-purves.md", "scene/people/paul-appleby.md", "scene/people/andriana-chuchman.md"]
short_description = "The performance I saw was a microcosm of Houston at her best, a perfect example of the glorious, if not uncontroversial, results of numerous talented individuals combining their efforts to create something far bigger than the sum of its parts."
slug = "ambitious-epochal-saul-at-houston-grand-opera"
title = "Ambitious & epochal: Saul at Houston Grand Opera"
youtube_url = ""

+++
The North American premiere of Handel's masterwork [_Saul_](https://www.houstongrandopera.org/saul) took place in Houston recently to rapturous effect, under the auspices of Houston Grand Opera. I can justly say that the performance I saw was a microcosm of Houston at her best, a perfect example of the glorious, if not uncontroversial, results of numerous talented individuals combining their efforts to create something far bigger than the sum of its parts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893481/media/2019/11/HGOSaul2019LynnLane-26_vbwodv.jpg){{% /md %}}

<figcaption>Aryeh Nussbaum Cohen (David, centre) and the cast of Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

To clarify, this was a staged performance of Handel's first spectacular success in the oratorio form, which he would revive constantly whenever he needed a solid revenue stream. Accordingly, this premiere used the highly acclaimed production featured at Glyndebourne in 2015, with its many highly spectacular elements to highlight Handel's vivid use of scene-setting music, which is particularly necessary to explicate Charles Jennens's highly disjunct libretto.

Despite Handel's fluency in providing such vivid transitions to facilitate staging, it would appear that the production did not organically overlap with Handel's conception of the action: there were many awkwardly long pauses over the course of the action to allow for characters to move around and exit as needed; though I acknowledged their necessity at first, and though they well highlighted [Christopher Purves](/talking-with-singers-christopher-purves/)'s highly compelling acting ability in the title role, they quickly got old, exposing the lack of music to fill a nonexistent gap.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893530/media/2019/11/HGOSaul2019LynnLane32_nh0tu3.jpg){{% /md %}}

<figcaption>HGO dancers and HGO Chorus in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

If anyone is familiar with Opéra National de Paris's production of Rameau's _Les Boréades_ under the baton of William Christie, such a person will know what to expect. This production is certainly a British cousin of that one, complete with gargantuan feast-laden tables, highly ornate Georgian costumes and wigs, copious white makeup with black splotches, and myriad feats of athleticism from the Houston Grand Opera Chorus, who outdo even themselves here, the entire production taking place on what appears to be a surface of black, dusty pebbles.

For this chorus to maintain completely intelligible and crisp diction is a challenge at the best of times, and doubly so while in the intense choreographic feats that this production has them undertaking: to be brief, this production has raised the bar for them greatly, for they have excelled even themselves.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893554/media/2019/11/HGOSaul2019LynnLane-56_clmuvm.jpg){{% /md %}}

<figcaption>Keith Jameson (Abner) and the head of Goliath in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

Though not quite as numerous as I was led to believe, the aforementioned dance routines appeared mentally and physically strenuous on account of their sheer intensity. One definitely perceived the opening Epinicion to be a highly motivated "pep rally." The dance corps were certainly flamboyant, and in some places, quite excessively so; there was plenty of movement, without as much grace as could be hoped for, much extraneous movement of the hands being done in a manner which I found mildly distracting from the music as well as busy. I also found more than one such scene to be vertiginous, necessitating me closing my eyes from time to time to avoid motion sickness.

That all being said, even in this non-staged genre, Handel is never hindered from being theatrical. Throughout, the score has a structure which seems far more continental and cosmopolitan than anything: it has all the Italian coloratura, all the French dances and dramatic pathos, all the German polyphony, and all the English staidness one could want. In this staged performance, Handel's score doubly rewards singers who are able to infuse their music with an instinct for acting and character development, as well as, to an extent, tragic declamation in the manner the French made famous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893593/media/2019/11/HGOSaul2019LynnLane-57_kl5xek.jpg){{% /md %}}

<figcaption>(l-r) Aryeh Nussbaum Cohen (David), Christopher Purves (Saul), and Pureum Jo (Merab) in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

Maestro Patrick Summers, in keeping with his vaunted quasi-worship of Handel, has spared no effort in rendering all of his orchestral colors and gestures as organic and non-stylized as possible, a challenge given the need to balance many different consorts, including a highly effective trombone cohort, exposed trumpets, bassoons, and oboes, and a highly varied and engaging continuo ensemble. Indeed, this score shows Handel at his most adventurous in terms of structure, to the point of him using an Italian sinfonia for an overture, which flies in the face of his apparent predilection for French overtures in the manner of Telemann and Bach. (Kudos go to organist Ken Cowan for his deft and graceful handling of the endless stream of notes that Handel gives him here.)

Handel is especially adventurous when it comes to subverting the da capo aria form, which in the hands of continental masters such as Vivaldi, Hasse, Porpora, and Caldara, had undeniably become ossified into an inflexible structure useful for highlighting singers' virtuosity and cantabile tone above all else. Handel, on the other hand, is much more willing to stop an aria in the middle, or use arresting musical gestures that are easy for audiences to react to, or simply have a through-composed or strophic number, David's aria with harp being a transcendent example.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893651/media/2019/11/HGOSaul2019LynnLane-68_d94sjy.jpg){{% /md %}}

<figcaption>Andriana Chuchman (Michal, centre) and HGO dancers in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

He is also much more willing to have harmony and dramatic situation define the vocal line, a feature which reminded me throughout of Rameau's characteristic nonchalance and tunefulness. I cannot possibly exaggerate when I say that this is one of the most consistently inspired scores I have ever encountered: nothing feels like it was written on autopilot, and everything feels compelling in some way, whether subtle or manifest, with an inherent sense of forward purpose. It is surely easy to reserve one's powers for one aria or ensemble in the entirety of a full scale work such as this, but to achieve such a high level of quality and sustain it for hours without flagging is not an easy feat, one that merits comparison with the likes of Mozart for its simultaneous apparent effortlessness, one which Maestro Summers caused to scintillate.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893684/media/2019/11/HGOSaul2019LynnLane-81_mapzpt.jpg){{% /md %}}

<figcaption>Christopher Purves (Saul) in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

This production fleshes out Saul's descent into genuine obsessive insanity in a highly Gothic way that [Christopher Purves](/talking-with-singers-christopher-purves/) is all too happy to flesh out with highly crisp text, which he never lets the music obstruct. He displayed at many junctures tortured grimaces that highlighted the dangerously vacillating nature of his restless spirit. Indeed, he is the sort of person who is most apt to illustrate the potential pitfalls of monarchy, a paradoxical stance, given that a strong monarchy is exactly what fostered the development of all the ornate French influences of dance and musical style that are impossible to fully escape in Handel's music.

Exemplifying the possible virtues of monarchy, supple countertenor [Aryeh Nussbaum Cohen](/scene/people/aryeh-nussbaum-cohen/) portrays David in his early years, having just slain Goliath and navigating the treachery that can accompany such quick-won celebrity, as he effortlessly leaps between ardent virility and tranquil modesty in various forms, about as often as he changes costumes; he never portrayed David as grasping after the throne in any way, a posture which I found compelling given modern society’s lack of association with such altruistic lack of self-interest.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893874/media/2019/11/HGOSaul2019LynnLane-134_pn3lkf.jpg){{% /md %}}

<figcaption>Christopher Purves (Saul) in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

As Jonathan, tenor [Paul Appleby](/scene/people/paul-appleby/) chooses to take the route of playing the Roman model of probity and constancy, easy to overdo, which I have always admired, but a portrayal which he keeps extremely human and believable, the tensions between him and the son of Jesse being always present onstage, even if not directly expressed in the text. His naturalistic delivery was always empathetic, and made me think that there is still hope for composers who take inspiration from classical models of virtue.

Sopranos [Andriana Chuchman](/scene/people/andriana-chuchman/) (Michal) and Pureum Jo (Merab) were also superb in their own spheres as Saul's daughters who are stunned into silent disbelief by the ravings of their father. The former well illustrated the youthful gaiety of the daughter whose effortless grace (which this production keeps ambiguous as to whether this is a natural stance or an affected posture) is well calculated to win over a pure young heart such as David. There is a moment in Act I where Chuchman has to change moods very quickly between two arias, from showing fiery beratement of her haughty sister to a guileless wooing of David. As unbelievable as this sounds, I found the suspension of disbelief which the theatre asks of me in this moment quite effortless on Chuchman’s part.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893769/media/2019/11/HGOSaul2019LynnLane-113_jqifgv.jpg){{% /md %}}

<figcaption>Keith Jameson (Abner, centre) and HGO dancers in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

Jo, as Merab, played her role, with her distinctly aloof and fussy arias, with a great deal more depth of character portrayal than expected, even if I found the wide range of this character led to a slight lack of support in her lower register. Her continuo aria in Act II, which is pretty much the only one with such an old-fashioned instrumentation compared with continental galant tendencies to keep the whole orchestra playing, she delivered with poise and dignity not inconsistent with her previous stubbornness.

Tenor [Keith Jameson](/scene/people/keith-jameson/) played a composite role comprising four different characters well suited to the party atmosphere of Saul’s court, most notably the High Priest. His costume boasted many jester-like features, particularly extremely long nails which he would regularly brandish in a sinuous manner, which heightened the effect of his distinctive speech pattern, which I cannot possibly describe except with the following metaphor: if an opera were ever written about Roman Emperor Septimius Severus, with his legendary Punic lisp, Jameson would be my top choice to portray him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893804/media/2019/11/HGOSaul2019LynnLane-128_yfhrcu.jpg){{% /md %}}

<figcaption>Paul Appleby (Jonathan) and Christopher Purves (Saul) in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>

Chad Shelton's Witch of Endor, emerging from the dust head-first, rather played up the blasphemous implications of this role. (Pop quiz: Can you guess the meter of the Witch's aria after one listening? Another of Handel's little deceptive tricks which Maestro Summers enjoyed playing up tastefully.)

In sum, _Saul_ constitutes one of the most ambitious productions HGO has yet mounted in terms of sheer originality and integration of concept, and they have succeeded in convincing me that they fully stand behind it. They can be rightly proud of curating an operatic experience that can only be called epochal., and I am certainly satisfied that in their musical and theatrical fluency, the company have demonstrated the capacity to do the likes of Rameau justice, after eschewing the notion that French is, for some reason, difficult.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572893906/media/2019/11/HGOSaul2019LynnLane-151_cobuia.jpg){{% /md %}}

<figcaption>Christopher Purves (Saul) and the HGO Chorus and dancers in Saul, Houston Grand Opera, 2019. Photo: Lynn Lane.</figcaption>  
</figure>