+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-13T07:38:00-06:00"
lastmod = "2016-06-15T08:16:00-06:00"
preamble = "The [Tafelmusik](/scene/companies/tafelmusik-baroque-orchestra-chamber-choir/) Baroque Summer Institute is a renowned training program, offering specialised instruction in baroque performing practice for singers and instrumentalists. For over a week, the 2016 participants have been working with faculty members like [Ann Monoyios](http://www.tafelmusik.org/about/bios/ann-monoyios), [Peter Harvey](http://www.tafelmusik.org/about/bios/peter-harvey), Tafelmusik Baroque Choir director [Ivars Taurins](http://www.tafelmusik.org/about/choir/bios/ivars-taurins), and [Opera Atelier](/scene/companies/opera-atelier/) Co-Artistic Director [Marshall Pynkoski](http://operaatelier.com/about/creative-team/). We had the chance to hear from with baritone [Brian Mummert](/scene/people/brian-mummert/), soprano Marjolaine Horreaux, and mezzo-soprano Georgia Burashko, three singers from this summer's Baroque Summer Institute; they chat about their experience so far, and why they've sought the focused training offered by Tafelmusik.\n\nDon't miss the free [TBSI Orchestra and Choirs](http://www.tafelmusik.org/concert-calendar/events/tafelmusik-baroque-summer-festival) concert, **June 15, 1pm** at Walter Hall; admission is free, and seating is available on a first-come, first-served basis. The TBSI Grand Finale concert, **June 18, 7:30pm** is at Grace Church-on-the-Hill; also free admission, with ticket reservation in advance, but admission is free! [Click here](http://www.tafelmusik.org/concert-calendar/events/tafelmusik-baroque-summer-festival) for full details."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465870382479/2016-06-14---TBSI-Singers.jpg.jpg"
primary_image_credit = "From top left: TBSI participants Marjorie Horreaux, Georgia Burashko, and Brian Mummert."
publishDate = "2016-06-13T20:51:00-06:00"
related_articles = ["articles/i-sang-along-at-tafelmusiks-messiah.md","articles/he-saidshe-said-alcina-at-opera-atelier.md","articles/new-programs-opera-at-tanglewood.md","articles/dont-miss-haus-musik.md"]
related_companies = ["scene/companies/tafelmusik-baroque-orchestra-chamber-choir.md"]
related_people = ["scene/people/brian-mummert.md"]
short_description = "We had the chance to hear from with baritone Brian Mummert, soprano Marjolaine Horreaux, and mezzo-soprano Georgia Burashko, three singers from this summer&#039;s Baroque Summer Institute; they chat about their experience so far, and why they&#039;ve sought the focused training offered by Tafelmusik."
slug = "all-about-the-tafelmusik-baroque-summer-institute"
title = "All about the Tafelmusik Baroque Summer Institute"
+++

## What did you find attractive about attending the Tafelmusik Summer Baroque Institute?

**Brian Mummert**: The quality of the faculty is what initially drew me to TBSI. As a baritone who focuses in part on early repertoire, I couldn't pass up the opportunity to coach and study with Peter Harvey, a legendary Bach specialist. I wasn't as familiar with Ivars Taurins's work before the festival, but I've spent the last week being blown away by both the depth of his knowledge about historical performance practice and his ability to effectively manipulate that knowledge to draw really exciting and moving performances out of his ensembles. 

**Marjolaine Horreaux**: I've found out about the TBSI because of a pamphlet at the Conservatoire de musique de Québec, and as I am really into baroque music, I learned more about the program of the institute. The music chosen for the institute, the amazing faculty and the possibility to be immerged into baroque music for two weeks was more than enough to convince me to apply.

**Georgia Burashko**: I have always loved baroque music. In my undergrad at McGill University I was lucky enough to sing in multiple Early Music Chamber Ensembles, and I have missed it so much. I wanted to learn more about the performance practice of both solo and choral work and about the differences in performance practice between French, German, Italian and English baroque music. Not to mention the chance to work with and learn from so many amazing accomplished musicians! 

## What is unique about what this program offers?

**Brian**: TBSI addresses so many kinds of music-making in its short time frame, which I think makes it unique among summer programs. From fully-staged opera and oratorio performances to chamber ensembles and one-on-a-part choral singing, TBSI ensures that every singer develops each of the many types of musical skills that a professional singer of the 1730s would have (and that become increasingly valuable to the modern singer, as well). 

**Marjolaine**: The full schedule! We have many lessons, with many different teachers who are transmitting their knowledge all the time. It's great also to work in smaller groups, with for example, a violinist from Tafelmusik coaching us. It gives another perspective and ways to feel the music from another point of view.

**Georgia**: The program is unique because we have so much to do. It is such an incredible opportunity to work and perform and discover so much beautiful music in such a short period of time. I am part of a choir, a motet, a madrigal group, an ensemble with instrumentalists, the opera chorus, and working on and singing solo repertoire. We also take baroque dance and are staging the opera. As a singer, it is unique that we get a chance to work with baroque instrumentalists and that is such a treat! Every morning there is a lecture about performance practice - what I learn about in these lectures is in some way or another constantly corresponding with the rehearsals and master classes I have throughout the day. It is an immersion of baroque music!

## How have you found your time thus far in Toronto, and with the Tafelmusik artists?

**Brian**: Working with the members of Tafelmusik has been hugely valuable! I love collaborating with instrumentalists on all sorts of different repertoire, but vocalists and instrumentalists sometimes speak different musical languages. I've learned so much from watching our chamber ensemble coaches, many of whom are Tafelmusik players, talk about interpretive choices with the instrumentalists in our rehearsals, and from sitting in on some of Tafelmusik's rehearsals as well.

**Marjolaine**: It's my first time in Toronto, and I enjoy it a lot! All the Tafelmusik artists are really knowledgeable, and one can easily speak to them. They are available for us and caring - feels like a big family!

**Georgia**: I grew up in Toronto and it is so wonderful to be a part of an organization I have admired for many years. Also, to be in such a supportive and safe environment where everyone is here to learn and wants to be here.

## What have been some particularly valuable skills or memorable moments for you so far?

**Brian**: I don't think I'll ever forget singing Jesus in Bach's *St. Matthew Passion* for the first time with an orchestra of nearly 100 players. Historically accurate? Probably not. Absolutely thrilling? Oh yeah. 

**Marjolaine**: The first reading of JS Bach "Komm, Jesu, Komm" on the second day, with people we didn't know, and didn't know what to expect from them. But it turned out to be so amazing, with the music getting logically in it's place under Ivars Taurins's direction. Wow!

**Georgia**: I have learned about how to properly sing Bach recitative. I have learned a lot about baroque tuning. I have also really enjoyed learning about baroque theatre and baroque gesture. That it is the performers' job to describe their emotion so the audience can feel rather than the performers themselves. 

Ultimately, I am loving the opportunity to make beautiful music all day with my peers and teachers and learning so much. Becoming more familiar with this style allows me to be more confident in the freedom I have making expressive and informed choices as a performer- which excites me! Getting to work with Ivars Taurins, Peter Harvey, Ann Monoyios, Marshall Pynkoski and all of the other fantastic people has been amazing- time is moving crazy fast! 

>[Click here](http://www.tafelmusik.org/concert-calendar/events/tafelmusik-baroque-summer-festival) for details on the remaining free TBSI events in Toronto, running until June 18.
