+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-03-16T14:03:00+00:00"
lastmod = "2017-03-20T16:08:00+00:00"
preamble = "[Alexandra Bourque](/scene/people/alexandra-bourque/) has all the industrious ambition of a rising young conductor. The French Canadian-born maestra is the founder and artistic director of the University of Toronto Brass Ensemble, assistant conductor of both the University of Toronto Wind Ensemble and the Toronto Community Orchestra, and an in-demand pedagogue and violin teacher in Québec and Ontario.\n\nWe spoke with Bourque about what it takes to carve out a career as a conductor, and how the current generation of musicians can change the noticeable gender imbalance on the podium."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489769541251/2017-03-17---Alexandra-Bourque.jpg.jpg"
publishDate = "2017-03-20T15:43:00+00:00"
related_articles = ["articles/the-dallas-opera-picks-its-women-conductors.md","articles/a-sweet-girl-on-the-podium-can-make-ones-thoughts-drift-toward-something-else.md"]
related_people = ["scene/people/alexandra-bourque.md"]
short_description = "&quot;I believe it is because of the subjectivity within the audition process that it is still difficult for women to gain entry into this profession. Even with the best education and experience, if you do not fit &quot;the vision,&quot; which has traditionally been of a male conductor, you do not have a chance.&quot;"
slug = "alexandra-bourque-it-is-such-a-rush-of-adrenaline"
title = "Alexandra Bourque: &quot;It is such a rush of adrenaline.&quot;"
+++

## Is orchestral conducting really a man's world?

I believe the numbers speak for themselves. More women are getting conducting degrees, though it is still difficult for us to get major positions with orchestras and large ensembles. However, I think it is slowing changing and we are going to see more women in the field in the next few years. But really, it is true (and again this is based on my personal experience, it might be a little bit different elsewhere), it was not uncommon for me to see male conductors in professional or semi-professional positions without an extensive musical training behind them (no major degrees in music). 

As for the few women accessing these positions, most of them have their doctorate degree and an extensive musical resume. My question is: As women, do we have to be 3 times more competent and educated than men to reach the same positions? Is the word "doctorate degree" the only word worthy enough to get us an audition and people's attention?

## Why do you think conducting is a discipline that seems slow to move towards gender equality?

The art of conducting is at the heart a very subjective milieu based on many philosophies quite different from one another. Being a good conductor requires an extensive musical training, experience, good finances, and connections. 

Getting an education is only one part of the equation; it is worthless if the conductor is not able to gain experience in the field. The problem is that this experience is all about someone (usually an established conductor) giving you opportunities, giving you a chance, believing in you (either with his own orchestra or as a mentor). 

This reality contains two challenges. The first, is that I do not believe a large percentage of male conductors would consider and take seriously a young woman approaching them for help and guidance. The second is, that because of this first challenge, I believe most women do not even consider this profession open for them; it is not even an option, a possibility. 

Therefore, because it is a challenge for women to get experience in the field, it is also difficult to learn the profession. How can we learn to be good conductors if we do not have the opportunity to get experience? How can we send good video tape (used to win an audition for school or a job) if we do not have the possibility to be in front of an orchestra? This is only perpetuating the false notion that women are not as good; that they do not possess what is takes. 

The way it works in the field (for school or in a professional setting) is that an applicant must send a video of him/her to the institution or orchestra he/she wants to study or work for, and from the applications received, the board will invite the most promising applicants. Therefore, without a good video, it is almost impossible to get an audition. 

If a woman is able to obtain an audition, it is already an achievement. But what happens during the auditioning process? An applicant will prepare a number of pieces and will conduct them either only in rehearsal or also during a performance. Now, the evaluation of the applicant is not primarily about his/her skills but how does the panel perceives the applicant. This world is a game. It is all about "impression". An applicant will be given the position/job if he/she fits the vision of the panel. 

However, this notion of "vision" is very subjective. In other words, the successful applicant will be the one "making the best impression" based on the panel's philosophy of music, personal background, likes/dislikes etc. Therefore, it is not about the applicant, it is about "how much do I fit the panel's vision"? If the panel's vision is still reticent with the introduction of women conductors and their "image of the podium" does not include women, this world will never change. And again, even if these conductors would declare having nothing against women conductors, they can still find problems in the woman's audition related to more feminine features and not her lack of abilities or technical skill. 

I have received comments telling me: "you don't have what it takes," "you have no leadership," "you are not in charge," "you look too young," "how old are you?" "you look too inexperienced," "you're not ready for this," "be a musician in my orchestra for many years, and maybe one day I will consider you." 

None of these comments is a fair evaluation of who I am. It is also not based on my abilities or resume, but how I look and the "impression" they have of me, not my true value or skill set. I know male candidates that were younger than me and had little experience who were given that first crucial chance and taken for important positions. 

I believe it is because of the subjectivity within the audition process that it is still difficult for women to gain entry into this profession. Even with the best education and experience, if you do not fit "the vision," which has traditionally been of a male conductor, you do not have a chance. 

To make a similar comparison, let's talk about the introduction of women in orchestras as professional musicians. Women started to be slowly accepted as musicians at the beginning of the 20th century but these positions were mainly in all-women orchestras. This reality drastically changed only with the introduction of blind auditions. The blind audition process stopped any kind of subjectivity surrounding the audition. It was all about "how it sounds". Unfortunately, this process would be almost impossible to apply conducting auditions.

## What does it feel like to conduct an orchestra, when all is going well?

Like heaven. It is such a rush of adrenaline. You get the feeling that you are creating music with your hands; that you are painting music. You are only one soul with the orchestra. This is like an artwork full of different colors, shapes and emotions, but honestly the mental force needed to conduct an orchestra is so intense that the only thing you have the time to really think about is what happened, what is happening, and what is going to happen in the next bar. 

## What are some skills a conductor needs to have outside of leading an orchestra?

What makes the job of a conductor such a difficult one is without any doubts the number of skills needed to for such a profession. The time spent on the music is actually only small portion of the agenda of a conductor. A conductors needs to have a strong leadership. This leadership includes administrative abilities, interpersonal skills, knowledge of the music business, finances, marketing and publicity, etc. Being a music director is like running a business to which the conductor oversees everything. The more professional the orchestra, the more focused on the music the conductor will be, but this reality is very different for semi-professional and amateur orchestras. I have seen conductors taking care of stands, chairs, their own podium, the food, programs, etc.

## What pieces are on your conducting wish-list?

If I had to give a few names I would say: Tchaikovsky Symphony No. 1 and Violin Concerto, Beethoven Symphony No. 9, Mozart, Verdi and Dvorak *Requiems*, Elgar Cello Concerto, Rachmaninov Piano Concertos, *Angels in the Architecture* by Ticheli, and *Casanova* for Cello and Wind Orchestra by De Meij.

I want to conclude this article by saying that even if I have received nasty comments from people around me, I also had the support of incredible teachers, musicians, friends and colleagues, and they are the reason that I was able to receive my training, even with the challenges surrounding me. Many thanks to my mentor and teacher Dr. Gillian MacKay and Maestro Uri Mayer for their outstanding support.
