+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-08T15:30:00-05:00"
lastmod = "2016-01-11T09:47:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452302752817/2016-01-08---Alexander-Neef1.jpg.jpg"
primary_image_credit = "Photo by Bo Huang."
publishDate = "2016-01-11T08:51:00-05:00"
related_articles = ["articles/ian-page-mozart-imagination.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/alexander-neef.md"]
short_description = "One of the best sets of ears in Toronto belongs to Alexander Neef, General Director of the Canadian Opera Company. He&#039;s an impressive source when it comes to classical music recordings, and until recently he had a wall-to-wall library of CDs collected over his lifetime. &quot;I probably gave between 2500-3000 CDs to the COC, because I thought those recordings...I knew quite well all of them would be great for the [COC Ensemble Studio] to use.&quot;"
slug = "alexander-neef-listening-to-music"
title = "Alexander Neef: listening to music"
+++

One of Canada's best sets of ears belongs to [Alexander Neef](/scene/people/alexander-neef/), General Director of the [Canadian Opera Company](/scene/companies/canadian-opera-company/). He's an impressive source when it comes to classical music recordings, and until recently he had a wall-to-wall library of CDs collected over his lifetime. "I probably gave between 2500 to 3000 CDs to the COC, because I thought those recordings...I knew quite well all of them would be great for the [COC Ensemble Studio] to use."

Listening to singers is something he has been doing since his childhood, starting simply with what he heard on the radio. "I taped a lot from the radio, you know, the operas from Bayreuth in the summer, the operas form Salzburg in the summer, and all kinds of stuff, I'd just tape it off the radio. I still have boxes of tapes at my parents' house."

His childhood introduction to music was seamless and organic. "When you're my age and you grew up in Germany, there was a very easily accessible basic music education outside of school." Smaller specialty schools offered a curriculum in music, and Neef credits these learning experiences for sparking his musical interest. "I have photos of myself singing in kindergarten," he remembers.

## Building a collection

Neef says that he "just happened to like classical music," and one of the first recordings that he remembers listening to was *The Magic Flute (Highlights)*, the second recording by Herbert von Karajan; "My parents gave that to me." Listening to music on the radio still appealing for Neef, but as the age of the compact disc emerged, his library of recordings began to grow.

Karajan had become an "early hero" for Neef, and his recording of *Der Rosenkavalier* was the first CD that he bought for himself. "You don't really know why you're interested in something sometimes. With recordings, sometimes the cover speaks to you or something. So that was my first, and then after that I bought many, many, many, *many* more." 

Perhaps because his own recording collection grew in the form of compact discs, Neef is fascinated by the current resurgence of vinyl. "The funny thing about vinyl is that it kind of disappeared when the CD came out. But a CD was never the better sound, because of the compressed data - it never had the range. Obviously the problem with vinyl is that the records wear out at some point. But a good vinyl, well-made and well-recorded, has way superior sound to a CD."

For Neef, old records are an important part of his library, even if he does listen to them on CD; he's a collector of the award-winning remasterings by sound engineer [Ward Marston](http://www.marstonrecords.com/html/about.htm). "I am also now much less interested in listening to recordings of people that I can hear live; I'm way more interested in listening to people on record that I can't actually hear live anymore. So I'm getting more and more interested in old, older, and very old recordings." 

He's passionate about historical recordings as a means to understand singers and vocal aesthetics of previous generations. Listening to records from the first decades of the 20th century require some "acceptance" of the technical limitations of early recording equipment. Neef is fascinated by the fact that early technology offered "no opportunity for manipulation; they could just do one take. Or, they could do several takes but they could not cut and paste it together; it was just what it was."

Not just the performances, but the legacies of some early 20th-century singers were left in the hands of early recording technology. It was so limited, says Neef, "that some voices just sound terrible." There were exceptions, notably Enrico Caruso, who sounded good on a gramophone. "The way his voice vibrated, and the overtones and all that, it just reproduced well. There are other tenors of that time that initially were way more famous than Caruso that just didn't record well."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452309490074/2016-01-08---Caruso.jpg.jpg)<figcaption>Enrico Caruso in 1918, with a Victrola phonograph.</figcaption>
</figure>

## New ways to listen 

Only recently did Neef become comfortable with the idea of relinquishing physical records and CDs, and instead listening to his daily fix online. "I just became, a couple of months ago, an Apple Music subscriber," he admits. "I actually listen to more music than I ever have before." 

Before giving away a good portion of his library to the COC, he copied everything to a "neat hard drive", a choice that can seem unsatisfactory for many collectors of recordings. "It's funny how this changes; it would have bothered me a lot a year ago. I had a very 'my recordings' thing, you know, like a second family."

Like most music lovers, he finds it hard to ignore the impressive range of classical music available online. "There's nothing that's not on YouTube in one way or the other," he says, adding that he prefers the paid streaming services, which are better curated. 

"There's always the risk of something being taken off [YouTube]. That would have been my big fear in the past, that it's not there for my use anymore. But then obviously when you deal with classical music, it's not like a pop album that only exists once. If you're interested Beethoven symphonies, I'm pretty confident that there's always going to be a couple of good recordings of the Beethoven symphonies available."

It's true that services like Google Play Music and Apple Music make it easier for anyone to start a collection of their own. "I would just browse and listen," advises Neef. The online options allow for endless trails of clicks, without the risk of emptying your wallet. "You can have a project to listen to all the available recordings of *Tosca*, for $10 a month."

## Building libraries

But where does an eager listener begin? With centuries' worth of music now a click away, how do we avoid blinding groping for music we happen to like? "I mean, if you follow an artist, you discover the repertoire way more than if you follow just one specific composer," says Neef. Rather than a marathon session of Verdi or Puccini, he's an advocate of "shopping around", or listening in small doses. "I always found really well-curated albums of arias and ensembles very interesting, because it allows you to cover a certain range with one voice or two voices."

Neef recommends a few starting points, like Leontyne Price's "legendary" [*Blue Album*](http://www.amazon.com/Leontyne-Price-Arias-Price/dp/B0002TKFRW), and [Pavarotti's early albums](http://www.discogs.com/Luciano-Pavarotti-Primo-Tenore/master/465418) of arias, "or there's a great [duet album](https://www.amazon.com/gp/product/B000V6S7OE?ie=UTF8&*Version*=1&*entries*=0) with Freni and Scotto doing *Norma* and other stuff. I think it gives you a lot of different repertoire in manageable chunks."

When it comes to listening to classical music, the inherent difference from pop music is that the piece of music and the recording are complete works independently. "For me," says Neef, "the recording is more like a study purpose." It's not about doing one's homework before listening, but it's about having the chance to hear what one performance sounds like, one combination of conductor, singers, orchestra, .and space. 

"I think that the great thing about the different aesthetics of recordings and live is that things can be really great on recording that you would hate in a live situation." He names as an example Sinopoli's recordings in the 1980s of the great Puccini operas. "He had a very mannered conducting style that was really enervating in live performance, mostly because it was very slow. But to have that in studio, and to hear a lot of detail from those scores, it's really fascinating."

That's not to say there's no enjoyment in all the studious listening. "There are things that are just great; let's say the [Callas *Tosca* with De Sabata](http://www.amazon.com/Puccini-Tosca-Maria-Callas/dp/B000002RXZ), I mean, everything is great about that recording."

>What do you listen for in a classical music recording? How do you like to listen to it? Let us know in the comments below!
