+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-05-28T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Purcell's [_Dido & Aeneas_](https://www.deathofclassical.com/angelshare/purcell-dido-and-aeneas), directed by Alek Shrader, runs June 5-8 in the Catacombs of the Green-Wood Cemetery."
preamble = "If you know of [Alek Shrader](/scene/people/alek-shrader/), you know he's an in-demand tenor known for his singing of Rossini, Mozart, and Handel. Of late, Shrader has also turned to directing opera, and his latest project is Purcell's [_Dido & Aeneas_](https://www.deathofclassical.com/angelshare/purcell-dido-and-aeneas), presented by Death of Classical in the Catacombs of Brooklyn's Green-Wood Cemetery.\n\nThe production, starring [Daniela Mack](/talking-with-singers-daniela-mack/) as Dido, includes a pre-show whiskey tasting and a twilight walk through the Catacombs.\n\nWe spoke with Shrader about why he's gotten into directing, and his unique take on Purcell's opera that includes the complementary play by Christopher Marlowe."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1559067336/media/2019/05/sqTheAngelsShareDidoAeneas-pc-KevinCondon.jpg"
primary_image_credit = "Dido & Aeneas, Death of Classical, 2019. Photo: Kevin Condon."
related_articles = ["articles/talking-with-singers-daniela-mack.md"]
related_companies = []
related_people = ["scene/people/daniela-mack.md", "scene/people/alek-shrader.md"]
short_description = "\"Tina Fey said 'If you want to be a screenwriter, take an acting class to get a sense of what you’re asking actors to do.' It's another perfect quote from one of my writing idols, and my performance experience definitely informs hypothetical staging.\""
slug = "alek-shrader-on-directing-dido-ideas-assail-me"
title = "Alek Shrader on directing Dido: \"Ideas assail me.\""
youtube_url = ""

+++
## What inspired your move into directing opera?

I couldn't stop thinking. Ideas assail me, especially at inopportune times. Eventually I just needed to release something from my notebooks and my brain. We'll see if it works. I want to tell stories. If that means performing, directing, writing, or producing, I'm ready.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559067416/media/2019/05/AlekShrader-pc-PeterSchaaf.jpg){{% /md %}}

<figcaption>Alek Shrader, tenor and director of Dido & Aeneas, Death of Classical, 2019. Photo: Peter Schaaf.</figcaption>  
</figure>

## What do you think directors and singers can learn from each other?

Tina Fey said "If you want to be a screenwriter, take an acting class to get a sense of what you’re asking actors to do." It's another perfect quote from one of my writing idols, and my performance experience definitely informs hypothetical staging. I won't ask anybody to do anything I wouldn't be willing to do myself. When I'm directing opera, I'm thinking "Would I do that?" and especially "Would that sabotage my voice?"

For opera it's gotta be text, then voice, then body, and that informs the drama. There's a writing discussion on Twitter right now about "Pantsters" versus "Plotters." Pantsters fly by the seat of their pants and Plotters plot everything out. I'm very much a plotter. I research and plan. I love structure. But it doesn't mean Plotters won't respond to inspiration or can’t change their mind.

>"My Dido is in control. She's not a victim. She's wounded, but she isn't giving up."

As a performer, my favorite thing is to improvise. As a director, I show up with my plan that took all my wee small hours, carefully crafted and such. It's not a living thing. It's a cold blueprint. Then the cast is forced to be Pantsters and fill in the blanks, evolving the shape until we find the fire. (Of course, I adjust the plan as we go.) If that collaboration isn’t there between director and performer, Plotter and Pantsters, you get confusion that muddies the drama and weakens the performance.

To finally answer the question, IMHO: directors tell performers where to stand and how they get there, performers tell directors why (or why not), and we evolve the best story together. That's a long answer, but I think directors and performers should learn a heck of a lot from each other.

## What do you think Purcell's _Dido and Aeneas_ has to say about men, women, and romantic relationships?

I could have read more. In fact, I just found two books that deal with this exact topic, but here goes... I think at a glance the piece says, "Don't let romance make you sad enough to commit suicide." Which is... fine, I suppose, but not for my Dido. My Dido is in control. She's not a victim. She's wounded, but she isn't giving up. She is facing her fate and meeting it head-on. Essentially, she sacrifices herself. That's an important word - sacrifice. Her life is given in exchange for something (multiple things, really).

Ok I'll answer the question! The women are motivated and opposed. Dido is reluctant to love yet faces a choice between someone she doesn't want and another who holds instant attraction. Plus, her adolescent sister Anna (Purcell's Second Woman) kinda wants both of them. Sorceress is hellbent on ruining Dido, no matter who else gets hurt. Meanwhile, Belinda just wants love to rule.

>"There's still a cautionary aspect here. Dido never chooses violence."

The women are constantly challenged to prove their power, their attitude. The men enjoy privilege, even reverence. The vehicle of challenge is mostly romance. Aeneas lives without consequence. He bears no responsibility for his actions, even at his own expense, because his destiny has been ordained by a higher power. His piety is considered a virtue, but it serves as an excuse. Achates (Purcell's Sailor) seethes toxic masculinity, which we know so well today. Iarbas, the Berber king, expects his desires and demands to be fulfilled without question. Though he finds Dido to be exceptional, his opinion that women are cruel and deceitful is clear.

I, for one, need all that in my Dido story. That's why I mashed up Marlowe's play with Tate/Purcell. I mean, it was all there before. Let's put it back!

Circling back to Dido as a woman challenged by romance... We have to remember that suicide in ancient times could have many purposes (thank you, Wikipedia and Émile Durkheim). Dido's self-sacrifice is anything but punishment for losing her virginity to a guy who up and left her. I reject that moral tale (if that's indeed what Tate & Purcell had in mind). She burned herself long before Aeneas was added to her story. Even Virgil shows her defiant of fate, burning, bleeding, yet unable to actually die until Juno sends Iris to release her spirit. Tate writes "Forget my fate" - it's hers alone, not for anyone to judge. He also writes “Remember me” - her choices, her life.

That's how I read it, anyway. There's still a cautionary aspect here. Dido never chooses violence. Instead, she relies on her intelligence and authority. Only when Aeneas offers to be her champion does she consider a military option. When he departs, she returns to honor and integrity, avoiding conflict. In the end, she sacrifices herself to defy her unwanted suitor, and his respect for her conviction prevents Carthage from being overrun.

So, what I see here is that when the conflict is such that lives are at stake, we know that someone will die (maybe even dying already)... Will we be sacrificed or will we fight?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559067468/media/2019/05/TheAngelsShare-DidoAeneas-pc-KevinCondon.jpg){{% /md %}}

<figcaption>Dido & Aeneas, Death of Classical, 2019. Photo: Kevin Condon.</figcaption>  
</figure>

## Do you have any more operas on your directorial wish list?

I have concepts for a whole mess of shows. Another bit of writing advice is "write the show you want to see." So, I'm ready to roll out all these shows I'd love to see but haven't yet... I'd also love to create brand new shows, maybe even ones I wrote myself.