+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2018-02-10T22:17:00-05:00"
lastmod = "2018-02-12T08:50:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518318383389/lawrence-cover.jpg.jpg"
publishDate = "2018-02-11T20:33:00-05:00"
related_articles = ["articles/album-review-all-who-wander.md"]
related_companies = ["scene/companies/canadian-art-song-project.md"]
related_people = ["scene/people/lawrence-wiliford.md","scene/people/steven-philcox.md"]
short_description = "The songs by Edmund Rubbra (1901-1986) are the real find in this album. His songs have a unique sound, a style that&#039;s difficult to place, but eventually emerges as English - yet with an edge. "
slug = "album-review-o-gladsome-light"
title = "Album review: O Gladsome Light"
+++

The latest in tenor [Lawrence Wiliford](/scene/people/lawrence-wiliford/)'s extensive discography is [*O Gladsome Light*](http://stonerecords.co.uk/album/o-gladsome-light/), released on [Stone Records](http://stonerecords.co.uk/album/o-gladsome-light/); the album is a collection of sacred songs by Gustav Holst, his friend and colleague Ralph Vaughan Williams, and his composition pupil Edmund Rubbra.

"This project was largely inspired by my upbringing in the church (my father and mother are both pastors) and my musically formative years singing sacred works in the American Boychoir and the St. Olaf Choir."

*O Gladsome Light* groups together some of Canada's best in song and chamber music. Wiliford is joined by pianist Stephen Philcox, frequent recital partner of the tenor's and co-founder of the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/), violinist Marie Bérard, and violist Keith Hamm, both members of the [Canadian Opera Company](/scene/companies/canadian-opera-company/) Orchestra. They play in varied combinations, and throughout the album the four musicians create a sound that is timeless and almost pan-stylistic, a beautiful and eerie effect.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518318413791/Group2_pocketfix.jpg.jpg)
<figcaption>(l-r) Stephen Philcox, Marie Bérard, Lawrence Wiliford, and Keith Hamm. Photo: Leigh Miller.</figcaption>
</figure>

Wiliford's own upbringing, strongly rooted in the church, is perhaps why *O Gladsome Light* is full of gorgeous surprises, no predictable survey of sacred music. The songs of Ralph Vaughan Williams are well-known among art song lovers, yet his *Four Hymns for Tenor, piano and Viola* are rarer gems. Philcox begins the set with a dreamy piano sound, and the set seems to fill out boldly, boasting a symphonic sound that belies the small ensemble. 

Rare and welcome too are the songs by Gustav Holst, a composer perhaps better known for his orchestral work. His *Four Songs for Voice and Violin* are haunting, with a sound that could be from any place, at any time. The simplicity of combining voice and strings - the purity of the harmonies and of Wiliford's assured tone - feels like a nod to a very old tradition.

The songs by Edmund Rubbra (1901-1986) are the real find in this album. His sound is unique, and his is style that's difficult to place, but eventually emerges as English - yet with an edge. The selections of *O Gladsome Light* are dense in meaning, and the interpretation by Wiliford is magnetic. There's humility in Rubbra's *Rune of Hospitality*, the rock of a lullaby in *A Duan of Barra*, and something beautifully feminine about *Jesukin*. 

In a lovely nod to Rubbra's versatility as a composer, the album includes two moving solo pieces: his *Variations on a Phrygian Theme for solo violin* (played by Marie Bérard), and *Meditations on a Byzantine Hymn for solo viola* (played by Keith Hamm). 

Throughout this album, Wiliford's sound is strong yet gentle, always thoughtful. *O Gladsome Light* is a carefully crafted album that shows the tenor's constant attention to detail, from the research and curation of this inspired collection of repertoire, to the music-making itself.

>*O Gladsome Light* is released on [Stone Records](http://stonerecords.co.uk/album/o-gladsome-light/), and is also [available on iTunes](https://itunes.apple.com/us/album/o-gladsome-light-sacred-songs-hymns-meditations/id1297031643).
