+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2014-02-12T19:09:00-05:00"
lastmod = "2015-04-27T22:46:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1430189111304/Doug.jpg.jpg"
publishDate = "2014-02-12T19:09:00-05:00"
related_people = ["scene/people/doug-macnaughton.md"]
short_description = "This week, Canadian baritone and guitarist Doug MacNaughton releases Guitarias. It&#039;s his debut recording on the guitar, fusing what&#039;s clearly been two important elements to Doug&#039;s life as a musician."
slug = "album-review-guitarias"
title = "Album Review: Guitarias"
+++

This week, Canadian baritone and guitarist [Doug MacNaughton](http://www.dougmacnaughton.com/) releases _Guitarias._ It's his debut recording on the guitar, fusing what's clearly been two important elements to Doug's life as a musician.

I listened to this album, for the most part, ignorant of much of its music. I of course knew a few works by [John Rutter](http://www.johnrutter.com/), and few a more by Canadian composer [John Beckwith](http://en.wikipedia.org/wiki/John_Beckwith_(composer)), and I'd heard of Canadians [William Beauvais](http://en.wikipedia.org/wiki/William_Beauvais) and [Leslie Uyeda](http://www.leslieuyeda.com/). I felt slightly less ignorant when I saw two out of the three featured composers had written commissions for Doug himself. And so it was a novel experience to listen to unknown music written for a duo that wasn't a singer and a piano.

In Beckwith's set _Beckett Songs_, Doug strikes a balance between familiar minstrel-ish guitar sounds and the immediacy of text that is always found in Beckwith's vocal writing. I liked the flow in and out of meandering phrases, the poems' dramatic beats punctuated with free, improvisatory declamations. I'm also a big fan of [Samuel Beckett](http://en.wikipedia.org/wiki/Samuel_Beckett), so I was intrigued early on.

Doug has a beautiful way with his voice in this album. It's a very vulnerable sound, and accessible. He's a study in clear singing in English. I got every word, and the tricky text was only obscured in the most extreme registers. I started noticing it particularly in _Flower Arranger_, a song that requires real storytelling. And in what I think is my favourite set on the album, Doug's freedom with the language and its relationship to the music were clearest in William Beauvais' _The Truth of the Matter_.

John Rutter's song cycle for baritone and guitar, _Shadows_, was also new for me. The cycle sets texts from the 16th- and 17th-centuries, and I fell immediately for the charm in these songs. Rutter wrote the text setting and guitar part in that minstrel-ish style, and with the simplicity and definite stylistic lines clearly drawn, Doug presents to us a beautiful homage to centuries ago. I found much attention to truly the _sound __effect_ he gave us between the quality of his voice and the affect of the wandering guitar. There were the usual themes of love and rejection, and overdoing one's pleasure. I always love when something as blunt as form can create an environment where each musical detail is meaningful; Doug's rendition of _Shadows_ is a perfect example.

As he states in the program notes, Doug had considered recording the guitar and voice tracks separately, but instead decided to favour a live acoustic and the intimacy that is intended in this music, written for a singer to accompany himself. "Double-tracking would have required a studio setting, and the guitar and voice parts wouldn't have been able to spontaneously respond to each other. The music is much more alive when both parts have the freedom to perform expressively."

And that was what I enjoyed the most on this album. As someone who makes a career partly out of learning to read someone else's mind, I understand what it means for a soloist to feel free, and for an accompanist to have room to inspire. Listening to Doug sing and strum at the same time, I heard the sound that all duos try emulate. It's true, the sacrifice of a studio recording was no sacrifice at all when it brought us a friendly acoustic and the spontaneity of one person's musical train of thought.

_Guitarias_ is available for purchase at Doug's [website](http://dougmacnaughton.com/recordings.html), and his CD launch party is this Sunday, February 16th from 3-7:00pm at Tall Boys Craft Beer House, 838 Bloor Street West, Toronto.
