+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-03-06T14:55:00+00:00"
lastmod = "2016-03-07T11:19:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457276138343/Cloud-Light.jpg.jpg"
publishDate = "2016-03-07T11:19:00+00:00"
related_articles = ["articles/in-review-ash-roses.md","articles/aptly-named-the-living-spectacle.md"]
related_companies = ["scene/companies/canadian-art-song-project.md"]
related_people = ["scene/people/lawrence-wiliford.md","scene/people/michle-bogdanowicz.md","scene/people/jacqueline-woodley.md","scene/people/peter-mcgillivray.md","scene/people/steven-philcox.md"]
short_description = "The Canadian Art Song Project has released its second full-length recording (the first being 2014&#039;s Ash Roses), which features the music of Polish-born composer Norbert Palej (currently teaching at the University of Toronto), performed by five important Canadian artists of today. Cloud Light, released this year by Centrediscs, is an album of music &quot;that actively grapples with the modern understanding of art song and demonstrates that it is still a genre capable of the most profound musical expression and innovation.&quot;"
slug = "album-review-cloud-light"
title = "Album review: Cloud Light"
+++

The [Canadian Art Song Project](/scene/companies/canadian-art-song-project/) has released its second full-length recording (the first being 2014's [*Ash Roses*](/in-review-ash-roses/)), which features the music of Polish-born composer [Norbert Palej](http://www.norbertpalej.com/) (currently teaching at the University of Toronto), performed by five important Canadian artists of today. [*Cloud Light*](https://www.musiccentre.ca/node/137420), released this year by Centrediscs, is an album of music "that actively grapples with the modern understanding of art song and demonstrates that it is still a genre capable of the most profound musical expression and innovation." 

CASP has been answering similar questions with its recent projects, notably [*The Living Spectacle*](/aptly-named-the-living-spectacle/), a concert in an up-close venue, featuring stellar Canadian singers [Carla Huhtanen](/scene/people/carla-huhtanen/) and [Ambur Braid](/scene/people/ambur-braid/), plus choreographer and dancer [Jennifer Nichols](/scene/people/jennifer-nichols/). It's more difficult to carve out uniqueness with music alone, yet *Cloud Light* achieves it. The album is full of new sonorities, and Norbert Palej is indeed a composer who adapts his sound to the poetry in front of him.

The album features performances by Canadian Art Song Project co-founders and co-Artistic Directors, tenor [Lawrence Wiliford](/scene/people/lawrence-wiliford/) and pianist [Steven Philcox](/scene/people/steven-philcox/); the two are joined by baritone [Peter McGillivray](/scene/people/peter-mcgillivray/), soprano [Jacqueline Woodley](/scene/people/jacqueline-woodley/) and mezzo-soprano [Michèle Bogdanowicz](/scene/people/michele-bogdanowicz/). Together they perform four works by Palej, in Polish, Classical Latin, and English (including English translations of Norwegian texts by Henrik Ibsen and Bjørnstjerne Bjørnson). 

In his notes, Palej writes, "English: concise, clear, direct, simple, yet nimble – a language of open plains. Polish: a language of mystic, primeval noises, from snake-like hissing sounds, to those resembling the rush of wind and rain – a language of the deep woods. Latin: stark and forbidding, cold even, enigmatic because so distant – a terrifying voice from beyond the grave. Each language with its own soul, forged through tradition, salted with human suffering across eons. How can a language then not steer the composer’s musical imagination, hypnotize it with its sound, and abduct the unwary prisoner into foreign lands?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457288986837/2016-03-06---Peter-McGillivray.jpg.jpg)
<figcaption>Peter McGillivray, baritone.</figcaption>
</figure>

The first tracks of *Cloud Light* are *Three Norwegian Songs*, performed by Peter McGillivray and Steven Philcox. The two expert musicians create a nebulous sound that feels primordial; McGillivray is well-suited to the composer's chant-like immediacy of the set text, and Philcox finds ringing overtones in the undulating piano part. It's difficult to describe the qualities that come with Scandinavian art song, almost as difficut as describing a sound that is clearly Canadian; yet these qualities are all clear in the *Norwegian Songs*. Like much of the music featured on *Cloud Light*, Palej uses open octaves and fifths, and a free, parlando-style delivery of the text; the effect is an ancient sound, free from geography or period of time.

Michèle Bogdanowicz commissioned Palej's *Four Lyrical Moments* in 2013, and the set was premiered as a gift to her father, who was displaced from Poland during WWII. "Such a personal occasion for the songs," Wiliford and Philcox write in their album notes, "in addition to a shared cultural history between composer and performer, make this work unique among the three cycles." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457289028215/2016-03-06---Michele-Bogdanowicz.jpg.jpg)
<figcaption>Michèle Bogdanowicz, mezzo-soprano.</figcaption>
</figure>

Despite our almost non-existent grasp of the Polish language, it's clear that Palej takes every opportunity for word-painting; it's a fascinating experience to listen to these songs, and follow closely with the English translation of Halina Poświatowska's poetry (provided by Palej himself). Bogdanowicz sings with her rich, ringing sound, and she seems to find freedom in the folk-like songs.

The title set of the album is *Cloud Light: Fourteen Small Songs for Voice and Piano*, and the songs are shared by Lawrence Wiliford and Jacqueline Woodley. "Since the poems of Jan Zwicky selected for the work don’t create a linear narrative and are neither male nor female in perspective, we divided the songs in such a way that would suggest that different voice types could perform any song that suited them from the cycle." It's true that both Wiliford and Woodley's voices are easy to imagine singing any of the fourteen songs, largely because of Palej's broad style of sound and treatment of text. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457289103328/2016-03-06---Jackie-Woodley.jpg.jpg)
<figcaption>Jacqueline Woodley, soprano.</figcaption>
</figure>

*Cloud Light* is a cycle that sets selections from Jan Zwicky's *Thirty-seven Small Songs & Thirteen Silences* (Gaspereau Press, 2005). The texts are full references to nighttime, various skies, expansive environments, wildlife and nature; there's a unique pairing of night imagery with clothing material ("the clothes of night", "The day has taken off her silk shirt and turned it inside out"). The poems are hazy in tangible meaning, yet constantly evocative. 

In *Cloud Light*, Palej enjoys writing vocal extremes and curious effects to serve the text. There's a consistent sound holding the cycle together, and the writing is particularly great at creating a world for each song. "Small Song: Anger" features aggressive piano octaves, as though the sound is railing against some hard surface. "Small Song: Prairie" gives the effect of a flat landscape, with Woodley's downward portamentos on the word "light" making us think of long, stretching shadows across a plain.

The final track is Palej's powerful *The Demise of Argus Panoptes*, for piano and SATB quartet. All four singers and Philcox perform this scene, with the quartet acting in a Greek-chorus style of rhetoric. In Greek mythology, Argus Panoptes ("all-seeing") is a 100-eyed giant, who never falls fully asleep because his many eyes catch their respective Z's in shifts. He serves Hera, who charges him with guarding Io, the nymph after which her philandering husband Zeus chases, and whom Hera turns into a cow to throw off Zeus' search. Zeus frees Io by sending Mercury (or Hermes, if you prefer) to kill Argus, and it's this part of Ovid's *Metamorphoses* that Palej sets to music.

The scene is totally engrossing, partly because of its spun title. Many tellings of this story depict Argus as a villain, or at least a villain's aide; yet Palej takes Ovid's text and writes something mournful, almost like a funeral dirge for the giant who died at the tricky Mercury's hands. The ominous piano chords, separated by uncomfortable silences, treat Mercury like a dangerous hunter, and the quartet sings the Latin text in broken, unnatural beats. The scene comes to life with eerie effects like whispers on "oculos" ("eyes") and otherworldly cascade of voices on "lumina virga" ("magic wand" or "lightning rod"). It's a piece that we're itching to hear live; SATB quartet and piano may not seem like a novel combination, yet we've not heard anything quite like *The Demise of Argus Panoptes* before.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457346982991/WilifordPhilcox.jpg.jpg)
<figcaption>l-r: Stephen Philcox and Lawrence Wiliford, co-founders and co-Artistic Directors of the Canadian Art Song Project.</figcaption></figure>

*Cloud Light* is yet another result of the skilled performers and thoughtful attention to detail that are major parts of the Canadian Art Song Project's work. At about $14 CAD, the album is a great way to hear some of Canada's best artists, performing music with which you're likely not yet familiar. [Click here](https://www.musiccentre.ca/node/137420) for full details, samples, and to purchase a hard or digital copy. 
