+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2014-08-08T11:58:00-04:00"
lastmod = "2015-04-27T18:02:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429239943077/Alaina-Viau-2048px.jpg.jpg"
publishDate = "2014-08-08T11:58:00-04:00"
related_articles = ["articles/in-review-dissociative-me.md"]
related_companies = ["scene/companies/loose-tea-music-theatre.md"]
related_people = ["scene/people/gregory-finney.md","scene/people/alaina-viau.md"]
short_description = "Alaina Viau is the Artistic Director of LooseTEA Music Theatre. She&#039;s hard at work with the creative team of LooseTEA&#039;s upcoming double-bill, Love in the Age of AutoCorrect. The double-bill includes present-day adaptations of Mozart&#039;s Bastien und Bastienne and Stravinsky&#039;s Mavra. "
slug = "alainas-autocorrect"
title = "Alaina&#039;s AutoCorrect"
+++

Alaina Viau is the Artistic Director of [LooseTEA Music Theatre](http://looseteamusictheatre.com/). She's hard at work with the creative team of LooseTEA's upcoming double-bill, _Love in the Age of AutoCorrect_. The double-bill includes present-day adaptations of Mozart's _Bastien und Bastienne_ and Stravinsky's _Mavra_. Because this opera world is small, it's no surprise that Alaina happens to be working on this project with so with my friend and [frequent Schmopera-contributor](http://schmopera.com/author/greg/) Gregory Finney. I asked Alaina a few questions about presenting two operas in updated forms and why we should keep doing so; Greg was kind enough to chime in with some of his own answers. Love in the Age of AutoCorrect runs August 21-23 at Atelier Rosemarie Umetsu. [Get details and tickets here](http://looseteamusictheatre.com/current-productionautocorrect-operas/).

### 1\. What about _Bastien und Bastienne_ and _Mavra_ make these operas adaptable to present-day?

**Alaina**: _Bastien und Bastienne_ was written 250 years ago and we are still having the same arguments in the same way about the same issues as we do today! This piece is in the vein as a sitcom argument from the likes of _Friends_ or _Sex in the City_. We think in 2014 that we are more evolved than people who lived back in the 1700s, and the truth is, we still think exactly the same way with the same feelings. So it was very easy to put it in a modern setting. _Mavra_ is also similar to a bad (or good?) soap opera with exaggerated life circumstances, decisions and reactions. Making the change in characters (from female to male) has made it much easier to put the opera into a context to which people in the 21st century people will be able to connect. However, the situation described in the opera is still completely relatable. I have had it quite easy this time through in finding the common thread between the setting of the opera and our life today; seems as though we haven’t changed all that much!

**Greg**: It's the age-old plight of awkwardness and screwing up in the first stage of a relationship and I can say that it's relevant because a vaguely similar situation literally happened to me about 2 months ago. Lines crossed, miscommunication over the internet/SMS lead to a whole mess of confusing incidents.

It also updates the classic operatic motif of "the missing letter" or "the intercepted letter" or "the insert-descriptor-here letter". It's almost always a letter. We don't write those anymore, it's all texts, Facebooks, Tweets and emails.

### 2\. What can audiences expect from LooseTEA’s upcoming double-bill?

**Alaina**: The show is outside on the lovely terrace at [Atelier Rosemarie Umetsu](http://atelierrosemarieumetsu.com/home) which is going to make this a very fun and hilarious night! We are very lucky to have some great beverage sponsors so now our audience can enjoy amazing music and sip the best wine that Niagara has to offer in the evening on a patio! If the weather is uncooperative, our audience can rest easy that we have designed a canopy that can be deployed! Lastly, the audience can expect an opera that will get them thinking about our modern day lives and how important communication is, and how funny or tragic situations can become when communication is lost. Additionally, it is our goal for the audience to think about today’s world of hyper-connectivity and mass communication, and how it is even more easy to miscommunicate than ever before. We really want our audience to engage with the show, by making noise if they want to, by texting, and Tweeting, remarking to their neighbour. We only hope for people to enjoy themselves!

**Greg**: An intimate venue and a focus on storytelling. Everyone in the cast is a great singer and that's kind of the assumption I make about opera, is that the cast will be good singers. This crew though, great actors too. Lots of fun playing back and forth, and as the show continues to find its feet, we're seeing some really great moments happen. The houses for this one are quite small, so it will have almost an exclusive, private vibe for a very inclusive, affordable public performance.

### 3\. In Mavra, why did you choose to change the traditionally female roles of the Mother and the Neighbour, casting them for baritone (the Parent) and tenor?

**Alaina**: Initially I was going to try casting the females as females; however I was very aware that I might have difficulty finding a Stravinsky mezzo and contralto with my limited budget. As I got more into writing the adaptation I started to get annoyed with the mother character; She just did not seem to make that much sense to the story. Since I was adapting it anyways I started to play with the idea of them being men and having it be a single parent dynamic. It has turned out to work brilliantly and in my opinion, better than the original (Shhhh, don’t tell Stravinsky that). In the context of having a secret lover, I like the father-daughter relationship better than that of a mother. Especially since the father is a single parent and is away often for business, it would make sense that Parasha would have a secret lover more so than with a stay at home mother. It also makes for some really funny moments that could not be there in the original setting. 

### 4\. LooseTEA Music Theatre is all about exploring the new. What is your creative process in doing so, from choosing a piece to putting it on its feet?

**Alaina**: As a director, I pay attention to the world around me a lot; people watching, conversations, watching reactions, body language, current and old news, books (so many books), nature, and many, many shows/concerts of all types. I listen to people and their stories and also take a lot of time to self-reflect on situations, reactions and other outcomes. All of this observation gets thrown into a huge pot in my head. In general, I put a directive like “I love Beethoven’s Symphony no. 5, but what can I do with it that will reflect how I feel about it?” into my brain and set it to percolate. It seems to be reflected unconsciously in my observations and experiences and after not too long an idea pops up unexpectedly. I start to play with the image consciously reflecting it in my everyday life. Of course there are always external things that change the course of the original idea like budget, the space, your singers and then creative ideas are found that will still resonate with the concept.

When I start to look for a piece I pick out a whole range of pieces and start to imagine how that world would look like if it was a situation within modern memory. For this show I was looking for shorter pieces to do a double bill so I researched and decided on a few that I liked the best. On a long weekend where I was sick in bed, I listened and imagined new stories to all of them. I loved _Mavra_ from the get go and sought out to find something to present it with. Luckily the Stravinsky was written during his Neo-classical period and fit very well musically with the Mozart. And they are both comedies. It was pretty much decided at that point. I looked at the main issues within each opera and found that they were both about miscommunication which in the 21st century leads very naturally to how we miscommunicate through our devices. I was sold! I decided it all in that weekend and even came up with the name “Love in the Age of Autocorrect”.

### 5\. How do your roles within the opera and classical music industries complement each other as Artistic Director of LooseTEA?

**Alaina**: Artistically, I have access to many creative people and endeavours, which allows me to take in many different opinions and views. They are generally supportive about my ambitions and are very willing to have conversations and discussions about their work. My best education has been working at the ROH Covent Garden. Just before leaving to return to Canada I sat down with the Director of Opera and talked about the problems, difficulties and strategies for many classical music “issues” from ticket prices to choosing a season and the problem about being stuck in a building. I was just starting to form my idea about LooseTEA and that conversation still sticks with me. It was also seeing every production, over and over with different singers and dancers. It got to the point that if I didn’t see anything for a week I would feel like I was going into withdrawal. It was lovely to feel something every day (almost). I really wanted others to feel the same. I developed a great need to share that and help people feel what I felt through classical music. I realized that I wanted to share experiences.

I have also been fortunate for my job at the GGS! It has given me access to a whole network within the industry in Toronto that would have taken me years to develop. With a lot of hard work I have been able to learn what I need to be a successful arts business person from managing large budgets, production/stage management, and the costs of creativity both on stage and in the orchestra. I am not just an Artistic Director but I am an administrator as well. This means I can balance my creativity with the practical and make decisions that are going to be the biggest bang for my buck, so to say!

### 6\. What sort of evolution has LooseTEA seen from one production to the next?

**Alaina**: We have two very exciting developments this year; the first is that we have a GM!! This has been the most exciting part for LooseTEA/me. It means I don’t have to do everything myself, which was stifling my creativity. I didn’t choose this show until February, so I have not had as much lead time as would be preferred; however having a GM has given the company stability in future planning. We have a very solid 3-5 year plan to expand the scope and number of shows we present. I have productions planned out up to 2017, with partners and partnering artists already being engaged for both operas and staged orchestral works. 

In terms of the actual productions, this year is actually smaller than last year mostly because of the added work of writing an adaptation, which I have never done before. The piece also doesn’t require as much set/costume/lighting as Carmen so we can make it rely more on the acting and comedy. I don’t think that any two works will ever be presented the same. They all require different spaces, and sizes of productions. Each production is being presented in the way best suited to the concept, and to the highest artistic quality that our passion can muster, which naturally means that they should all be different from each other. We also received our Not-for-Profit status and our charitable application has been sent in. It is all starting to feel legit! 

### 7\. Do you have any bucket-list shows you’d like to present in the future?

**Alaina**: Haha! So many! This past spring I have had an out pouring of creativity as my GM and I work toward our 3 -5 year plan. I have been finding it funny that I have chosen some pieces that I like and others that I usually would not care much for. For example, I didn’t really care much for _Carmen_ in the past because I had so many issues with it. When I can change/adapt and reconstruct my idea of a piece then that is when it really starts to grab me by the collar! Because of that I don’t particularly have a bucket list, but I can give you a sneak peek into what I’m working on for the future: _Faust_, _Adieu Robert Schumann_, _Don Quichotte_, _Eight Songs for a Mad King_, _La bohème_, Beethoven's symphonies 9 and 5, with a Stravinsky/Gesualdo inspired installation.

**Greg: **SING ALL OF THE SHOWS!! Seriously though my top ones right now are Papageno in _Magic Flute_/Leporello in _Don Giovanni_. I've sung both in concert, but I'd love to get to play around the stage with them. Sweeney in _Sweeney Todd: The Demon Barber of Fleet Street_ (this should require no explanation) and Javert in _Les Misérables_.

Get your tickets for _Love in the Age of AutoCorrect_ [right here](http://looseteamusictheatre.com/buy-tickets/)! I'll see you all there.
