+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = 2020-02-09T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Houston Grand Opera's production of [_Aida_](https://www.houstongrandopera.org/aida) runs through February 16. "
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1581279748/media/2020/02/sqHGO-AIDA-2020-LynnLane-270_ow1edt.jpg"
primary_image_credit = " in Houston Grand Opera's production of Aida, 2020. Photo: Lynn Lane."
related_articles = []
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/melody-moore.md", "scene/people/tamara-wilson.md", "scene/people/russell-thomas.md"]
short_description = "Throughout the production, one could see many of these geometric shapes infiltrating the scene at many different points. Characters maneuver around them and discuss plans in their shadow. This rendered the Act III trio somewhat difficult to follow if you were seated on one of the sides of the theatre, given the lines of sight. "
slug = "transcendent-music-uneven-staging-in-hgos-aida"
title = "Transcendent music & uneven staging in HGO's Aida"
youtube_url = ""

+++
Giuseppe Verdi’s _Aida_ came across in Houston Grand Opera’s recent rendition as a well-oiled machine. Even though [Phelim McDermott's new staging](https://www.houstongrandopera.org/aida) was uneven, it had many aspects that led me to understand how little I really knew this piece. Certainly, the big moments in _Aida_ are inescapable, even ubiquitous, in the artistic world. But when combined with all the little moments that this production highlighted, which one has to take along with the "greatest hits," it illuminated me greatly as to just how much a master of drama Verdi certainly is.

I use the word "illuminated" with intent, as light was a very pivotal concept for this production. The prelude, for instance, opened with a controlled opening of the curtains to reveal a blazing pillar of triangular light. Perhaps this was to represent an obelisk or even a pyramid, though the sides were so steep as to resemble the Nubian pyramids of the Late Period. Throughout the production, one could see many of these geometric shapes infiltrating the scene at many different points. Characters maneuver around them and discuss plans in their shadow. This rendered the Act III trio somewhat difficult to follow if you were seated on one of the sides of the theatre, given the lines of sight.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581279865/media/2020/02/HGO-AIDA-2020-LynnLane-90_iuksut.jpg){{% /md %}}

<figcaption> HGO Studio Alum Peixin Chen (front centre) and current HGO Studio artistDorothy Gal (back centre) in Houston Grand Opera's production of Aida, 2020. Photo: Lynn Lane.</figcaption>

</figure>

However, this focus on various technical aspects was rather upended when it came to the bigger crowd scenes, where the curtain would open fully to reveal a fuller scene upstage. However, this had a way of making the stage appear too small to hold everyone with all of the props taking up precious space. Although the various dancers had plenty of room to maneuver, one could perceive a tight fit as far as everyone else was concerned. The triumphal scene actually appeared to focus more on the solemnity and consequences of war, as various coffins were brought in for choristers to process around. This might have seemed like an overly fussy interpretation of this triumphal moment, but I found it almost evocative of the funeral games from the Iliad, minus weapons and chariot races.

The use of lighting and curtains was particularly effective when it came to the final tomb scene, where we only could see Aida ([Tamara Wilson](/scene/people/tamara-wilson/)) and Radames ([Russell Thomas](/scene/people/russell-thomas/)) through very small openings in the background wall. Amneris ([Melody Moore](/scene/people/melody-moore/)), mourning on the upper level at the modern gated and illuminated entrance of some tomb in the Valley of the Kings, evokes mental images of how much we, in our own days, enjoy conjuring up the past and looking into people’s private lives. The paradox is, of course, that this far back in history, anyone’s guess is as good as mine, and fantasy is as welcome as ever.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581279906/media/2020/02/HGO-AIDA-2020-LynnLane-3_cz66id.jpg){{% /md %}}

<figcaption>Russell Thomas (Radamès) in Houston Grand Opera's production of Aida, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Although Tamara Wilson as Aida had a tendency to wander about on the stage without a clear destination, particularly in the first half, I got a sense that this was more a liability of the production’s uneven concept than of her own abilities. My reasoning for this was that her rendering of "O patria mia" was, by contrast, very intimate and well-negotiated. One gets a sense in the first half of the piece that Verdi is himself getting tired of the old notion of artificial set pieces and is trying to get the necessary dramatic exposition out of the way as quickly as possible. This renders such intimate moments as this that much more poignant.

> Particularly fine in my opinion were the exquisitely sculpted, even Brucknerian, choral moments in the Act I ritual finale.

Tenor Russell Thomas, making his HGO debut in his first ever performance as Radamès, struck me as a very ardent singer indeed, always caring deeply about his expressive potential. Although "Celeste Aida" struck me as just a hair short of transcendence, it was very captivating nevertheless. The difficulties of uniting a melodic line with a chamber-music accompaniment were quite apparent here. I perceived him as more of a lyrical tenor with compelling dramatic moments than vice versa. In the expository ensembles of the beginning of Act I, he was very much the central figure around which the other characters were satellites. "Parking and barking" was a liability for all the characters in these moments, but only for brief moments when nobody could understand the simultaneous ensemble texts anyway.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581279928/media/2020/02/HGO-AIDA-2020-LynnLane-113_u9cpps.jpg){{% /md %}}

<figcaption>Tamara Wilson (Aida) and Melody Moore (Amneris) in Houston Grand Opera's production of Aida, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Melody Moore did an appreciable job of highlighting Amneris's dramatic arc, a challenging one given how the characters in this opera are defined only in a few dimensions, and hers in particular. Her very versatile instrument, however, was well-suited for making her sound docile, terrifying, jubilant, and haughty to the right people, though her motivations were at times inscrutable. I got the sense that the princess has lots of emotions that she has difficulty expressing in a healthy manner, and that her position is not conducive to her "people skills."

Reginald Smith, Jr. made a very finely developed Amonasro to the extent that that is even possible. He manipulated Aida so much and with such volatile emotions that I wondered to myself, "How did he become King of Ethiopia in the first place? Much byzantine maneuvering, clearly." Yet, he was a highly sympathetic figure as he was brought to Pharaoh in a monumental cage with his fellow warriors.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581279955/media/2020/02/HGO-AIDA-2020-LynnLane-177_t2x3v8.jpg){{% /md %}}

<figcaption>Russell Thomas (Radamès), Musa Ngqungwana (The King of Egypt), and Melody Moore (Amneris) in Houston Grand Opera's production of Aida, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Particularly fine in my opinion were the exquisitely sculpted, even Brucknerian, choral moments in the Act I ritual finale. This number featured Dorothy Gal as the Priestess, who clearly reveled in summoning forth the ritual dancers with her piercing, yet crystalline instrument. The cult-like, exclusive atmosphere of this scene (which had my favorite set design in the whole show) was certainly played up greatly. As the chorus members slowly became illuminated, they could be seen to be wearing some sort of hybrid uniform which combined a fez with antlers on top. I asked the choristers after the performance just what these were called, and not even they could agree on a single name! One might easily picture the Flintstones' Order of Loyal Water Buffaloes, just with heightened mystical undertones, and with red costumes, not blue. I could go on about the very fine choruses throughout the work, but this one will suffice to represent the lot.

> If only the canvas were bigger, then the experience would be transcendent. I suppose we must settle for transcendent music at least.

Bass [Musa Ngqungwana](/scene/people/musa-ngqungwana/) as the King of Egypt struck an appropriately dignified and imposing figure. I could feel a great deal of empathy with the subtle pressure his character faces at any given times. Peixin Chen as Ramfis was very much the hierarchical religious counterpart to secular authority that Verdi clearly reveled in. This being said, his costume made him somewhat of a faceless individual, and Chen took full advantage of this character’s unassailable position. Christopher Bozeka as the Messenger struck the right balance between urgency and credibility in his timbre.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581280002/media/2020/02/HGO-AIDA-2020-LynnLane-212_qe94mx.jpg){{% /md %}}

<figcaption>Tamara Wilson (Aida) and Russell Thomas (Radamès) in Houston Grand Opera's production of Aida, 2020. Photo: Lynn Lane.</figcaption>

</figure>

Throughout this opera, Patrick Summers was extremely effective at shaping the music. Particularly in the Act II triumphal finale, which can easily come at an audience like a massive wall of sound from both chorus and orchestra, he was very good at balancing the different sections of the orchestra. Even if one were seeing this opera for the first time, the shape of the musical numbers was clearly delineated and easy to follow. I could clearly tell if I were approaching a final climax, or merely the first of several. As Verdi in particular makes single musical numbers seem as multi-sectional and diverse in character as songs in a Schubert song cycle, I greatly appreciated this aspect.

In other words, the music of [_Aida_](https://www.houstongrandopera.org/aida) felt as experimental and dynamic as when it was first composed, in my perception. No wonder Tchaikovsky referred to it as representing a "Wagnerian" turn in Verdi's style, despite the lack of melodic interest he perceived in it. It was the sort of opera that perfectly encapsulates the conflicts between public and private spheres innate to depictions of grand situations. If only the canvas were bigger, then the experience would be transcendent. I suppose we must settle for transcendent music at least.