+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2020-03-02T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[_Agrippina_](https://www.metopera.org/season/2019-20-season/agrippina/) runs at The Metropolitan Opera through March 7."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1583169117/media/2020/03/sqAgrippina-MetOpera-MartySohl_qt1kqz.jpg"
primary_image_credit = "Joyce DiDonato in the title role of Handel’s Agrippina on the stairway to any empty throne. Photo: Marty Sohl/Met Opera."
related_articles = ["articles/ariodante-or-the-hebridean-handel.md", "articles/spectacle-art-dragus-maximus.md", "articles/talking-with-singers-kate-lindsey.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/matthew-rose.md", "scene/people/luca-pisaroni.md", "scene/people/harry-bicket.md", "scene/people/iestyn-davies.md", "scene/people/kate-lindsey.md", "scene/people/joyce-didonato.md"]
short_description = " This production doesn’t need that dumpster fire when it can rummage through an abundance of its own trash. Quite simply the elephant is an acknowledgment that bad behavior by people in power is timeless."
slug = "agrippina-and-the-elephants-in-the-room"
title = "Agrippina and the elephants in the room"
youtube_url = ""

+++
Agrippina is not alone. There are a couple of elephants in the room.

One of them references a political party mascot and fortunately it isn’t an orange blimp with yellow hair. This production doesn’t need that dumpster fire when it can rummage through an abundance of its own trash. Quite simply the elephant is an acknowledgment that bad behavior by people in power is timeless. So much so that David McVicar’s eye-popping updating of _Agrippina_, Handel’s sharp and melodic opera from 1709, is actually just keeping up.

The other elephant is the house in which _Agrippina_ plays. Let it  be known that it fits into the Metropolitan Opera, all 3800 seats of it, just fine. The acoustics have not been lamented from under the overhang in the orchestra or from the side boxes. And to be sure this bold and racy staging with its imposing yellow staircase, parade of bar flies and louche behavior reaches every nook and cranny of the house.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583169180/media/2020/03/Agrippina_12416s-L_rwx07z.jpg){{% /md %}}

<figcaption>Joyce DiDonato in the title role of Handel’s Agrippina, The Metropolitan Opera, 2020. Photo: Marty Sohl/Met Opera.</figcaption>

</figure>

It was a satire when it premiered in Venice and it remains so today. The story is annoyingly complicated only when attempting to sum it up. Watching it unfold is dark side fun. How surprising that Vincenzo Grimani’s uncommonly intelligent libretto thrills like a juicy episode of _Scandal_. _Agrippina_ was Handel’s first big hit and paved the way for his London ventures.

> The ensemble is precise, elegant and bright. 

Agrippina is the empress of Rome. She’d like her dim-witted son Nerone (Nero) from a previous marriage to succeed her current husband, Emperor Claudio. (Claudius) Informed that Claudio may be lost at sea Agrippina positions Nerone for the top job by encouraging him to do giveaways in the community. He finds the public repugnant but polls well just the same. In the meantime Agrippina enlists support from ranking military and political types with the promise of sexual favors. There are strings attached as these gentlemen will find out. Unfortunately for Agrippina, Claudio is saved by the heroic warrior Ottone (Otho). Claudio slips back into Rome unbeknownst to Agrippina for an assignation with Poppea, blithely billed in the program as a Roman lady. Claudio is so grateful that he offers Ottone the throne upon his retirement. Agrippina has her work cut out for her and it doesn’t help that Poppea and Ottone are in love.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583169199/media/2020/03/Agrippina_2595s-L_jy5wq2.jpg){{% /md %}}

<figcaption>Kate Lindsey as Nerone and Brenda Rae as Poppea in Handel’s Agrippina, The Metropolitan Opera, 2020. Photo: Marty Sohl/Met Opera.</figcaption>

</figure>

Joyce DiDonta, the reigning Handelian star of her generation, owns the title role for the foreseeable future. The mezzo soprano is all-out wonderful, sometimes wildly so in a part that demands acute comic antics and dramatic turns on top of virtuoso singing. Her claim to the part rests not only with her performances on the stages of the MET and the Royal Opera but in a new and highly touted [Warner Classics recording](https://joycedidonato.com/recordings/handel-agrippina/).

Unleashing her flawless technique at the MET, DiDonato navigates the thrill rides that are her arias with boundless assurance. It’s as if Agrippina’s penchant for the boozy sashay, lusty asides and treacherous posturing propel her singing. Film buffs will be reminded of the great Norma Shearer who in a series of pre-code films parlayed sex, an independent attitude and high spirits to triumphant ends.

> DiDonato’s technique continues to reign on the recording.

But constant uncertainty haunts Agrippina. At least she’s aware of her actions. That we find ourselves liking this women despite her unrelenting perfidy shows just how well she manages her affairs not to mention the local news cycle. Her single- mindedness is enviable. DiDonato’s stirring rendition of “Pensieri, voi mi tormentate” in Act II is equal parts torment, frustration and determination. It is her eleven o’clock number— the MET is on Broadway after all— and we are in the palm of her hand.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583169278/media/2020/03/Agrippina_13012s-L_i4kl4e.jpg){{% /md %}}

<figcaption>Kate Lindsey as Nerone in Agrippina, The Metropolitan Opera, 2020. Photo: Marty Sohl / Met Opera.</figcaption>

</figure>

Adolescent arrogance, sullenness and mental thickness mark mezzo-soprano [Kate Lindsey](/talking-with-singers-kate-lindsey/)’s Nerone. She brings so much more than the mannered reticence often associated with trouser-role parts. Who knew that Nerone could cause such havoc just by being a misguided teen-age boy? That Lindsey navigates singing while doing one-handed push-ups is impressive and unnerving. Negotiating a gigantic line of cocaine she sings “Come nube che fugge dal vento” with all of the impudent rage of a punk whose drug supplier has been busted.

Making her Met debut as Poppea, [Brenda Rae](/talking-with-singers-brenda-rae/) possesses a light soprano that often contrasts nicely with the mezzos on stage. Her acting outweighs her singing and it helps when she rips into a heart shaped box of chocolates and swills Verve Clicquot while singing “Se going un dispetto,” her aria to spite. Rae’s comic timing is brilliant but the voice needs more heft. Claudius and Ottone, poor guys, have much in common not the least of which is their shared attraction to Poppea. They would rather be in love than rule. As Claudio bass [Matthew Rose](/scene/people/matthew-rose/) struts about like a preoccupied executive, embarrassed and awkward when out of his element. Within the nicely controlled focus to his voice is a bit of a clown. Ottone may be a heroic warrior but he’s more the callow sailor on shore leave when it comes to Poppea. Countertenor [Iestyn Davies](/scene/people/iestyn-davies/) is achingly restrained. He brings a lovely poignancy to his mournful Act III aria “Tacero purche fedele.”

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583169309/media/2020/03/Agrippina_0855s-L_lfb4bo.jpg){{% /md %}}

<figcaption>Iestyn Davies as Ottone in Agrippina, The Metropolitan Opera, 2020. Photo: Marty Sohl / Met Opera.</figcaption>

</figure>

DiDonato’s technique continues to reign on the recording. She sings with enough fire to conjure visual images. Countertenor Franco Fagloli’s sneering nastiness as Nerone is quite a contrast to Lindsey’s high-energy soprano. The nobility that bass [Luca Pisaroni](/talking-with-singers-luca-pisaroni/) brings to Claudio leaves a much different impression than Rose’s horny awkwardness. Elsa Benoit’s Poppea has a tender moment expressing her love for Ottone with “Bel piacere.” Casting her opposite Davies might have enhanced the concept of genuine romance amidst the squalor on stage. Countertenor [Jakub Jozef Orlinski](/scene/people/jakub-josef-orlinski/)’s Ottone is more the gallant hero while Davies portrays one of introspective longing.

> Purists can take heart in the knowledge that the modern instruments, the size of the house and the updated staging coalesce in complete harmony.

II Pomo d’Oro, led by Maxim Emelyanychev, is a baroque/classical period group devoted to authentic performances. The subtle joy and hints of mischief that the group brings to the recording offer sweet and tangy rewards throughout.

Back in the opera house the mighty MET orchestra has been downsized to baroque proportions under the expert leadership of Handel specialist, Harry Bicket. The ensemble is precise, elegant and bright. Despite the use of primarily modern instruments the house is saturated with a conscious sense of the baroque. The versatility and expertise of this ensemble comes as no surprise. They are big when they need to be which is most of the season but their polish and refinement run deep.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583169331/media/2020/03/Agrippina-Recording_Studio_Paul_Bates_lclyrg.jpg){{% /md %}}

<figcaption>Elsa Benoit, Joyce DiDonato, Franco Fagloli and Jakub Jozef Orlinski in the studio for the Warner Classics recording of Handel’s Agrippina. Photo: Paul Bates.</figcaption>

</figure>

Bicket is busy in the pit accompanying the recitatives and conducting from the harpsichord which is joined in the excellent continuo by cello, theorbo, archlute and guitar. Purists can take heart in the knowledge that the modern instruments, the size of the house and the updated staging coalesce in complete harmony. In _Agrippina_ such harmony is strictly limited to the musical sense of the word. If history teaches us anything, we know that the rest is chaos. On to _Giulio Cesare_ in 2020-21.