+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = 2022-04-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "SDO's production of [_Aging Magician_](https://www.sdopera.org/season/2019-2020-season/aging-magician) runs at the Balboa Theatre in San Diego, May 13-14, 2022."
preamble = "**Note to readers:** this interview was originally published in March, 2020, shortly before San Diego Opera's _Aging Magician_ (and most other things) was postponed. The production has returned as part of SDO's 2021-22 line-up, and it's set to run at the Balboa Theatre for three performances, May 13-14, 2022. Contributor Eva Cahen spoke with librettist Rinde Eckert back in 2020, and it's an interview that ages well:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1583344153/media/2020/03/sqSDOAgingMagicianASU_0485_oexepf.jpg"
primary_image_credit = "Aging Magician at ASU. Photo by Jill Steinberg."
related_articles = ["articles/talking-with-singers-stephen-costello.md", "articles/8-contemporary-roles-to-covet.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = []
short_description = "\"After years of creating work after work, it becomes your life,\" he says about why he is an artist. \"Initially, I was drawn to things just because I was fascinated by ideas. The traditional world was not where I belonged. I knew I wanted to be in the arts and I had an impulse to perform.\""
slug = "magic-everywhere-in-sdos-aging-magician"
title = "Magic everywhere in SDO's Aging Magician"
youtube_url = ""

+++
"Our lives are very large worlds within very small frames. If you delve into us, we’re all heroes in our own story," says Rinde Eckert, the librettist of [_Aging Magician_](https://www.sdopera.org/season/2021-2022-season/aging-magician), which will be performed as part of San Diego Opera's dētour series for three West Coast premiere performances May 13 and 14. Eckert is also the titular Magician of the opera, which traces the large-world life and journey of Harold, a clockmaker in New York, who is also writing a book about an aging magician that he wants to leave as a legacy. As the story unfolds, at times the lines become blurred between Harold and the magician.

> "He's creating a whole world in his shop."

Eckert is an artist with many talents. He started out as an opera singer but says he found that it was not for him. As a musician, he has composed, directed, and written numerous pieces and has performed in many of them. He has won many awards and was a 2007 Pulitzer Prize finalist for _Orpheus X_.  Other awards include a Guggenheim Fellowship and a Grammy Award. "I always thought of myself as a talented dilettante," says Eckert recounting how each accomplishment in his career led to a new one.

"After years of creating work after work, it becomes your life," he says about why he is an artist. "Initially, I was drawn to things just because I was fascinated by ideas. The traditional world was not where I belonged. I knew I wanted to be in the arts and I had an impulse to perform."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583344115/media/2020/03/SDOAgingMagicianASU_0499_ujqktm.jpg){{% /md %}}

<figcaption>Aging Magician at ASU. Photo by Jill Steinberg.</figcaption>  
</figure>

People began noticing him during a 10-year collaboration creating operas with Paul Dresher, he says. "Then you find a place that is full of people you enjoy being with and spending time with and thinking through things with and looking at problems with. You share your talents and it becomes very exciting. After a while, you stop asking the question \[about why\] because you're all in the same room and it becomes the natural world for us."

The character of Harold is well in line with Eckert's themes. "After you've created a lot of work, you look at the dynamics of each work and there are similarities. You see characters that keep on reappearing in different ways. I tend to write about low status heroes who then become fixated on an idea. Through fixation, they become grand figures in their minds. That's a theme of mine, taking someone like Harold who's a clockmaker, and in his little shop, this giant world is being imagined. He's creating a whole world in his shop."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583344129/media/2020/03/SDOAgingMagicianASU_0584_etw06q.jpg){{% /md %}}

<figcaption>Aging Magician at ASU. Photo by Jill Steinberg.</figcaption>  
</figure>

It took years of trial and error to create the version of _Aging Magician_ that will be performed in San Diego. It started out as a collaboration with composer Paola Prestini and director Julian Crouch. An important part of the project since its early days was the Brooklyn Youth Chorus, led by its founder and artistic director Dianne Berkun Menaker. The chorus will also be part of the San Diego Opera performance. They have performed and recorded with major orchestras such as the New York Philharmonic, Los Angeles Philharmonic, and London Symphony Orchestra. and stars that include Sir Elton John and Barbra Streisand. They range in age between 13 and 17. In the years performing the piece, the young singers have developed a deep relationship with the main character of _Aging Magician_. "Stay with me Harold," a line from the opera has become a line the kids often use with each other when one of them becomes distracted during rehearsals, says Menaker. The role of the children in _Aging Magician_ is to usher Harold on his journey, into the afterlife.

Menaker describes her own and the children's motivation for singing as "a combination of physical sensation, the aesthetic element, and a love of the sound."

"At the purest level it is the thrill of the sheer beauty of the sound that the chorus makes, which is why I was drawn to doing this work professionally. It is the sound of the young voice when it's trained to its optimal level, like our ensemble. It’s a unique sound."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583344142/media/2020/03/SDOAgingMagicianASU_0517_hcpuyl.jpg){{% /md %}}

<figcaption>Aging Magician at ASU. Photo by Jill Steinberg.</figcaption>  
</figure>

She has developed a trademarked teaching pedagogy called Cross-Choral Training® that has two components – the voice training program and the music literacy program. The training has a focus on performing, music literacy, sight reading, and very rigorous and professional voice training. The concert ensemble puts in almost seven hours a week over three days not including the performances.

> "They have developed a deep understanding of the greater meaning behind the piece."

The performing ensemble in _Aging Magician_ will have 26 young singers, though the chorus has 700 members spread out across different levels and ensembles. Many of the singers continue with music after graduation in college or as part of community choruses. Counter-tenor [Aryeh Nussbaum Cohen](/scene/people/aryeh-nussbaum-cohen/) is a notable graduate of the program.

A substantial part of the chorus' repertoire is new music they have commissioned like _Black Mountain Songs_ and _Silent Voices_, and world premieres by contemporary composers. "These pieces are momentous in the lives of these kids," says Menaker. "They embrace and become immersed in new projects."

The older graduating chorus members convey the meaning of projects to new members. With _Aging Magician_, says Menaker, over the years "they've watched Rinde in his amazing acting and bringing the character to life. They have developed a deep understanding of the greater meaning behind the piece."