+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-09-11T12:48:00-04:00"
lastmod = "2017-09-18T13:57:00-04:00"
preamble = "Canadian jazz and cabaret singer [Adi Braun](/scene/people/adi-braun/) has released her fifth album, [*Adi Braun - Moderne Frau*](https://www.rcmusic.com/performing/event/1718/moderne-frau), which pays impressive homage to the unmistakable music of [Weimar Berlin](/vergesst-uns-nicht-adi-braun-on-weimar-cabaret/). Between the two World Wars (1918-1933), Berlin was a buzzing place for the arts and sciences, for intellectuals and innovators; the cabaret scene was strong, and largely fuelled by women. \n\nIn *Moderne Frau*, Braun features the music of leading German composers Kurt Weill, Franz Grothe, and Mischa Spoliansky; also on the album are three original songs, all of which are catchy, touching, and uncannily stylish. Braun and her band have fun with this music, and it's hard to turn down a chance to hear a new voice bringing to life classics like \"Mack the Knife\", \"Speak Low\", and \"Surabaya Johnny\".\n\nAhead of her [CD launch concert](https://www.rcmusic.com/performing/event/1718/moderne-frau) on **October 22, 7:30pm at the RCM's Temerty Theatre**, we spoke with Braun about the familiar political climate that inspired this music, and her fascination with the women of Weimar cabaret.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505607325673/MODERNE%20FRAU%20FINAL%20COVER.jpg.jpg"
publishDate = "2017-09-18T13:51:00-04:00"
related_articles = ["articles/vergesst-uns-nicht-adi-braun-on-weimar-cabaret.md","articles/in-review-the-seven-deadly-sins.md"]
related_people = ["scene/people/adi-braun.md"]
short_description = "&quot;Any form of art is always influenced by the socio-political climate of its time.  Certainly the freedom gained by the abolishing of the strict Wilhelmine regime was one part in creating a much more liberal and fertile ground for artistic expression. Yet with the rise of the Nazis artists saw and feared what was to come and expressed this in their works of art.  The courage that performers had to give these often very risqué songs life is admirable.&quot;"
slug = "adi-braun-the-moderne-frau"
title = "Adi Braun, the Moderne Frau"
+++

## Why have you been so drawn to Weimar cabaret?
 
The Weimar era (1918 – 1933) was filled with great societal and artistic daring.  For a relatively short period, Germans were freed from the constraints and censorship of the Wilhelmine Regime which had preceded this epoch.  This freedom and emancipation of a people was felt in all sectors of life but most profoundly in the world of the arts.  When I researched this era, I was astounded to find that women stood at the forefront of a unique movement and became trailblazers for the generations of female artists that would follow.  

In German cabaret there was a push to offer songs that had strong social as well as artistic implications, often being very critical of the times.  Composers, lyricists and performers worked closely together in order to create bold new works that were meant to elicit strong reactions from the public.  There were many types of cabarets…socio-political ones, those that had more of a vaudevillian content, comedy cabarets and many others.  Female vocalists were not only stars on cabaret stages but also had central roles behind the scenes as cabaret owners and managers, which was unthinkable before this time.
 
## How do your original songs fit in with the musical and social aesthetic of the selections by Weill, Grothe & Spoliansky?

My title song *Moderne Frau* was inspired by the new advances that women experienced during the Weimar era and is laced with a good dose of humour. *Josephine* is dedicated to the great Josephine Baker who had become a big star in France and then Germany (Berlin) during the Weimar era as well.  After being dismissed in her home country she found new footing and great admirers abroad.  Her uninhibited performing style was a liberating experience for women who saw her on stage. *Gestern* is dedicated to forbidden love during Nazi Germany and tells of an imagined love story between a German non-Jewish woman and a German Jewish woman. In the advance of the Nazi regime during the early 1930's such a relationship would have been impossible to sustain.

## Where do you think the unique sounds and materials of Weimar cabaret songs come from? How difficult is it to "recreate" that in a 21st-century environment?

Very good question.  Any form of art is always influenced by the socio-political climate of its time.  Certainly the freedom gained by the abolishing of the strict Wilhelmine regime was one part in creating a much more liberal and fertile ground for artistic expression. Yet with the rise of the Nazis artists saw and feared what was to come and expressed this in their works of art.  The courage that performers had to give these often very risqué songs life is admirable.  

I see quite a few parallels in our current political climate …extremism is on the rise and many people in this world still suffer from oppression.  Sadly the struggle for freedom and equality is age-old and an ever repeating theme.
 
## What are you most proud of in *Moderne Frau*?

So many things…top of the list would be the amazing creative collaboration I had with all of my musicians on the CD.  Everyone had an open musical mind at all times and everyone brought the most wondrous musical gifts to this project.  I am proud to have added three of my original songs to the mix and am planning on writing many more Weimar-inspired songs to perhaps one day create a musical.

>Moderne Frau is available for purchase in October, 2017, through [Adi Braun's website](https://www.adibraun.com/).
